/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SWTUtils {
    public static GridLayout createGrid(int columns, int marginwidth, int marginheight) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        return layout;
    }

    public static GridData createGridData(int fill, int hspan) {
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        return gd;
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)SWTUtils.createGrid(columns, marginwidth, marginheight));
        g.setFont(font);
        g.setLayoutData((Object)SWTUtils.createGridData(fill, hspan));
        return g;
    }

    public static Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(parent.getFont());
        g.setLayoutData((Object)SWTUtils.createGridData(fill, hspan));
        return g;
    }

    public static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Label createLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = SWTUtils.createGridData(768, hspan);
        gd.grabExcessHorizontalSpace = false;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Label createWrapLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        SWTUtils.setButtonDimensionHint(button);
        return button;
    }

    public static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTUtils.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }
}

