/*
 * Decompiled with CFR 0.152.
 */
package com.jorisaerts.eclipse.rcp.environment.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class SerializerUtil {
    public static Object fromString(String s) throws IOException, ClassNotFoundException {
        if (null == s) {
            return null;
        }
        byte[] data = Base64.getDecoder().decode(s.getBytes());
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static Object fromStringSafe(String s) {
        try {
            return SerializerUtil.fromString(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return new String(Base64.getEncoder().encode(baos.toByteArray()));
    }

    public static String toStringSafe(Serializable o) {
        try {
            return SerializerUtil.toString(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

