/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.parser;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.views.Interpretations;
import org.eclipse.cdt.embsysregview.views.TreeElement;
import org.eclipse.cdt.embsysregview.views.TreeField;
import org.eclipse.cdt.embsysregview.views.TreeGroup;
import org.eclipse.cdt.embsysregview.views.TreeParent;
import org.eclipse.cdt.embsysregview.views.TreeRegister;
import org.eclipse.cdt.embsysregview.views.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.views.Utils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class RegisterXMLParser {
    private String store_board;

    private Document OpenXML() throws JDOMException, IOException {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String store_architecture = store.getString("architecture");
        String store_vendor = store.getString("vendor");
        String store_chip = store.getString("chip");
        this.store_board = store.getString("board");
        URL fileURL = Utils.getFileURL(store_architecture, store_vendor, store_chip);
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(false);
        return builder.build(fileURL);
    }

    public TreeParent LoadXML() throws ParseException, DataConversionException {
        Document doc;
        TreeParent tempRoot = new TreeParent("", "");
        try {
            doc = this.OpenXML();
        }
        catch (Exception e) {
            return tempRoot;
        }
        Element root = doc.getRootElement();
        if (root.getName() == "device") {
            return this.ParseSVD(root, tempRoot);
        }
        return this.ParseXML(root, tempRoot);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeParent ParseSVD(Element root, TreeParent tempRoot) throws ParseException, DataConversionException {
        TreeElement oldTreeGroup = null;
        Element peripherals = root.getChild("peripherals");
        if (peripherals == null) return tempRoot;
        List grouplist = peripherals.getChildren("peripheral");
        for (Element group : grouplist) {
            Element attr_rgname = group.getChild("name");
            if (attr_rgname == null) {
                throw new ParseException("peripheral requires name", 1);
            }
            String rgname = attr_rgname.getValue();
            Element element_baseAddress = group.getChild("baseAddress");
            if (element_baseAddress == null) {
                throw new ParseException("peripheral requires baseAddress", 1);
            }
            String baseAddress = element_baseAddress.getValue();
            Element attr_gdescription = group.getChild("description");
            Object gdescription = attr_gdescription != null ? attr_gdescription.getValue().replaceAll("( )+", " ") : "";
            Attribute attr_derivedFrom = group.getAttribute("derivedFrom");
            if (attr_derivedFrom != null) {
                String derivedFrom = attr_derivedFrom.getValue();
                for (Element linkedgroup : grouplist) {
                    String expression;
                    Element attr_lname = linkedgroup.getChild("name");
                    if (attr_lname == null) {
                        throw new ParseException("derived peripheral requires name of super peripheral", 1);
                    }
                    String lname = attr_lname.getValue();
                    if (!lname.equals(derivedFrom)) continue;
                    group = linkedgroup;
                    Element attr_lgdescription = linkedgroup.getChild("description");
                    if (attr_lgdescription == null || !((String)gdescription).isEmpty() || !((String)(gdescription = attr_lgdescription.getValue().replaceAll("( )+", " "))).matches(expression = ".*[0-9]$") || ((String)gdescription).charAt(((String)gdescription).length() - 1) != lname.charAt(lname.length() - 1)) break;
                    gdescription = ((String)gdescription).substring(0, ((String)gdescription).length() - 1) + rgname.charAt(rgname.length() - 1);
                    break;
                }
            }
            TreeElement obj_group = null;
            Element attr_gname = group.getChild("groupName");
            if (attr_gname != null) {
                String gname = attr_gname.getValue();
                for (TreeElement te : tempRoot.getChildren()) {
                    if (!te.getName().equals(gname) || !(te instanceof TreeGroup)) continue;
                    obj_group = (TreeGroup)te;
                    break;
                }
                if (obj_group == null) {
                    expression = ".*[0-9]$";
                    Object tmpgdescription = ((String)gdescription).matches(expression) && ((String)gdescription).charAt(((String)gdescription).length() - 1) == rgname.charAt(rgname.length() - 1) ? ((String)gdescription).substring(0, ((String)gdescription).length() - 1).trim() : gdescription;
                    obj_group = new TreeGroup(gname, (String)tmpgdescription);
                    tempRoot.addChild(obj_group);
                }
                oldTreeGroup = obj_group;
            } else {
                expression = "_?[0-9]+$";
                String uniqgroup = rgname.replaceAll(expression, "");
                if (oldTreeGroup != null && oldTreeGroup.getName().equals(uniqgroup)) {
                    obj_group = oldTreeGroup;
                } else {
                    obj_group = new TreeGroup(uniqgroup, (String)gdescription);
                    tempRoot.addChild(obj_group);
                    oldTreeGroup = obj_group;
                }
            }
            TreeRegisterGroup obj_registergroup = new TreeRegisterGroup(rgname, (String)gdescription);
            ((TreeParent)obj_group).addChild(obj_registergroup);
            Element registers = group.getChild("registers");
            if (registers == null) continue;
            List registerlist = registers.getChildren("register");
            for (Element register : registerlist) {
                Element attr_raccess;
                Element attr_rname = register.getChild("name");
                if (attr_rname == null) {
                    throw new ParseException("register requires name", 1);
                }
                String rname = attr_rname.getValue();
                Element attr_rdescription = register.getChild("description");
                String rdescription = attr_rdescription != null ? attr_rdescription.getValue() : "";
                Element attr_roffsetaddress = register.getChild("addressOffset");
                if (attr_roffsetaddress == null) throw new ParseException("register requires address", 1);
                long raddress = attr_roffsetaddress.getValue().startsWith("0x") ? Long.parseLong(attr_roffsetaddress.getValue().substring(2), 16) : Long.parseLong(attr_roffsetaddress.getValue());
                Element attr_rresetvalue = register.getChild("resetValue");
                long rresetvalue = 0L;
                if (attr_rresetvalue != null && attr_rresetvalue.getValue() != "") {
                    try {
                        rresetvalue = attr_rresetvalue.getValue().startsWith("0x") ? Long.parseLong(attr_rresetvalue.getValue().substring(2), 16) : Long.parseLong(attr_rresetvalue.getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String raccess = (attr_raccess = register.getChild("access")) != null ? attr_raccess.getValue() : "RO";
                raccess = raccess.equals("read-write") ? "RW" : raccess;
                raccess = raccess.equals("write-only") ? "WO" : raccess;
                raccess = raccess.equals("read-only") ? "RO" : raccess;
                raccess = raccess.equals("read-write") ? "RW" : raccess;
                Element attr_rsize = register.getChild("size");
                int rsize = attr_rsize != null ? (attr_rsize.getValue().startsWith("0x") ? Integer.parseInt(attr_rsize.getValue().substring(2), 16) / 8 : Integer.parseInt(attr_rsize.getValue()) / 8) : 4;
                long lbaseAddress = Long.parseLong(baseAddress.substring(2), 16);
                Element attr_rdim = register.getChild("dim");
                int rdim = attr_rdim != null ? Integer.parseInt(attr_rdim.getValue(), 10) : 1;
                Element attr_rdimIncrement = register.getChild("dimIncrement");
                int rdimIncrement = attr_rdimIncrement != null ? (attr_rdimIncrement.getValue().startsWith("0x") ? Integer.parseInt(attr_rdimIncrement.getValue().substring(2), 16) : Integer.parseInt(attr_rdimIncrement.getValue(), 10)) : 0;
                Element attr_rdimIndex = register.getChild("dimIndex");
                String rdimIndex = attr_rdimIndex != null ? attr_rdimIndex.getValue() : "";
                if (rdim > 1) {
                    System.out.println("DIM Register: " + rname + " " + rdescription + " " + lbaseAddress + " " + raddress + " " + rresetvalue + " " + raccess + " " + rsize + " " + rdim + " " + rdimIncrement + " " + rdimIndex);
                }
                int begIdx = 0;
                int commaIdx = 0;
                Boolean isCommaList = rdimIndex.indexOf(44, 0) != -1;
                Boolean isRangeList = rdimIndex.indexOf(45, 0) != -1;
                int rangeOffset = 0;
                if (isRangeList.booleanValue()) {
                    rangeOffset = Integer.parseInt(rdimIndex.substring(0, rdimIndex.indexOf(45)));
                }
                for (int i = 0; i < rdim; ++i) {
                    TreeRegister obj_register;
                    if (rdim > 1) {
                        String r;
                        if (isCommaList.booleanValue()) {
                            commaIdx = i < rdim - 1 ? rdimIndex.indexOf(44, begIdx) : rdimIndex.length();
                            if (commaIdx != -1) {
                                r = rdimIndex.substring(begIdx, commaIdx);
                                begIdx = commaIdx + 1;
                            } else {
                                r = "x";
                                begIdx = 0;
                            }
                        } else if (isRangeList.booleanValue()) {
                            r = Integer.toString(i + rangeOffset);
                            begIdx = 0;
                        } else {
                            r = Integer.toString(i);
                            begIdx = 0;
                        }
                        String s = rname.replace("%s", r);
                        obj_register = new TreeRegister(s, rdescription, "0x" + Long.toHexString(lbaseAddress + raddress), rresetvalue, raccess, rsize);
                        lbaseAddress += (long)rdimIncrement;
                    } else {
                        obj_register = new TreeRegister(rname, rdescription, "0x" + Long.toHexString(lbaseAddress + raddress), rresetvalue, raccess, rsize);
                    }
                    System.out.println("Register: " + rname + " " + rdescription + " " + lbaseAddress + " " + raddress + " " + rresetvalue + " " + raccess + " " + rsize);
                    obj_registergroup.addChild(obj_register);
                    Element fields_element = register.getChild("fields");
                    if (fields_element == null) continue;
                    List fieldlist = fields_element.getChildren("field");
                    for (Element field : fieldlist) {
                        byte fbitlength;
                        byte fbitoffset;
                        Element attr_fname = field.getChild("name");
                        if (attr_fname == null) {
                            throw new ParseException("field requires name", 1);
                        }
                        String fname = attr_fname.getValue();
                        Element attr_fdescription = field.getChild("description");
                        String fdescription = attr_fdescription != null ? attr_fdescription.getValue() : "";
                        Element attr_fbitoffset = field.getChild("bitOffset");
                        if (attr_fbitoffset != null) {
                            fbitoffset = Byte.parseByte(attr_fbitoffset.getValue());
                            Element attr_fbitlength = field.getChild("bitWidth");
                            if (attr_fbitlength == null) throw new ParseException("field requires bitlength", 1);
                            fbitlength = Byte.parseByte(attr_fbitlength.getValue());
                        } else {
                            Element attr_fbitrange = field.getChild("bitRange");
                            if (attr_fbitrange != null) {
                                String range_string = attr_fbitrange.getValue();
                                String range = range_string.substring(1, range_string.length() - 1);
                                String[] rangeArray = range.split(":");
                                fbitoffset = Byte.valueOf(rangeArray[1]);
                                fbitlength = (byte)(Byte.valueOf(rangeArray[0]) - Byte.valueOf(rangeArray[1]) + 1);
                            } else {
                                Element element_lsb = field.getChild("lsb");
                                Element element_msb = field.getChild("msb");
                                if (element_lsb == null || element_msb == null) throw new ParseException("field requires some sort of start-end bit marker", 1);
                                fbitoffset = Byte.valueOf(element_lsb.getValue());
                                fbitlength = (byte)(Byte.valueOf(element_msb.getValue()) - Byte.valueOf(element_lsb.getValue()) + 1);
                            }
                        }
                        Interpretations interpretations = new Interpretations();
                        Element enumeratedValues = field.getChild("enumeratedValues");
                        if (enumeratedValues != null) {
                            List interpretationlist = enumeratedValues.getChildren("enumeratedValue");
                            for (Element interpretation : interpretationlist) {
                                long key;
                                Element attr_key = interpretation.getChild("value");
                                if (attr_key == null) throw new ParseException("enumeratedValue requires value", 1);
                                if (attr_key.getValue().startsWith("0x")) {
                                    key = Long.valueOf(attr_key.getValue().substring(2), 16);
                                } else if (attr_key.getValue().startsWith("#")) {
                                    String str = attr_key.getValue().substring(1);
                                    str = str.replaceAll("x", "0");
                                    key = Long.valueOf(str, 2);
                                } else {
                                    key = Long.valueOf(attr_key.getValue());
                                }
                                Element attr_name = interpretation.getChild("name");
                                if (attr_name == null) {
                                    throw new ParseException("enumeratedValue requires name", 1);
                                }
                                String name = attr_name.getValue();
                                Element attr_text = interpretation.getChild("description");
                                String text = attr_text != null ? attr_text.getValue() : name;
                                interpretations.addInterpretation(key, name + ": " + text);
                            }
                        }
                        System.out.println("Field: " + fname + " " + fdescription + " " + fbitoffset + " " + fbitlength + " " + String.valueOf(interpretations));
                        TreeField obj_field = new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations);
                        interpretations.setTreeField(obj_field);
                        obj_register.addChild(obj_field);
                    }
                }
            }
        }
        return tempRoot;
    }

    private TreeParent ParseXML(Element root, TreeParent tempRoot) throws ParseException, DataConversionException {
        List grouplist = root.getChildren("group");
        for (Element group : grouplist) {
            Attribute attr_gname = group.getAttribute("name");
            if (attr_gname == null) {
                throw new ParseException("group requires name", 1);
            }
            String gname = attr_gname.getValue();
            Attribute attr_gdescription = group.getAttribute("description");
            String gdescription = attr_gdescription != null ? attr_gdescription.getValue() : "";
            TreeGroup obj_group = new TreeGroup(gname, gdescription);
            tempRoot.addChild(obj_group);
            List registergrouplist = group.getChildren();
            for (Element registergroup : registergrouplist) {
                Attribute attr_rgname = registergroup.getAttribute("name");
                if (attr_rgname == null) {
                    throw new ParseException("registergroup requires name", 1);
                }
                String rgname = attr_rgname.getValue();
                Attribute attr_rgdescription = registergroup.getAttribute("description");
                String rgdescription = attr_rgdescription != null ? attr_rgdescription.getValue() : "";
                TreeRegisterGroup obj_registergroup = new TreeRegisterGroup(rgname, rgdescription);
                obj_group.addChild(obj_registergroup);
                List registerlist = registergroup.getChildren();
                for (Element register : registerlist) {
                    Attribute attr_rname = register.getAttribute("name");
                    if (attr_rgname == null) {
                        throw new ParseException("register requires name", 1);
                    }
                    String rname = attr_rname.getValue();
                    Attribute attr_rdescription = register.getAttribute("description");
                    String rdescription = attr_rdescription != null ? attr_rdescription.getValue() : "";
                    Attribute attr_roffsetaddress = register.getAttribute("address");
                    if (attr_roffsetaddress == null) {
                        throw new ParseException("register requires address", 1);
                    }
                    String raddress = attr_roffsetaddress.getValue();
                    Attribute attr_rresetvalue = register.getAttribute("resetvalue");
                    long rresetvalue = attr_rresetvalue != null && attr_rresetvalue.getValue() != "" ? Long.parseLong(attr_rresetvalue.getValue().substring(2), 16) : 0L;
                    Attribute attr_raccess = register.getAttribute("access");
                    String raccess = attr_raccess != null ? attr_raccess.getValue() : "RO";
                    Attribute attr_rsize = register.getAttribute("size");
                    int rsize = attr_rsize != null ? Integer.parseInt(attr_rsize.getValue()) : 4;
                    TreeRegister obj_register = new TreeRegister(rname, rdescription, raddress, rresetvalue, raccess, rsize);
                    obj_registergroup.addChild(obj_register);
                    Element register_description = register.getChild("description");
                    if (register_description != null) {
                        rdescription = register_description.getText();
                        obj_register.setDescription(rdescription);
                    }
                    List fieldlist = register.getChildren("field");
                    for (Element field : fieldlist) {
                        Attribute attr_fboard_id = field.getAttribute("board_id");
                        String fboard_id = attr_fboard_id != null ? attr_fboard_id.getValue() : "";
                        if (!fboard_id.equals("") && !fboard_id.equals(this.store_board)) continue;
                        Attribute attr_fname = field.getAttribute("name");
                        if (attr_fname == null) {
                            throw new ParseException("field requires name", 1);
                        }
                        String fname = attr_fname.getValue();
                        Attribute attr_fdescription = field.getAttribute("description");
                        String fdescription = attr_fdescription != null ? attr_fdescription.getValue() : "";
                        Attribute attr_fbitoffset = field.getAttribute("bitoffset");
                        if (attr_fbitoffset == null) {
                            throw new ParseException("field requires bitoffset", 1);
                        }
                        byte fbitoffset = Byte.parseByte(attr_fbitoffset.getValue());
                        Attribute attr_fbitlength = field.getAttribute("bitlength");
                        if (attr_fbitlength == null) {
                            throw new ParseException("field requires bitlength", 1);
                        }
                        byte fbitlength = Byte.parseByte(attr_fbitlength.getValue());
                        Element field_description = field.getChild("description");
                        if (field_description != null) {
                            fdescription = field_description.getText();
                        }
                        Interpretations interpretations = new Interpretations();
                        List interpretationlist = field.getChildren("interpretation");
                        for (Element interpretation : interpretationlist) {
                            long key;
                            Attribute attr_key = interpretation.getAttribute("key");
                            if (attr_key != null) {
                                String skey = attr_key.getValue();
                                key = skey.startsWith("0x") ? Long.parseLong(skey.substring(2), 16) : Long.parseLong(skey);
                            } else {
                                throw new ParseException("interpretation requires key", 1);
                            }
                            Attribute attr_text = interpretation.getAttribute("text");
                            if (attr_text == null) {
                                throw new ParseException("interpretation requires text", 1);
                            }
                            String text = attr_text.getValue();
                            interpretations.addInterpretation(key, text);
                        }
                        TreeField obj_field = new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations);
                        interpretations.setTreeField(obj_field);
                        obj_register.addChild(obj_field);
                    }
                }
            }
        }
        return tempRoot;
    }
}

