/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.views.TreeElement;
import org.eclipse.cdt.embsysregview.views.TreeField;
import org.eclipse.cdt.embsysregview.views.TreeRegister;
import org.eclipse.cdt.embsysregview.views.Utils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BinaryButtonsCellEditor
extends CellEditor {
    Composite composite;
    TreeElement element;
    TreeViewer viewer = null;
    boolean store_bitbuttons;
    private Button[] b;

    public BinaryButtonsCellEditor(Composite parent) {
        super(parent);
    }

    public BinaryButtonsCellEditor(Composite parent, TreeViewer viewer) {
        super(parent);
        this.viewer = viewer;
    }

    private void updateViewer(final Object Element2) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Element2 == null) {
                    BinaryButtonsCellEditor.this.viewer.refresh();
                } else {
                    BinaryButtonsCellEditor.this.viewer.refresh(Element2);
                }
            }
        });
    }

    protected Control createControl(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.justify = false;
        layout.type = 256;
        layout.marginLeft = -1;
        layout.marginTop = -1;
        layout.marginRight = -1;
        layout.marginBottom = -1;
        layout.spacing = -1;
        this.composite = new Composite(parent, 0);
        this.composite.setBounds(0, 0, parent.getSize().x, parent.getSize().y);
        this.composite.setLayout((Layout)layout);
        return this.composite;
    }

    protected Object doGetValue() {
        return 45054;
    }

    protected void doSetFocus() {
        if (this.composite != null) {
            this.composite.setFocus();
        }
    }

    protected void updateBinaryValue(Object Element2, boolean updateView) {
        long value = 0L;
        for (int i = this.b.length - 1; i >= 0; --i) {
            value = (value << 1) + (long)Integer.valueOf(this.b[i].getText()).intValue();
        }
        if (Element2 instanceof TreeRegister) {
            ((TreeRegister)Element2).setAndWriteValue(value);
        }
        if (Element2 instanceof TreeField) {
            ((TreeField)Element2).setValue(value);
        }
        if (updateView) {
            this.updateViewer(Element2);
        }
    }

    protected void doSetValue(Object value) {
        int bitsize = 0;
        long regvalue = -1L;
        this.element = (TreeElement)value;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.store_bitbuttons = store.getBoolean("bitbuttons");
        if (this.element instanceof TreeRegister) {
            bitsize = ((TreeRegister)this.element).getBitSize();
            regvalue = ((TreeRegister)this.element).getValue();
        }
        if (this.element instanceof TreeField) {
            bitsize = ((TreeField)this.element).getBitLength();
            regvalue = ((TreeField)this.element).getValue();
        }
        if (regvalue != -1L) {
            RowData data;
            this.b = new Button[bitsize];
            for (int i = bitsize - 1; i >= 0; --i) {
                this.b[i] = new Button(this.composite, 0x800000);
                data = new RowData();
                data.width = 15;
                data.height = 19;
                this.b[i].setLayoutData((Object)data);
                FontData[] fD = this.b[i].getFont().getFontData();
                fD[0].setHeight(7);
                Font f = new Font((Device)Display.getCurrent(), fD[0]);
                this.b[i].setFont(f);
                this.b[i].addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        Button but = (Button)e.getSource();
                        if (but.getText().equals("1")) {
                            but.setText("0");
                        } else {
                            but.setText("1");
                        }
                        if (BinaryButtonsCellEditor.this.store_bitbuttons) {
                            BinaryButtonsCellEditor.this.updateBinaryValue(BinaryButtonsCellEditor.this.element, false);
                        }
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                this.b[i].setText("-");
                if (this.element instanceof TreeRegister) {
                    TreeElement[] children;
                    this.b[i].setText(String.valueOf(Utils.getBitFromValue(i, ((TreeRegister)this.element).getValue())));
                    this.b[i].setToolTipText("Bit " + i);
                    for (TreeElement child : children = ((TreeRegister)this.element).getChildren()) {
                        TreeField tf;
                        if (!(child instanceof TreeField) || 0 > i - (tf = (TreeField)child).getBitOffset() || i - tf.getBitOffset() > tf.getBitLength() - 1) continue;
                        this.b[i].setToolTipText("Bit " + i + ": " + tf.getName());
                    }
                }
                if (this.element instanceof TreeField) {
                    this.b[i].setText(String.valueOf(Utils.getBitFromValue(i, ((TreeField)this.element).getValue())));
                    this.b[i].setToolTipText("Bit " + (i + ((TreeField)this.element).getBitOffset()));
                }
                if (i <= 0 || i >= bitsize - 1 || i % 4 != 0) continue;
                RowData ldata = new RowData();
                ldata.width = 3;
                ldata.height = 19;
                Label l = new Label(this.composite, 514);
                l.setLayoutData((Object)ldata);
            }
            if (!this.store_bitbuttons) {
                Button setButton = new Button(this.composite, 0);
                setButton.setText("Set");
                data = new RowData();
                data.width = 26;
                data.height = 19;
                setButton.setLayoutData((Object)data);
                setButton.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        BinaryButtonsCellEditor.this.updateBinaryValue(BinaryButtonsCellEditor.this.element, true);
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
            }
        }
    }
}

