/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.embsysregview.views.GDBSessionTranslator;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;

public class GDBEventProvider
implements IDebugContextListener {
    private DSFSessionStartedListener startedlistener = new DSFSessionStartedListener();
    private DSFSessionEndedListener endedlistener;

    public GDBEventProvider() {
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this.startedlistener);
        this.endedlistener = new DSFSessionEndedListener();
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this.endedlistener);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public void dispose() {
        DsfSession.removeSessionStartedListener((DsfSession.SessionStartedListener)this.startedlistener);
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this.endedlistener);
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
    }

    public void debugContextChanged(DebugContextEvent event) {
        DebugEvent e = new DebugEvent((Object)new DebugContextChangedDebugEvent(this, GDBSessionTranslator.getSession(event.getContext())), 16);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{e});
    }

    public class DSFSessionStartedListener
    implements DsfSession.SessionStartedListener {
        public DSFSessionStartedListener() {
            DsfSession[] sessions = DsfSession.getActiveSessions();
            for (int i = 0; i < sessions.length; ++i) {
                this.sessionStarted(sessions[i]);
            }
        }

        public void sessionStarted(DsfSession session) {
            new SessionListener(session);
        }
    }

    public class DSFSessionEndedListener
    implements DsfSession.SessionEndedListener {
        public void sessionEnded(DsfSession session) {
            DebugEvent event = new DebugEvent((Object)new DsfSessionDebugEvent(GDBEventProvider.this, session), 8);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    public class DebugContextChangedDebugEvent {
        private Object session;

        public DebugContextChangedDebugEvent(GDBEventProvider this$0, Object session) {
            this.session = session;
        }

        public Object getSession() {
            return this.session;
        }
    }

    public class DsfSessionDebugEvent {
        private DsfSession session;

        public DsfSessionDebugEvent(GDBEventProvider this$0, DsfSession session) {
            this.session = session;
        }

        public DsfSession getSession() {
            return this.session;
        }
    }

    public class SessionListener {
        private String sessionID;

        public SessionListener(DsfSession session) {
            this.sessionID = session.getId();
            session.addServiceEventListener((Object)this, null);
        }

        public String getSessionID() {
            return this.sessionID;
        }

        @DsfServiceEventHandler
        public void eventDispatched(IRunControl.IResumedDMEvent e) {
        }

        @DsfServiceEventHandler
        public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
            DebugEvent event = new DebugEvent((Object)new DsfSessionDebugEvent(GDBEventProvider.this, DsfSession.getSession((String)this.sessionID)), 2);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
        }
    }
}

