/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataWriteMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.embsysregview.views.Utils;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;

public class GDBSessionTranslator {
    public static int maxWaitTimeInInMilliseconds = 5000;

    public static Object getSession() {
        return GDBSessionTranslator.getSession(DebugUITools.getDebugContext());
    }

    public static Object getSession(Object context) {
        Object session = null;
        if (null != context) {
            if (context instanceof DsfSession) {
                session = context;
            }
            if (context instanceof IProcess) {
                context = ((IProcess)context).getLaunch();
            }
            if (context instanceof GdbLaunch) {
                session = ((GdbLaunch)context).getSession();
            } else if (context instanceof IDMVMContext) {
                IDMContext dmc = ((IDMVMContext)context).getDMContext();
                if (null == dmc) {
                    return null;
                }
                session = DsfSession.getSession((String)dmc.getSessionId());
            }
        }
        if (null != session && GDBSessionTranslator.isSessionTerminated(session)) {
            return null;
        }
        return session;
    }

    public static boolean isSessionTerminated(Object session) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        for (int i = 0; i < launches.length; ++i) {
            ILaunch l = launches[i];
            if (session != GDBSessionTranslator.getSession(l)) continue;
            return l.isTerminated();
        }
        return true;
    }

    public static Object getSession(ILaunch launch) {
        if (null != launch && launch instanceof GdbLaunch) {
            return ((GdbLaunch)launch).getSession();
        }
        return null;
    }

    public static int writeMemory(Object session, String address, String value, int iByteCount) throws TimeoutException {
        if (null == session) {
            return -1;
        }
        if (session instanceof DsfSession) {
            return GDBSessionTranslator.writeMemory((DsfSession)session, address, value, iByteCount, maxWaitTimeInInMilliseconds);
        }
        return -1;
    }

    public static int writeMemory(String address, String value, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.writeMemory(GDBSessionTranslator.getSession(), address, value, iByteCount);
    }

    public static int writeMemory(Object session, long address, long value, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.writeMemory(session, Long.toString(address), "0x" + Long.toHexString(value), iByteCount);
    }

    public static int writeMemory(long address, long value, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.writeMemory(GDBSessionTranslator.getSession(), address, value, iByteCount);
    }

    public static long readMemory(Object session, String address, int iByteCount) throws TimeoutException {
        if (null == session) {
            return -1L;
        }
        if (session instanceof DsfSession) {
            return GDBSessionTranslator.readMemory((DsfSession)session, address, iByteCount, maxWaitTimeInInMilliseconds);
        }
        return -1L;
    }

    public static long readMemory(String address, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.readMemory(GDBSessionTranslator.getSession(), address, iByteCount);
    }

    public static long readMemory(Object session, long address, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.readMemory(session, Long.toString(address), iByteCount);
    }

    public static long readMemory(long address, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.readMemory(GDBSessionTranslator.getSession(), address, iByteCount);
    }

    public static int writeMemory(DsfSession session, String address, String value, int iByteCount, int maximumTimeToWait) throws TimeoutException {
        if (!session.isActive()) {
            return -1;
        }
        int ret = -1;
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
        final IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
        if (null == fGdb) {
            return -1;
        }
        CommandFactory factory = fGdb.getCommandFactory();
        int format = value.contains("x") ? 0 : 3;
        final ICommand info_wm = factory.createMIDataWriteMemory((IDMContext)fGdb.getContext(), 0L, address, format, iByteCount, value);
        Query<MIDataWriteMemoryInfo> query = new Query<MIDataWriteMemoryInfo>(){

            protected void execute(final DataRequestMonitor<MIDataWriteMemoryInfo> rm) {
                fGdb.queueCommand(info_wm, (DataRequestMonitor)new DataRequestMonitor<MIDataWriteMemoryInfo>(this, (Executor)fGdb.getExecutor(), null){

                    protected void handleCompleted() {
                        rm.setData((Object)((MIDataWriteMemoryInfo)this.getData()));
                        rm.done();
                    }
                });
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)query);
        MIDataWriteMemoryInfo data = null;
        try {
            data = (MIDataWriteMemoryInfo)query.get((long)maximumTimeToWait, TimeUnit.MILLISECONDS);
            if (data.isError()) {
                data = null;
            }
            ret = data != null ? iByteCount : -1;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException e) {
            String message = "writeMemory - failed, ErrorMessage: waiting time of " + maximumTimeToWait + " ms passed";
            throw new TimeoutException(message);
        }
        finally {
            tracker.dispose();
        }
        return ret;
    }

    public static long readMemory(DsfSession session, String address, int iByteCount, int maximumTimeToWait) throws TimeoutException {
        long ret;
        block20: {
            if (!session.isActive()) {
                return -1L;
            }
            ret = -1L;
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
            final IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
            if (null == fGdb) {
                return -1L;
            }
            CommandFactory factory = fGdb.getCommandFactory();
            final ICommand info_rm = factory.createMIDataReadMemory((IDMContext)fGdb.getContext(), 0L, address, 0, 1, 1, iByteCount, null);
            Query<MIDataReadMemoryInfo> query = new Query<MIDataReadMemoryInfo>(){

                protected void execute(final DataRequestMonitor<MIDataReadMemoryInfo> rm) {
                    fGdb.queueCommand(info_rm, (DataRequestMonitor)new DataRequestMonitor<MIDataReadMemoryInfo>(this, (Executor)fGdb.getExecutor(), null){

                        protected void handleCompleted() {
                            rm.setData((Object)((MIDataReadMemoryInfo)this.getData()));
                            rm.done();
                        }
                    });
                }
            };
            ImmediateExecutor.getInstance().execute((Runnable)query);
            MIDataReadMemoryInfo data = null;
            try {
                data = (MIDataReadMemoryInfo)query.get((long)maximumTimeToWait, TimeUnit.MILLISECONDS);
                if (data.isError()) {
                    data = null;
                }
                if (data == null) break block20;
                MIInfo info = GDBSessionTranslator.postCLICommand(session, "show endian", maximumTimeToWait);
                if (info == null) {
                    long l = -1L;
                    return l;
                }
                boolean endianessknown = true;
                boolean isBigEndian = info.getMIOutput().toString().contains("big endian");
                boolean isLittleEndian = info.getMIOutput().toString().contains("little endian");
                if (!isBigEndian && !isLittleEndian || isBigEndian && isLittleEndian) {
                    endianessknown = false;
                }
                MemoryByte[] bytes = data.getMIMemoryBlock();
                if (endianessknown) {
                    byte[] arraybytes = new byte[bytes.length];
                    if (!isBigEndian) {
                        for (i = 0; i < bytes.length; ++i) {
                            arraybytes[i] = bytes[bytes.length - 1 - i].getValue();
                        }
                    } else {
                        for (i = 0; i < bytes.length; ++i) {
                            arraybytes[i] = bytes[i].getValue();
                        }
                    }
                    BigInteger big = new BigInteger(arraybytes);
                    big = Utils.makeUnsigned(big, 32);
                    ret = new Long(big.toString());
                    break block20;
                }
                ret = -1L;
            }
            catch (InterruptedException info) {
            }
            catch (ExecutionException info) {
            }
            catch (TimeoutException e) {
                String message = "readMemory - failed, ErrorMessage: waiting time of " + maximumTimeToWait + " ms passed";
                throw new TimeoutException(message);
            }
            finally {
                tracker.dispose();
            }
        }
        return ret;
    }

    public static MIInfo postCLICommand(DsfSession session, String cLICommand, int maximumTimeToWait) throws TimeoutException {
        if (!session.isActive()) {
            throw new TimeoutException("Session is terminated");
        }
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
        IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
        if (null == fGdb) {
            return null;
        }
        CLICommand info = new CLICommand((IDMContext)fGdb.getContext(), cLICommand);
        return GDBSessionTranslator.executeQuery((ICommand<MIInfo>)info, "postCLICommand", "cLICommand=" + cLICommand, session, tracker, fGdb, maximumTimeToWait);
    }

    private static MIInfo executeQuery(final ICommand<MIInfo> command, String functionName, String details, DsfSession session, DsfServicesTracker tracker, final IGDBControl fGdb, int maximumTimeToWait) throws TimeoutException {
        Query<MIInfo> query = new Query<MIInfo>(){

            protected void execute(final DataRequestMonitor<MIInfo> rm) {
                fGdb.queueCommand(command, (DataRequestMonitor)new DataRequestMonitor<MIInfo>(this, (Executor)fGdb.getExecutor(), null){

                    protected void handleCompleted() {
                        rm.setData((Object)((MIInfo)this.getData()));
                        rm.done();
                    }
                });
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)query);
        MIInfo data = null;
        try {
            data = (MIInfo)query.get((long)maximumTimeToWait, TimeUnit.MILLISECONDS);
            if (data.isError()) {
                MIInfo mIInfo = null;
                return mIInfo;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException e) {
            String message = functionName + " - failed, ErrorMessage: waiting time of " + maximumTimeToWait + " ms passed";
            throw new TimeoutException(message);
        }
        finally {
            tracker.dispose();
        }
        return data;
    }
}

