/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import org.eclipse.cdt.embsysregview.views.Interpretations;
import org.eclipse.cdt.embsysregview.views.TreeElement;
import org.eclipse.cdt.embsysregview.views.TreeRegister;

public class TreeField
extends TreeElement {
    private byte bitOffset;
    private byte bitLength;
    private Interpretations interpretations;

    public TreeField(String name, String description, byte bitOffset, byte bitLength, Interpretations interpretations) {
        super(name, description);
        this.bitOffset = bitOffset;
        this.bitLength = bitLength;
        this.interpretations = interpretations;
    }

    public boolean hasValueChanged() {
        return this.getOldValue() != this.getValue();
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public byte getBitLength() {
        return this.bitLength;
    }

    public Interpretations getInterpretations() {
        return this.interpretations;
    }

    private long stripValue(long value) {
        if (value != -1L) {
            value >>= this.bitOffset;
            value &= 0xFFFFFFFFL << this.bitLength ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return value;
    }

    private long getOldValue() {
        return this.stripValue(((TreeRegister)this.getParent()).getOldValue());
    }

    public long getValue() {
        return this.stripValue(((TreeRegister)this.getParent()).getValue());
    }

    public void setValue(long value) {
        long regValue = ((TreeRegister)this.getParent()).getValue();
        regValue &= 0xFFFFFFFFL >> 32 - this.bitLength << this.bitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        ((TreeRegister)this.getParent()).setAndWriteValue(regValue |= (value <<= this.bitOffset));
    }

    public String getInterpretation() {
        if (this.interpretations.containsKey(this.getValue())) {
            return this.interpretations.getInterpretation(this.getValue());
        }
        return "";
    }

    public boolean hasInterpretation() {
        return !this.getInterpretation().equals("");
    }

    public boolean hasInterpretations() {
        return this.interpretations.hasInterpretations();
    }
}

