/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import org.eclipse.cdt.embsysregview.views.EmbSysRegView;
import org.eclipse.cdt.embsysregview.views.TreeElement;
import org.eclipse.cdt.embsysregview.views.TreeParent;
import org.eclipse.cdt.embsysregview.views.TreeRegisterGroup;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;

public class TreeRegister
extends TreeParent {
    private long old_value;
    private long value = -1L;
    private long resetValue;
    private String type;
    private String registerAddress;
    private boolean retrievalActive = false;
    private int size = 4;

    public boolean isReadWrite() {
        return this.getType().toUpperCase().equals("RW") || this.getType().toUpperCase().equals("RW1") || this.getType().toUpperCase().equals("RW1C") || this.getType().toUpperCase().equals("RW1S") || this.getType().toUpperCase().equals("RWH");
    }

    public boolean isReadOnly() {
        return this.getType().toUpperCase().equals("RO") || this.getType().toUpperCase().equals("RC") || this.getType().toUpperCase().equals("R");
    }

    public boolean isWriteOnly() {
        return this.getType().toUpperCase().equals("WO") || this.getType().toUpperCase().equals("W") || this.getType().toUpperCase().equals("W1C") || this.getType().toUpperCase().equals("W1S") || this.getType().toUpperCase().equals("W1");
    }

    public boolean hasValueChanged() {
        return this.old_value != this.value;
    }

    public boolean isRetrievalActive() {
        return this.retrievalActive;
    }

    public void setRetrievalActive(boolean retrievalActive) {
        this.retrievalActive = retrievalActive;
    }

    public String getRegisterAddress() {
        return this.registerAddress;
    }

    public TreeRegister(String name, String description, String registerAddress, long resetValue, String type, int size) {
        super(name, description);
        this.registerAddress = registerAddress;
        this.resetValue = resetValue;
        this.type = type;
        this.size = size;
    }

    protected long getOldValue() {
        return this.old_value;
    }

    public long getValue() {
        if (this.isWriteOnly()) {
            return this.resetValue;
        }
        return this.value;
    }

    public long getResetValue() {
        return this.resetValue;
    }

    public String getType() {
        return this.type;
    }

    public void setValue(long lvalue) {
        this.value = lvalue;
    }

    public void setAndWriteValue(long lvalue) {
        if (this.isWriteOnly()) {
            this.writeValue(lvalue);
        } else {
            this.old_value = this.value;
            this.setValue(lvalue);
            this.writeValue();
        }
    }

    private void writeValue() {
        EmbSysRegView.GDBi.writeMemory(this.getRegisterAddress(), this.getValue(), this.getByteSize());
    }

    private void writeValue(long value) {
        EmbSysRegView.GDBi.writeMemory(this.getRegisterAddress(), value, this.getByteSize());
    }

    public void readValue() {
        if (this.retrievalActive && !this.isWriteOnly()) {
            this.old_value = this.value;
            TreeElement parent = this.getParent();
            if (parent instanceof TreeRegisterGroup) {
                IAdaptable context = DebugUITools.getDebugContext();
                this.value = context != null ? EmbSysRegView.GDBi.readMemory(this.registerAddress, this.getByteSize()) : -1L;
            } else {
                this.registerAddress = "-1";
            }
        } else {
            this.old_value = this.value;
            this.value = -1L;
        }
    }

    public int getBitSize() {
        return this.size * 8;
    }

    public int getByteSize() {
        return this.size;
    }

    public void clearValue() {
        this.value = -1L;
    }

    public void toggleRetrieval() {
        this.retrievalActive = !this.retrievalActive;
    }
}

