/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.math.BigInteger;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class Utils {
    public static final BigInteger Max8Bit = BigInteger.valueOf(127L).add(BigInteger.ONE);
    public static final BigInteger Max16Bit = BigInteger.valueOf(32767L).add(BigInteger.ONE);
    public static final BigInteger Max32Bit = BigInteger.valueOf(Integer.MAX_VALUE).add(BigInteger.ONE);
    public static final BigInteger Max64Bit = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
    public static final int Arch8Bit = 8;
    public static final int Arch16Bit = 16;
    public static final int Arch32Bit = 32;
    public static final int Arch64Bit = 64;

    public static long convertbig2little(long value) {
        long a = value >> 24;
        long b = (value & 0xFFFFFFFF00FF0000L) >> 8;
        long c = (value & 0xFFFFFFFF0000FF00L) << 8;
        long d = (value & 0xFFFFFFFF000000FFL) << 24;
        return a | b | c | d;
    }

    private static Matcher getLineMatcher(String fulltext) {
        String patternStr = "^(.*)$";
        Pattern pattern = Pattern.compile(patternStr, 8);
        return pattern.matcher(fulltext);
    }

    public static String getTextLine(int number, String fulltext) {
        Matcher matcher = Utils.getLineMatcher(fulltext);
        for (int i = 1; i <= number; ++i) {
            if (!matcher.find() || i != number) continue;
            return matcher.group(1);
        }
        return "";
    }

    public static String getFirstNotEmptyTextLine(String fulltext) {
        Matcher matcher = Utils.getLineMatcher(fulltext);
        while (matcher.find()) {
            if (matcher.group(1).equals("")) continue;
            return matcher.group(1);
        }
        return "";
    }

    public static int countTextLines(String fulltext) {
        int i = 0;
        Matcher matcher = Utils.getLineMatcher(fulltext);
        while (matcher.find()) {
            ++i;
        }
        return i;
    }

    public static int getBitFromValue(int bitnr, long value) {
        return (int)((value >> bitnr) % 2L);
    }

    public static String longtobinarystring(long wert, int bits) {
        StringBuilder text = new StringBuilder();
        for (int i = bits; i > 0; --i) {
            text.append(Math.abs(wert % 2L));
            wert /= 2L;
        }
        text.reverse();
        return text.toString();
    }

    public static String longtoHexString(long wert, int bits) {
        int hexdigits = bits / 4;
        if (bits % 4 != 0) {
            ++hexdigits;
        }
        StringBuilder hex = new StringBuilder();
        hex.append("0x");
        String x = Long.toHexString(wert);
        int missingLen = hexdigits - x.length();
        for (int i = 0; i < missingLen; ++i) {
            hex.append('0');
        }
        hex.append(x.toUpperCase());
        return hex.toString();
    }

    public static BigInteger makeUnsigned(BigInteger signed, int bitdepth) {
        BigInteger unsigned = signed;
        if (null == signed) {
            return unsigned;
        }
        if (signed.compareTo(BigInteger.ZERO) < 0) {
            BigInteger MaxSignedValue = switch (bitdepth) {
                case 8 -> Max8Bit;
                case 16 -> Max16Bit;
                case 32 -> Max32Bit;
                case 64 -> Max64Bit;
                default -> Max32Bit;
            };
            unsigned = MaxSignedValue.add(MaxSignedValue.add(signed));
        }
        return unsigned;
    }

    public static URL getFileURL(String selectedArchitecture, String selectedVendor, String selectedChip) {
        Bundle[] fragments;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.embsysregview.data");
        URL fileURL = bundle.getEntry("data/" + selectedArchitecture + "/" + selectedVendor + "/" + selectedChip + ".xml");
        if (fileURL == null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
            for (Bundle fragment : fragments) {
                fileURL = fragment.getEntry("data/" + selectedArchitecture + "/" + selectedVendor + "/" + selectedChip + ".xml");
                if (fileURL == null) continue;
                return fileURL;
            }
        }
        return fileURL;
    }

    public static Enumeration<URL> getEntries(String path, String pattern) {
        Bundle[] fragments;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.embsysregview.data");
        Enumeration entries = bundle.findEntries(path, pattern, false);
        if (entries == null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
            for (Bundle fragment : fragments) {
                entries = fragment.findEntries(path, pattern, false);
                if (entries == null) continue;
                return entries;
            }
        }
        return entries;
    }
}

