/*
 * Decompiled with CFR 0.152.
 */
package com.st.debug.ui.memory.view.views;

import com.st.debug.ui.memory.view.Activator;
import com.st.debug.ui.memory.view.preferences.LiveMemoryViewPreferencePage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LiveMemoryView
extends ViewPart {
    public static final String ID = "com.st.debug.ui.memory.view.views.LiveMemoryView";
    @Inject
    IWorkbench workbench;
    private TableViewer memViewer;
    private Action startAction;
    private Action stopAction;
    private Action prefsAction;
    private Socket socket = null;
    private ScheduledFuture<?> cancellable = null;
    private long interval = 200L;
    private String address = "0x48000410";
    private long chunksNum = 16L;
    private String chunkSize = "mdw";
    private String host = "localhost";
    private String targetCmd = "sr6g7.armv7.axi";
    private int port = 4444;
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;

    public void createPartControl(Composite parent) {
        this.memViewer = new TableViewer(parent, 780);
        this.memViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.memViewer.setInput((Object)new String[]{"<No Data>"});
        this.memViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.workbench.getHelpSystem().setHelp(this.memViewer.getControl(), "com.st.debug.ui.memory.view.viewer");
        this.getSite().setSelectionProvider((ISelectionProvider)this.memViewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void init(IViewSite site) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store != null) {
            String hexPattern = "^0[xX][0-9a-fA-F]+$";
            if (store.getString("addressPreference").matches(hexPattern)) {
                this.address = store.getString("addressPreference");
            }
            this.interval = store.getLong("timePreference");
            this.chunksNum = store.getLong("lengthPreference");
            this.host = store.getString("hostPreference");
            this.port = store.getInt("portPreference");
            this.chunkSize = store.getString("sizePreference");
        }
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (store != null) {
                    LiveMemoryView.this.memViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            LiveMemoryView.this.memViewer.setInput((Object)new String[]{"<Stopped>"});
                            if (LiveMemoryView.this.cancellable != null) {
                                LiveMemoryView.this.cancellable.cancel(true);
                            }
                        }
                    });
                    String hexPattern = "^0[xX][0-9a-fA-F]+$";
                    if (store.getString("addressPreference").matches(hexPattern)) {
                        LiveMemoryView.this.address = store.getString("addressPreference");
                    }
                    LiveMemoryView.this.interval = store.getLong("timePreference");
                    LiveMemoryView.this.chunksNum = store.getLong("lengthPreference");
                    LiveMemoryView.this.host = store.getString("hostPreference");
                    LiveMemoryView.this.port = store.getInt("portPreference");
                    LiveMemoryView.this.chunkSize = store.getString("sizePreference");
                }
            }
        };
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.st.debug.ui.memory.view");
        if (prefs != null) {
            prefs.addPreferenceChangeListener(this.fPreferenceChangeListener);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LiveMemoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.memViewer.getControl());
        this.memViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.memViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.prefsAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.prefsAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.prefsAction);
    }

    private void makeActions() {
        this.stopAction = new Action(){

            public void run() {
                if (LiveMemoryView.this.cancellable != null) {
                    LiveMemoryView.this.cancellable.cancel(true);
                }
                LiveMemoryView.this.memViewer.setInput((Object)new String[]{"<Stopped>"});
                try {
                    if (LiveMemoryView.this.socket != null) {
                        LiveMemoryView.this.socket.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        this.stopAction.setText("Stop");
        this.stopAction.setToolTipText("Stop monitoring");
        this.stopAction.setImageDescriptor(this.workbench.getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.startAction = new Action(){

            public void run() {
                try {
                    LiveMemoryView.this.socket = new Socket(LiveMemoryView.this.host, LiveMemoryView.this.port);
                    BufferedReader in = new BufferedReader(new InputStreamReader(LiveMemoryView.this.socket.getInputStream()));
                    PrintWriter out = new PrintWriter(LiveMemoryView.this.socket.getOutputStream(), true);
                    in.readLine();
                    in.readLine();
                    out.println("targets");
                    out.println();
                    String line = "";
                    do {
                        if (!(line = in.readLine().trim()).contains("axi")) continue;
                        line = line.substring(line.indexOf(32)).trim();
                        LiveMemoryView.this.targetCmd = line.substring(0, line.indexOf(32));
                    } while (line.length() != 0);
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    Runnable command = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BufferedReader in = new BufferedReader(new InputStreamReader(LiveMemoryView.this.socket.getInputStream()));
                                PrintWriter out = new PrintWriter(LiveMemoryView.this.socket.getOutputStream(), true);
                                out.println(LiveMemoryView.this.targetCmd + " " + LiveMemoryView.this.chunkSize + " " + LiveMemoryView.this.address + " " + LiveMemoryView.this.chunksNum);
                                out.println();
                                final Vector<String> response = new Vector<String>();
                                String line = "";
                                do {
                                    if (!(line = in.readLine().trim()).startsWith("0x")) continue;
                                    response.add(line.toUpperCase().replace('X', 'x'));
                                } while (line.length() != 0);
                                LiveMemoryView.this.memViewer.getControl().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        LiveMemoryView.this.memViewer.setInput((Object)response.toArray());
                                    }
                                });
                            }
                            catch (IOException e) {
                                LiveMemoryView.this.memViewer.getControl().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        LiveMemoryView.this.memViewer.setInput((Object)new String[]{"Telnet failed", e.getLocalizedMessage()});
                                        if (LiveMemoryView.this.cancellable != null) {
                                            LiveMemoryView.this.cancellable.cancel(true);
                                        }
                                    }
                                });
                            }
                        }
                    };
                    LiveMemoryView.this.cancellable = scheduler.scheduleAtFixedRate(command, 0L, LiveMemoryView.this.interval, TimeUnit.MILLISECONDS);
                }
                catch (IOException e) {
                    LiveMemoryView.this.memViewer.setInput((Object)new String[]{"Unable to open socket", e.getLocalizedMessage()});
                }
            }
        };
        this.startAction.setText("Start");
        this.startAction.setToolTipText("Start monitoring");
        this.startAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.prefsAction = new Action(this){

            public void run() {
                LiveMemoryViewPreferencePage page = new LiveMemoryViewPreferencePage();
                page.setTitle("Live Memory View");
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(Display.getDefault().getActiveShell(), mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
            }
        };
        this.prefsAction.setText("Settings");
        this.prefsAction.setToolTipText("Change view preferences");
        this.prefsAction.setImageDescriptor(this.workbench.getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    public void setFocus() {
        this.memViewer.getControl().setFocus();
    }

    public void setRefreshRate(long rate) {
        this.interval = rate;
    }

    public void setchunksNum(long val) {
        this.chunksNum = val;
    }

    public void setchunkSize(String val) {
        this.chunkSize = val;
    }

    public void setHost(String val) {
        this.host = val;
    }

    public void setPort(int val) {
        this.port = val;
    }

    public void setTarget(String val) {
        this.targetCmd = val;
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return LiveMemoryView.this.workbench.getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

