/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.resources.extensions;

import com.st.stellar.app.wizard.resources.extensions.IResourcesExtension;
import com.st.stellar.app.wizard.resources.extensions.Messages;
import com.st.stellar.exceptions.StellarException;
import com.st.stellar.extensions.res.handlers.StellarResourceType;
import com.st.stellar.utils.LogManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ResourcesExtensionParser
implements IResourcesExtension {
    public static IExtension[] getResourcesExtensions() {
        ArrayList<IExtension> list = new ArrayList<IExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.st.stellar.resources");
        if (point != null) {
            IExtension[] extensions;
            for (IExtension extension : extensions = point.getExtensions()) {
                if (!extension.isValid()) continue;
                list.add(extension);
            }
        }
        return list.toArray(new IExtension[list.size()]);
    }

    public static void getResources(List<StellarResourceType> resourcesRegistry, IExtension extension) {
        if (extension != null) {
            IConfigurationElement[] configs;
            for (IConfigurationElement config : configs = extension.getConfigurationElements()) {
                if (!config.getName().equals("resources")) continue;
                String type = config.getAttribute("type");
                ResourcesExtensionParser.createResources(extension, resourcesRegistry, config.getChildren("resource"), type);
            }
        }
    }

    private static void createResources(IExtension extension, List<StellarResourceType> map, IConfigurationElement[] configs, String type) {
        for (IConfigurationElement config : configs) {
            String id = config.getAttribute("id");
            String name = config.getAttribute("name");
            String rsc = config.getAttribute("rsc");
            URL url = null;
            Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
            if (rsc != null) {
                url = bundle.getResource(rsc);
            }
            try {
                StellarResourceType resObject = new StellarResourceType(name, id, type, url);
                if (resObject == null) continue;
                ResourcesExtensionParser.createInfo(config.getChildren("property"), resObject);
                map.add(resObject);
            }
            catch (StellarException e) {
                LogManager.getLogger().logError((Throwable)e);
            }
        }
    }

    private static void createInfo(IConfigurationElement[] configs, StellarResourceType resObject) {
        for (IConfigurationElement config : configs) {
            String errorMsg;
            Object[] bindings;
            String name = config.getAttribute("name");
            String value = config.getAttribute("value");
            Map<String, String> map = resObject.getInfo();
            if (map.containsKey(name)) {
                bindings = new String[]{name, resObject.getId()};
                errorMsg = NLS.bind((String)Messages.ResourcesExtensionParser_0, (Object[])bindings);
                LogManager.getLogger().logError(errorMsg);
                continue;
            }
            if (!resObject.isPropertySupported(name)) {
                bindings = new String[]{name, resObject.getId()};
                errorMsg = NLS.bind((String)Messages.ResourcesExtensionParser_1, (Object[])bindings);
                LogManager.getLogger().logError(errorMsg);
            }
            map.put(name, value);
        }
    }
}

