/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard;

import com.st.stellar.app.wizard.extensions.ExtensionParser;
import com.st.stellar.app.wizard.resources.StellarSupportedProducts;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.utils.LogManager;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.st.stellar.app.wizards";
    private static Activator plugin;
    public static final String IMG_LOGO_32 = "logo32";
    public static final String IMG_WIZ_BANNER = "wiz.ban";
    public static final String IMG_STEP_BANNER = "step.banner";
    public static final String IMG_BACKGROUND = "board.background";
    public static final String IMG_STEP_1 = "step.1";
    public static final String IMG_STEP_2 = "step.2";
    public static final String IMG_STEP_3 = "step.3";
    public static final String IMG_STEP_4 = "step.4";
    public static final String IMG_STEP_5 = "step.5";
    public static final String IMG_DEMO_APPS = "demo.apps";
    public static final String IMG_CREATE_NEW_APP = "create.new";
    public static final String ICN_FILTER = "filter";
    public static final String ICN_NOT_FILTER = "not_filter";
    public static final String ICN_SELECT_ALL = "select.all";
    public static final String ICN_DESELECT_ALL = "deselect.all";
    public static final String IMG_STEP_4_DONE = "step.4.done";
    public static final String IMG_STEP_5_DONE = "step.5.done";
    public static final String IMG_NO_BOARD = "no_board";
    private ArrayList<ApplicationType> applicationsRegistry = new ArrayList();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializeApplicationRegistry();
        StellarSupportedProducts.getInstance();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_LOGO_32, "image32.png");
        this.registerImage(registry, IMG_WIZ_BANNER, "st_wiz_ban.png");
        this.registerImage(registry, IMG_STEP_BANNER, "banner.jpg");
        this.registerIcon(registry, ICN_FILTER, "filter.gif");
        this.registerIcon(registry, ICN_NOT_FILTER, "not_filter.gif");
        this.registerIcon(registry, ICN_SELECT_ALL, "selectAll.gif");
        this.registerIcon(registry, ICN_DESELECT_ALL, "deselectAll.gif");
        this.registerImage(registry, IMG_BACKGROUND, "background.png");
        this.registerImage(registry, IMG_STEP_1, "Step1.png");
        this.registerImage(registry, IMG_STEP_2, "Step2.png");
        this.registerImage(registry, IMG_STEP_3, "Step3.png");
        this.registerImage(registry, IMG_STEP_4, "Step4.png");
        this.registerImage(registry, IMG_STEP_5, "Step5.png");
        this.registerImage(registry, IMG_STEP_4_DONE, "done.png");
        this.registerImage(registry, IMG_DEMO_APPS, "DemoApps.png");
        this.registerImage(registry, IMG_CREATE_NEW_APP, "NewApp.png");
        this.registerImage(registry, IMG_NO_BOARD, "NoBoard_100px.png");
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("images/" + fileName);
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            LogManager.getLogger().logError((Throwable)e);
        }
    }

    private void registerIcon(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception e) {
            LogManager.getLogger().logError((Throwable)e);
        }
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public Image getImageResized(String key, int width, int height) {
        ImageData resImageData = this.getImageRegistry().get(key).getImageData().scaledTo(width, height);
        return new Image((Device)Display.getCurrent(), resImageData);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    private void initializeApplicationRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.st.stellar.appbundle");
        if (point != null) {
            IExtension[] extensions;
            for (IExtension extension : extensions = point.getExtensions()) {
                if (!extension.isValid()) continue;
                this.applicationsRegistry.addAll(ExtensionParser.getApplications(extension));
            }
        }
    }

    public ArrayList<ApplicationType> getApplicationsRegistry() {
        return this.applicationsRegistry;
    }
}

