/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.extensions;

import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ExtensionParser {
    public static ArrayList<ApplicationType> getApplications(IExtension extension) {
        IConfigurationElement[] appElems;
        ArrayList<ApplicationType> applications = new ArrayList<ApplicationType>();
        for (IConfigurationElement cE : appElems = ExtensionParser.getConfigElements(extension, "application")) {
            String name = cE.getAttribute("name");
            ArrayList<FilterTagCategory> categories = ExtensionParser.parseCategories(cE);
            String desc = ExtensionParser.getElementDescription(cE);
            ApplicationType application = new ApplicationType(name, desc, categories);
            Bundle bundle = Platform.getBundle((String)extension.getContributor().getName());
            application.setBundle(bundle);
            applications.add(application);
        }
        return applications;
    }

    private static ArrayList<FilterTagCategory> parseCategories(IConfigurationElement config) {
        IConfigurationElement[] catElems;
        ArrayList<FilterTagCategory> categories = new ArrayList<FilterTagCategory>();
        for (IConfigurationElement cE : catElems = ExtensionParser.getConfigElement(config, "category")) {
            String name = cE.getAttribute("name");
            FilterTagCategory cat = new FilterTagCategory(name);
            String desc = ExtensionParser.getElementDescription(cE);
            cat.setDescription(desc);
            cat.getTags().addAll(ExtensionParser.parseTags(cat, cE));
            categories.add(cat);
        }
        return categories;
    }

    public static IConfigurationElement[] getConfigElement(IConfigurationElement config, String element) {
        return config.getChildren(element);
    }

    public static IConfigurationElement getConfigElement(IExtension extension, String element) {
        IConfigurationElement[] configs;
        for (IConfigurationElement c : configs = extension.getConfigurationElements()) {
            if (!c.getName().equals(element)) continue;
            return c;
        }
        return null;
    }

    public static IConfigurationElement[] getConfigElements(IExtension extension, String element) {
        IConfigurationElement[] configs;
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement c : configs = extension.getConfigurationElements()) {
            if (!c.getName().equals(element)) continue;
            list.add(c);
        }
        return list.toArray(new IConfigurationElement[list.size()]);
    }

    private static ArrayList<FilterTagType> parseTags(FilterTagCategory cat, IConfigurationElement config) {
        IConfigurationElement[] metaElems;
        ArrayList<FilterTagType> tags = new ArrayList<FilterTagType>();
        for (IConfigurationElement cE : metaElems = ExtensionParser.getConfigElement(config, "metadata")) {
            String value = cE.getAttribute("value");
            tags.add(new FilterTagType(value, cat, false));
        }
        return tags;
    }

    public static String getElementDescription(IConfigurationElement parent) {
        IConfigurationElement[] description = parent.getChildren("description");
        if (description != null && description.length > 0) {
            return description[0].getValue();
        }
        return "";
    }
}

