/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.types;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.models.Category;
import com.st.stellar.app.wizard.resources.types.BoardType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import java.util.ArrayList;
import java.util.Iterator;
import org.osgi.framework.Bundle;

public class ApplicationType {
    private String name;
    private String description;
    private ArrayList<FilterTagCategory> categories = new ArrayList();
    private Bundle bundle;

    public ApplicationType(String name, String description, ArrayList<FilterTagCategory> categories) {
        this.name = name;
        this.description = description;
        this.categories = categories;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<FilterTagCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(ArrayList<FilterTagCategory> categories) {
        this.categories = categories;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public boolean supportBoard(ArrayList<BoardType> boards) {
        boolean supported = false;
        if (boards == null || boards.size() == 0) {
            supported = true;
        } else {
            block0: for (FilterTagCategory category : this.categories) {
                if (!category.getName().equals(Category.BOARD)) continue;
                for (FilterTagType tag : category.getTags()) {
                    if (!ApplicationType.checkBoard(tag.getName(), boards)) continue;
                    supported = true;
                    continue block0;
                }
            }
        }
        return supported;
    }

    public static boolean checkApplications(BoardType board) {
        ArrayList<ApplicationType> applications = Activator.getDefault().getApplicationsRegistry();
        for (ApplicationType app : applications) {
            for (FilterTagCategory cat : app.getCategories()) {
                if (!cat.getName().equals(Category.BOARD)) continue;
                for (FilterTagType tag : cat.getTags()) {
                    if (!tag.getName().equals(board.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean checkBoard(String id, ArrayList<BoardType> boards) {
        for (BoardType board : boards) {
            if (!id.equals(board.getId())) continue;
            return true;
        }
        return false;
    }

    public String getDeviceApp() {
        String devicesApp = null;
        for (FilterTagCategory category : this.categories) {
            String tagName;
            Iterator<FilterTagType> iterator;
            if (!category.getName().equals(Category.DEVICE) || !(iterator = category.getTags().iterator()).hasNext()) continue;
            FilterTagType tag = iterator.next();
            devicesApp = tagName = tag.getName();
            return devicesApp;
        }
        return devicesApp;
    }

    public String getBoardApp() {
        String boardName = null;
        for (FilterTagCategory category : this.categories) {
            Iterator<FilterTagType> iterator;
            if (!category.getName().equals(Category.BOARD) || !(iterator = category.getTags().iterator()).hasNext()) continue;
            FilterTagType tag = iterator.next();
            boardName = tag.getName();
            return boardName;
        }
        return boardName;
    }
}

