/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class AppTableComparator
extends ViewerComparator {
    private int column = 0;
    private static final int DESCENDING = 1;
    private int direction = 1;

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.column) {
            this.direction = 1 - this.direction;
        } else {
            this.column = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc = 0;
        ApplicationType app1 = (ApplicationType)e1;
        ApplicationType app2 = (ApplicationType)e2;
        switch (this.column) {
            case 0: {
                rc = app1.getName().compareTo(app2.getName());
                break;
            }
            case 1: {
                rc = app1.getDescription().compareTo(app2.getDescription());
                break;
            }
            default: {
                String text1 = this.getMetadataString(viewer, app1);
                String text2 = this.getMetadataString(viewer, app2);
                rc = text1.compareTo(text2);
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }

    private String getMetadataString(Viewer viewer, ApplicationType app) {
        TableViewer tableViewer = (TableViewer)viewer;
        String categoryName = tableViewer.getTable().getColumn(this.column).getText();
        Object text = new String();
        for (FilterTagCategory category : app.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            ArrayList<FilterTagType> tags = category.getTags();
            for (FilterTagType tag : tags) {
                text = ((String)text).concat(tag.getName()) + " ";
            }
            return text;
        }
        return "";
    }
}

