/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import com.st.stellar.app.wizard.types.FilterType;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class AppsFilter
extends ViewerFilter {
    private FilterType filter;

    public AppsFilter(FilterType filter) {
        this.filter = filter;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = true;
        ApplicationType app = (ApplicationType)element;
        ArrayList<FilterTagCategory> appCat = app.getCategories();
        ArrayList<FilterTagCategory> filterCat = this.filter.getCategories();
        String filterTxt = this.filter.getFilterProvider().getFilterText();
        if (filterTxt != null && !filterTxt.isEmpty()) {
            result = app.getName().toLowerCase(Locale.ENGLISH).contains(filterTxt.toLowerCase(Locale.ENGLISH));
        }
        for (FilterTagCategory fC : filterCat) {
            result &= this.checkFilterCategory(appCat, fC);
        }
        return result;
    }

    private boolean checkFilterCategory(ArrayList<FilterTagCategory> appCat, FilterTagCategory fC) {
        boolean categoryResult = false;
        if (this.checkVoidSelection(fC)) {
            categoryResult = true;
        } else {
            for (FilterTagCategory aC : appCat) {
                if (!aC.getName().equals(fC.getName())) continue;
                categoryResult = this.matchTags(aC.getTags(), fC.getTags());
                break;
            }
        }
        return categoryResult;
    }

    private boolean checkVoidSelection(FilterTagCategory fC) {
        ArrayList<FilterTagType> tags = fC.getTags();
        for (FilterTagType tag : tags) {
            if (!tag.isChecked()) continue;
            return false;
        }
        return true;
    }

    private boolean matchTags(ArrayList<FilterTagType> tags, ArrayList<FilterTagType> filters) {
        boolean result = false;
        for (FilterTagType filter : filters) {
            if (!filter.isChecked()) continue;
            for (FilterTagType tag : tags) {
                result |= tag.getName().equals(filter.getName());
            }
        }
        return result;
    }
}

