/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.resources.StellarSupportedProducts;
import com.st.stellar.app.wizard.resources.types.BoardType;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class AppsLabelProvider
extends CellLabelProvider {
    private static final Color ROW_BACKGROUND = new Color((Device)Display.getDefault(), new RGB(214, 240, 255));
    private TableViewer viewer;

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        this.viewer = null;
        if (viewer instanceof TableViewer) {
            this.viewer = (TableViewer)viewer;
        }
    }

    public void update(ViewerCell cell) {
        int rowIndex = Arrays.asList(this.viewer.getTable().getItems()).indexOf(cell.getItem());
        ApplicationType app = (ApplicationType)this.viewer.getElementAt(rowIndex);
        if (rowIndex % 2 == 0) {
            this.viewer.getTable().getItem(rowIndex).setBackground(ROW_BACKGROUND);
        } else {
            this.viewer.getTable().getItem(rowIndex).setBackground(Display.getDefault().getSystemColor(1));
        }
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setText(app.getName());
                break;
            }
            case 1: {
                cell.setText(app.getDescription());
                break;
            }
            case 2: {
                String deviceApp = app.getDeviceApp();
                String boardApp = app.getBoardApp();
                BoardType boardType = StellarSupportedProducts.getBoard((String)boardApp);
                ArrayList devicesApp = StellarSupportedProducts.getDevicesBoard((String)boardType.getCpn());
                cell.setText(deviceApp + " / " + devicesApp.toString());
                break;
            }
            default: {
                String categoryName = this.viewer.getTable().getColumn(cell.getColumnIndex()).getText();
                for (FilterTagCategory category : app.getCategories()) {
                    if (!category.getName().equals(categoryName)) continue;
                    ArrayList<FilterTagType> tags = category.getTags();
                    Object text = new String();
                    for (FilterTagType tag : tags) {
                        text = ((String)text).concat(tag.getName()) + " ";
                    }
                    cell.setText((String)text);
                }
            }
        }
    }
}

