/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.widgets.Display;

public class FilterCellLabelProvider
extends CellLabelProvider {
    private TableViewer viewer;
    private FilterTagCategory category;

    public FilterCellLabelProvider(FilterTagCategory category) {
        this.category = category;
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        this.viewer = null;
        if (viewer instanceof TableViewer) {
            this.viewer = (TableViewer)viewer;
        }
    }

    public FilterTagCategory getCategory() {
        return this.category;
    }

    public void setCategory(FilterTagCategory category) {
        this.category = category;
    }

    public void update(ViewerCell cell) {
        FilterTagType tag;
        ArrayList<FilterTagType> tags;
        int rowIndex = Arrays.asList(this.viewer.getTable().getItems()).indexOf(cell.getItem());
        if (rowIndex < (tags = this.category.getTags()).size() && (tag = tags.get(rowIndex)) != null) {
            cell.setText(tags.get(rowIndex).getName());
            if (tag.isChecked()) {
                cell.setImage(Activator.getDefault().getImage("filter"));
                cell.setForeground(Display.getDefault().getSystemColor(9));
            } else {
                cell.setImage(Activator.getDefault().getImage("not_filter"));
                cell.setForeground(Display.getDefault().getSystemColor(2));
            }
        }
    }
}

