/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.Messages;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.wizards.AbstractWizardPage;
import com.st.stellar.app.wizard.wizards.StellarNewWizardPage1;
import com.st.stellar.app.wizard.wizards.StellarNewWizardPage2;
import com.st.stellar.app.wizard.wizards.StellarNewWizardPage3;
import com.st.stellar.utils.LogManager;
import com.st.stellar.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.xml.sax.SAXException;

public class StellarNewWizard
extends Wizard
implements INewWizard {
    private static final int MAX_PAGES = 3;
    private boolean canFinishEarly = false;
    private ISelection selection;
    ArrayList<String> existing = new ArrayList();
    private StellarNewWizardPage3 _pageWS;

    public StellarNewWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.StellarNewWizardPage0_0);
    }

    public void addPages() {
        this.selection = new StructuredSelection(new HashMap());
        for (int i = 0; i < 3; ++i) {
            AbstractWizardPage page = null;
            switch (i) {
                case 0: {
                    page = new StellarNewWizardPage1(this.selection);
                    break;
                }
                case 1: {
                    page = new StellarNewWizardPage2(this.selection);
                    break;
                }
                case 2: {
                    this._pageWS = new StellarNewWizardPage3(this.selection);
                    page = this._pageWS;
                }
            }
            if (page == null) continue;
            this.addPage((IWizardPage)page);
        }
    }

    public boolean performFinish() {
        Map map = (Map)((IStructuredSelection)this.selection).getFirstElement();
        final ArrayList applications = (ArrayList)map.get("applications");
        XMLMemento memento = Utils.saveWorkingSetsState((IWorkingSet[])this._pageWS.getSelectedWorkingSets());
        final StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            writer.toString();
        }
        catch (IOException e) {
            LogManager.getLogger().logError(e.getMessage());
        }
        Job job = new Job(Messages.StellarNewWizard_2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.StellarNewWizard_3, applications.size());
                for (ApplicationType application : applications) {
                    monitor.subTask(Messages.StellarNewWizard_4 + application.getName());
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    URL entry = application.getBundle().getEntry("resources/" + application.getName() + "/");
                    try {
                        LogManager.getLogger().hide();
                        StellarNewWizard.this.importInWorkspace(application, entry, writer.toString());
                    }
                    catch (CoreException e) {
                        LogManager.getLogger().logError((Throwable)e);
                    }
                    catch (IOException e) {
                        LogManager.getLogger().logError((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        LogManager.getLogger().logError((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LogManager.getLogger().logError((Throwable)e);
                    }
                    catch (SAXException e) {
                        LogManager.getLogger().logError((Throwable)e);
                    }
                    finally {
                        LogManager.getLogger().show();
                    }
                    monitor.worked(1);
                }
                StellarNewWizard.this.displayErrors();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private void importInWorkspace(ApplicationType application, URL entry, String workingSets) throws CoreException, IOException, InvocationTargetException, InterruptedException, SAXException {
        String projectName = application.getName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription newProjectDescription = workspace.newProjectDescription(projectName);
        IProject newProject = workspace.getRoot().getProject(projectName);
        if (newProject.exists()) {
            this.existing.add(newProject.getName());
            return;
        }
        newProject.create(newProjectDescription, (IProgressMonitor)new NullProgressMonitor());
        newProject.open((IProgressMonitor)new NullProgressMonitor());
        Utils.copydir((File)new File(FileLocator.toFileURL((URL)entry).getPath()), (IContainer)newProject);
        LogManager.getLogger().logInfo("copied");
        newProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.addToWorkingSets(newProject, workingSets);
        IWorkspaceDescription description = workspace.getDescription();
        if (!description.isAutoBuilding()) {
            description.setAutoBuilding(true);
            workspace.setDescription(description);
        }
    }

    private void addToWorkingSets(IProject project, String workingSets) {
        if (workingSets != null && workingSets.length() > 0) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            try {
                XMLMemento workingSetMem = XMLMemento.createReadRoot((Reader)new StringReader(workingSets));
                IMemento[] workingSetChildren = workingSetMem.getChildren();
                ArrayList<IWorkingSet> workingSetList = new ArrayList<IWorkingSet>(workingSetChildren.length);
                for (int i = 0; i < workingSetChildren.length; ++i) {
                    String wsName = workingSetChildren[i].getString("name");
                    IWorkingSet set = workingSetManager.getWorkingSet(wsName);
                    if (set == null) continue;
                    workingSetList.add(set);
                }
                IWorkingSet[] selectedWorkingSets = workingSetList.toArray(new IWorkingSet[workingSetList.size()]);
                if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
                    return;
                }
                workingSetManager.addToWorkingSets((IAdaptable)project, selectedWorkingSets);
            }
            catch (WorkbenchException e) {
                LogManager.getLogger().logError(Messages.StellarNewWizard_1);
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean canFinish() {
        if (this.canFinishEarly) {
            return true;
        }
        return super.canFinish();
    }

    public boolean isCanFinishEarly() {
        return this.canFinishEarly;
    }

    public void setCanFinishEarly(boolean canFinish) {
        this.canFinishEarly = canFinish;
    }

    private void displayErrors() {
        if (this.existing.size() > 0) {
            final StringBuffer existingProjects = new StringBuffer();
            for (String string : this.existing) {
                existingProjects.append(" - " + string + "\n");
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.StellarNewWizard_9, (String)(Messages.StellarNewWizard_10 + String.valueOf(existingProjects) + Messages.StellarNewWizard_11));
                }
            });
        }
    }
}

