/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.Messages;
import com.st.stellar.app.wizard.resources.StellarSupportedProducts;
import com.st.stellar.app.wizard.resources.types.BoardType;
import com.st.stellar.app.wizard.resources.types.DeviceType;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.wizards.AbstractWizardPage;
import com.st.stellar.osutils.OsUtils;
import com.st.stellar.utils.LogManager;
import com.st.stellar.utils.NaturalOrderComparator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class StellarNewWizardPage1
extends AbstractWizardPage {
    private static final int IMAGE_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 500;
    public static final int IMAGE_WIDTH = 120;
    private static final int BOARDS_COLUMNS = 6;
    private final Cursor cursorHand = new Cursor((Device)Display.getDefault(), 21);
    private final Cursor cursorArrow = new Cursor((Device)Display.getDefault(), 0);
    private ArrayList<Composite> boardComposites = new ArrayList();
    private Label imageLine;
    private ScrolledForm sc;
    private Combo lineCombo;
    private Combo familyCombo;
    private Combo deviceCombo;
    private static final String TITLE_WIZARD = Messages.StellarNewWizardPage1_3;
    private static final String DESCRIPTION_WIZARD = Messages.StellarNewWizardPage1_4;
    public static final String TITLE = Messages.StellarNewWizardPage1_5;
    public static final String DESCRIPTION = Messages.StellarNewWizardPage1_6;
    private boolean atLeastOneBoard;
    private Set<Resource> toBeDisposed = new HashSet<Resource>();
    private Image highlightImage = null;
    private static final Color RED = new Color((Device)Display.getDefault(), new RGB(250, 0, 0));
    private static final Color BLUE = new Color((Device)Display.getDefault(), new RGB(0, 0, 250));
    private static final Color WHITE = new Color((Device)Display.getDefault(), new RGB(255, 255, 255));

    public StellarNewWizardPage1(ISelection selection) {
        super(selection, TITLE, DESCRIPTION, 1);
        this.setTitle(TITLE_WIZARD);
        this.setDescription(DESCRIPTION_WIZARD);
    }

    public void dispose() {
        this.cursorHand.dispose();
        this.cursorArrow.dispose();
        this.toBeDisposed.stream().forEach(Resource::dispose);
        if (this.highlightImage != null) {
            this.highlightImage.dispose();
            this.highlightImage = null;
        }
        super.dispose();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite shell = parent;
        while (!(shell instanceof Shell) && shell.getParent() != null) {
            shell = shell.getParent();
        }
        Point newSize = shell.computeSize(800, 600);
        shell.setSize(new Point(newSize.x, newSize.y));
        Map<String, Object> props = this.getProps();
        FormLayout containerLayout = new FormLayout();
        this.container.setLayout((Layout)containerLayout);
        this.container.setBackground(BACKGROUND);
        Composite compFilters = this.toolkit.createComposite(this.container, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        compFilters.setLayout((Layout)layout);
        compFilters.setBackground(BACKGROUND);
        FormData compFiltersLayoutData = new FormData();
        compFiltersLayoutData.top = new FormAttachment(0);
        compFiltersLayoutData.left = new FormAttachment(0);
        compFiltersLayoutData.right = new FormAttachment(100);
        compFilters.setLayoutData((Object)compFiltersLayoutData);
        Composite compCombo = this.toolkit.createComposite(compFilters, 0);
        compCombo.setLayout((Layout)new TableWrapLayout());
        compCombo.setLayoutData((Object)new TableWrapData(256, 32));
        compCombo.setBackground(BACKGROUND);
        Label flabel = this.toolkit.createLabel(compCombo, Messages.StellarNewWizardPage1_11, 0);
        flabel.setLayoutData((Object)new TableWrapData(256, 32));
        flabel.setBackground(BACKGROUND);
        this.familyCombo = new Combo(compCombo, 8);
        this.familyCombo.setLayoutData((Object)new TableWrapData(256, 32));
        ArrayList families = StellarSupportedProducts.getInstance().getFamilies();
        this.familyCombo.setBackground(BACKGROUND);
        this.familyCombo.setItems(families.toArray(new String[families.size()]));
        this.familyCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StellarNewWizardPage1.this.familySelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StellarNewWizardPage1.this.familySelected();
            }
        });
        this.familyCombo.select(0);
        Label label = this.toolkit.createLabel(compCombo, Messages.StellarNewWizardPage1_7, 0);
        label.setLayoutData((Object)new TableWrapData(256, 32));
        label.setBackground(BACKGROUND);
        this.lineCombo = new Combo(compCombo, 8);
        this.lineCombo.setLayoutData((Object)new TableWrapData(256, 32));
        String[] lines = StellarSupportedProducts.getInstance().getLines();
        this.lineCombo.setBackground(BACKGROUND);
        this.lineCombo.setItems(lines);
        this.lineCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StellarNewWizardPage1.this.lineSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StellarNewWizardPage1.this.lineSelected();
            }
        });
        this.lineCombo.select(0);
        Label dlabel = this.toolkit.createLabel(compCombo, Messages.StellarNewWizardPage1_8, 0);
        dlabel.setLayoutData((Object)new TableWrapData(256, 32));
        dlabel.setBackground(BACKGROUND);
        this.deviceCombo = new Combo(compCombo, 8);
        this.deviceCombo.setLayoutData((Object)new TableWrapData(256, 32));
        ArrayList devices = StellarSupportedProducts.getInstance().getDevices();
        ArrayList<String> devicesLines = new ArrayList<String>();
        for (DeviceType device : devices) {
            boolean deviceLineFound = false;
            for (String deviceLine : devicesLines) {
                if (!deviceLine.equals(device.getName())) continue;
                deviceLineFound = true;
            }
            if (deviceLineFound) continue;
            devicesLines.add(device.getName());
        }
        this.deviceCombo.setItems(devicesLines.toArray(new String[devicesLines.size()]));
        this.deviceCombo.select(0);
        this.deviceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StellarNewWizardPage1.this.deviceSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StellarNewWizardPage1.this.deviceSelected();
            }
        });
        this.deviceCombo.setBackground(BACKGROUND);
        Composite compImage = this.toolkit.createComposite(compFilters, 0);
        compImage.setLayout((Layout)new TableWrapLayout());
        compImage.setLayoutData((Object)new TableWrapData(4, 256));
        compImage.setBackground(BACKGROUND);
        this.imageLine = this.toolkit.createLabel(compImage, "", 0);
        this.imageLine.setLayoutData((Object)new TableWrapData(4, 256));
        this.imageLine.setBackground(BACKGROUND);
        TableWrapData layoutGroupData = new TableWrapData(256, 256);
        layoutGroupData.colspan = 2;
        Group group = new Group(this.container, 4);
        group.setLayout((Layout)new TableWrapLayout());
        FormData groupLayoutData = new FormData();
        groupLayoutData.top = new FormAttachment((Control)compFilters);
        groupLayoutData.left = new FormAttachment(0);
        groupLayoutData.right = new FormAttachment(100);
        groupLayoutData.bottom = new FormAttachment(100);
        group.setLayoutData((Object)groupLayoutData);
        group.setBackground(WHITE);
        group.setText(Messages.StellarNewWizardPage1_9);
        TableWrapData layoutDataSC = new TableWrapData(256);
        layoutDataSC.maxHeight = 300;
        layoutDataSC.maxWidth = 500;
        TableWrapLayout layoutChild = new TableWrapLayout();
        layoutChild.numColumns = 6;
        layoutChild.makeColumnsEqualWidth = false;
        this.sc = this.toolkit.createScrolledForm((Composite)group);
        this.sc.setMinHeight(300);
        this.sc.setExpandVertical(true);
        this.sc.setLayout((Layout)new TableWrapLayout());
        this.sc.setLayoutData((Object)layoutDataSC);
        this.sc.getBody().setBackground(BACKGROUND);
        this.sc.setBackground(BACKGROUND);
        this.sc.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                StellarNewWizardPage1.this.sc.setFocus();
            }
        });
        this.sc.getBody().setLayout((Layout)layoutChild);
        props.put("board", null);
        this.toolkit.adapt((Composite)this.sc);
        this.setControl((Control)this.form.getParent());
        this.refresh();
    }

    private void drawBoards(final Map<String, Object> props, ScrolledForm sc, ArrayList<BoardType> boards) {
        for (Control control : this.boardComposites) {
            control.getParent().dispose();
        }
        this.boardComposites.clear();
        props.remove("board");
        if (boards.size() == 0) {
            Composite compNoBoard = this.toolkit.createComposite(sc.getBody(), 0);
            compNoBoard.setLayout((Layout)new TableWrapLayout());
            TableWrapData tableWrapData = new TableWrapData(256, 256);
            tableWrapData.maxWidth = 120;
            compNoBoard.setLayoutData((Object)tableWrapData);
            compNoBoard.setBackgroundMode(2);
            Composite container = this.toolkit.createComposite(compNoBoard, 0);
            container.setLayout((Layout)new TableWrapLayout());
            TableWrapData layoutCont = new TableWrapData(256, 256);
            container.setLayoutData((Object)layoutCont);
            Label label = new Label(container, 0);
            Image imageNoBoard = Activator.getDefault().getImage("no_board");
            this.toBeDisposed.add((Resource)imageNoBoard);
            label.setImage(imageNoBoard);
            this.boardComposites.add(container);
        } else {
            for (final BoardType boardType : boards) {
                Label link;
                final Composite compBoard = this.toolkit.createComposite(sc.getBody(), 0);
                compBoard.setLayout((Layout)new TableWrapLayout());
                TableWrapData layoutComp = new TableWrapData(256, 256);
                layoutComp.maxWidth = 120;
                compBoard.setLayoutData((Object)layoutComp);
                compBoard.setBackgroundMode(2);
                final Composite container = this.toolkit.createComposite(compBoard, 0);
                container.setLayout((Layout)new TableWrapLayout());
                TableWrapData layoutCont = new TableWrapData(256, 256);
                container.setLayoutData((Object)layoutCont);
                container.setData("board", (Object)boardType);
                this.boardComposites.add(container);
                ArrayList availableBoards = (ArrayList)props.get("board");
                if (props.get("board") != null && availableBoards.contains(boardType)) {
                    container.setData("selected", (Object)true);
                    this.highlight(true, container);
                } else {
                    container.setData("selected", (Object)false);
                    this.highlight(false, container);
                }
                final Canvas canvas = new Canvas(container, 0x20000000);
                canvas.setToolTipText(boardType.getDescription());
                TableWrapData layoutImage = new TableWrapData(256, 256);
                layoutImage.heightHint = 100;
                layoutImage.maxHeight = 100;
                canvas.setLayoutData((Object)layoutImage);
                canvas.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Point size = compBoard.getSize();
                        Point size2 = compBoard.computeSize(-1, size.y);
                        compBoard.setSize(Math.max(120, size2.x), size2.y);
                        Rectangle rect = canvas.getBounds();
                        Image img = boardType.getImage();
                        Rectangle imgBounds = img.getBounds();
                        e.gc.drawImage(img, (rect.width - imgBounds.width) / 2, (rect.height - imgBounds.height) / 2);
                    }
                });
                canvas.addMouseTrackListener(new MouseTrackListener(){

                    public void mouseHover(MouseEvent e) {
                        StellarNewWizardPage1.this.highlight(true, container);
                    }

                    public void mouseExit(MouseEvent e) {
                        StellarNewWizardPage1.this.highlight(false, container);
                        compBoard.setCursor(StellarNewWizardPage1.this.cursorArrow);
                        StellarNewWizardPage1.this.checkBoardSelection();
                    }

                    public void mouseEnter(MouseEvent e) {
                        StellarNewWizardPage1.this.highlight(true, container);
                        compBoard.setCursor(StellarNewWizardPage1.this.cursorHand);
                    }
                });
                canvas.addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent e) {
                    }

                    public void mouseDown(MouseEvent e) {
                        ArrayList availableBoards = (ArrayList)props.get("board");
                        if (props.get("board") != null && availableBoards.size() == 1 && availableBoards.contains(container.getData("board"))) {
                            ArrayList boards = StellarSupportedProducts.getBoardsLine((String)((String)props.get("line")));
                            props.put("board", boards);
                            StellarNewWizardPage1.this.refreshBoardSelection(null);
                        } else {
                            ArrayList<BoardType> boardsList = new ArrayList<BoardType>();
                            boardsList.add((BoardType)container.getData("board"));
                            props.put("board", boardsList);
                            StellarNewWizardPage1.this.refreshBoardSelection(container);
                        }
                        StellarNewWizardPage1.this.checkBoardSelection();
                        ((AbstractWizardPage)StellarNewWizardPage1.this.getNextPage()).refresh();
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
                TableWrapData layoutBoard = new TableWrapData(256, 64);
                layoutBoard.align = 4;
                if (boardType.getLink() != null && boardType.getLink().length() > 0) {
                    link = OsUtils.isLinux() ? this.toolkit.createHyperlink(compBoard, boardType.getCpn(), 0) : this.toolkit.createHyperlink(compBoard, boardType.getCpn(), 0x1000040);
                    link.addHyperlinkListener(new IHyperlinkListener(){

                        public void linkExited(HyperlinkEvent e) {
                        }

                        public void linkEntered(HyperlinkEvent e) {
                        }

                        public void linkActivated(HyperlinkEvent e) {
                            try {
                                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(boardType.getLink()));
                            }
                            catch (PartInitException e1) {
                                LogManager.getLogger().logError((Throwable)e1);
                            }
                            catch (MalformedURLException e1) {
                                LogManager.getLogger().logError((Throwable)e1);
                            }
                        }
                    });
                    link.setToolTipText(boardType.getDescription());
                    link.setLayoutData((Object)layoutBoard);
                    link.setEnabled(true);
                    continue;
                }
                link = this.toolkit.createLabel(compBoard, boardType.getCpn(), 0x1000040);
                link.setToolTipText(boardType.getDescription());
                link.setLayoutData((Object)layoutBoard);
                link.setEnabled(false);
            }
        }
        this.container.redraw();
        this.container.layout(true);
        this.container.update();
        sc.reflow(true);
    }

    private void highlight(boolean selected, Composite compBoard) {
        if (compBoard.isDisposed()) {
            return;
        }
        if (this.highlightImage != null && selected) {
            this.toBeDisposed.remove(this.highlightImage);
            this.highlightImage.dispose();
            this.highlightImage = null;
        }
        if (selected) {
            Point size = compBoard.getSize();
            this.highlightImage = Activator.getDefault().getImageResized("board.background", size.x, size.y);
            compBoard.setBackgroundImage(this.highlightImage);
        } else {
            compBoard.setBackgroundImage(null);
        }
    }

    private void refreshBoardSelection(Composite selected) {
        for (Composite c : this.boardComposites) {
            if (c.isDisposed()) continue;
            if (c.equals(selected)) {
                c.setData("selected", (Object)true);
                continue;
            }
            c.setData("selected", (Object)false);
        }
    }

    private void checkBoardSelection() {
        for (Composite c : this.boardComposites) {
            if (c.isDisposed()) continue;
            if (((Boolean)c.getData("selected")).booleanValue()) {
                this.highlight(true, c);
                continue;
            }
            this.highlight(false, c);
        }
    }

    private void drawBoardSelection(Map<String, Object> props) {
        String lineID = StellarSupportedProducts.getInstance().getLineID(this.lineCombo.getText());
        String familyID = (String)StellarSupportedProducts.getInstance().getFamiliesIDs().get(this.familyCombo.getSelectionIndex());
        ArrayList boardSelection = StellarSupportedProducts.getBoardsFamilyLineDevice((String)familyID, (String)lineID, (String)this.deviceCombo.getText());
        ArrayList<BoardType> boards = this.RemoveDupBoard(boardSelection);
        this.drawBoards(props, this.sc, boards);
        props.put("board", boards);
        this.atLeastOneBoard = boards.size() != 0;
        this.checkDialog();
        ((AbstractWizardPage)this.getNextPage()).refresh();
    }

    private void familySelected() {
        Map<String, Object> propsFamily = this.getProps();
        String familyID = (String)StellarSupportedProducts.getInstance().getFamiliesIDs().get(this.familyCombo.getSelectionIndex());
        propsFamily.put("family", familyID);
        this.imageLine.setImage(StellarSupportedProducts.getImage((String)familyID));
        this.updateLinesDevicesFilter();
        this.drawBoardSelection(propsFamily);
    }

    private void updateLinesDevicesFilter() {
        String familyID = (String)StellarSupportedProducts.getInstance().getFamiliesIDs().get(this.familyCombo.getSelectionIndex());
        ArrayList boardsFamily = StellarSupportedProducts.getBoardsFamily((String)familyID);
        ArrayList<BoardType> boards = this.RemoveDupBoard(boardsFamily);
        ArrayList<String> linesFamily = new ArrayList<String>();
        ArrayList<String> devicesLines = new ArrayList<String>();
        linesFamily.add(StellarSupportedProducts.LINE_ALL);
        for (BoardType board : boards) {
            String lineFamily = StellarSupportedProducts.getInstance().getLine(board.getLine());
            boolean lineFamilyFound = false;
            for (String line : linesFamily) {
                if (!line.equals(lineFamily)) continue;
                lineFamilyFound = true;
            }
            if (lineFamily != null) {
                if (lineFamilyFound) continue;
                linesFamily.add(lineFamily);
                continue;
            }
            System.out.println("Warning: A board component doesn't contain family information, return : " + board.getCpn() + " = " + lineFamily);
            for (BoardType boardinfo : boards) {
                System.out.println("BoardId-Debug : " + boardinfo.toString() + "-" + boardinfo.getFamily());
            }
        }
        linesFamily.remove(StellarSupportedProducts.LINE_ALL);
        linesFamily.sort((Comparator<String>)new NaturalOrderComparator());
        linesFamily.add(0, StellarSupportedProducts.LINE_ALL);
        this.lineCombo.setItems(linesFamily.toArray(new String[linesFamily.size()]));
        this.lineCombo.select(0);
        for (int i = 1; i < linesFamily.size(); ++i) {
            String Line = StellarSupportedProducts.getInstance().getLineID((String)linesFamily.get(i));
            ArrayList devicesLine = StellarSupportedProducts.getDevicesLine((String)Line);
            for (DeviceType device : devicesLine) {
                boolean deviceLineFound = false;
                for (String deviceLine : devicesLines) {
                    if (!deviceLine.equals(device.getName())) continue;
                    deviceLineFound = true;
                }
                if (deviceLineFound) continue;
                devicesLines.add(device.getName());
            }
        }
        this.deviceCombo.setItems(devicesLines.toArray(new String[devicesLines.size()]));
        this.deviceCombo.select(0);
    }

    private void lineSelected() {
        Map<String, Object> props = this.getProps();
        String lineID = StellarSupportedProducts.getInstance().getLineID(this.lineCombo.getText());
        props.put("line", lineID);
        this.updateDevicesFilter(lineID);
        this.imageLine.setImage(StellarSupportedProducts.getImage((String)lineID));
        if (this.lineCombo.getSelectionIndex() == 0) {
            this.familyCombo.select(0);
        }
        this.drawBoardSelection(props);
    }

    private void updateDevicesFilter(String lineID) {
        ArrayList devicesLine = StellarSupportedProducts.getDevicesLine((String)lineID);
        ArrayList<String> devicesLines = new ArrayList<String>();
        for (DeviceType device : devicesLine) {
            boolean deviceLineFound = false;
            for (String deviceLine : devicesLines) {
                if (!deviceLine.equals(device.getName())) continue;
                deviceLineFound = true;
            }
            if (deviceLineFound) continue;
            devicesLines.add(device.getName());
        }
        this.deviceCombo.setItems(devicesLines.toArray(new String[devicesLines.size()]));
        this.deviceCombo.select(0);
    }

    private void deviceSelected() {
        Map<String, Object> props = this.getProps();
        String deviceID = this.deviceCombo.getText();
        ArrayList devices = StellarSupportedProducts.getInstance().getDevices();
        for (DeviceType device : devices) {
            if (!device.getId().equals(this.deviceCombo.getText())) continue;
            deviceID = device.getId();
        }
        props.put("Device", deviceID);
        this.drawBoardSelection(props);
    }

    private ArrayList<BoardType> RemoveDupBoard(ArrayList<BoardType> boards) {
        ArrayList<BoardType> boardList = new ArrayList<BoardType>();
        for (BoardType board : boards) {
            boolean boardFound = false;
            for (BoardType boardItem : boardList) {
                if (boardItem.getCpn() == null || !boardItem.getCpn().equals(board.getCpn())) continue;
                boardFound = true;
            }
            if (boardFound || !ApplicationType.checkApplications(board)) continue;
            boardList.add(board);
        }
        return boardList;
    }

    @Override
    public void refresh() {
        this.lineSelected();
        this.deviceSelected();
        this.checkDialog();
    }

    @Override
    public void checkDialog() {
        if (!this.atLeastOneBoard) {
            this.setMessage(Messages.StellarNewWizardPage1_10, 1);
            this.setPageComplete(false);
        } else {
            this.setMessage(null);
            this.setPageComplete(true);
        }
    }
}

