/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.persistence;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.models.Category;
import com.st.stellar.app.wizard.models.Metadata;
import com.st.stellar.app.wizard.models.Tag;
import com.st.stellar.app.wizard.persistence.StringHolder;
import com.st.stellar.app.wizard.resources.types.BoardType;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterTagType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.ProcessingInstruction;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMModelProvider {
    public static Document buildDOM(Metadata model) {
        Element root = new Element("Stellar-Application-MetaData");
        ArrayList<Category> categories = model.getCategories();
        for (Category category : categories) {
            Element categoryElement = new Element("category");
            Element desc = new Element("description");
            desc.setText(category.getDescription());
            categoryElement.addContent((Content)desc);
            Attribute name = new Attribute("name", category.getName());
            categoryElement.setAttribute(name);
            ArrayList<Tag> tags = category.getTags();
            for (Tag tag : tags) {
                Element tagElement = new Element("meta");
                tagElement.setText(tag.getName());
                categoryElement.addContent((Content)tagElement);
            }
            root.addContent((Content)categoryElement);
        }
        return new Document(root);
    }

    public static Metadata parseDOM(Document domModel) throws IOException {
        Metadata model = new Metadata();
        Element root = domModel.getRootElement();
        ArrayList<Category> categories = new ArrayList<Category>();
        List categoryElements = root.getChildren("category");
        for (Element categoryElement : categoryElements) {
            Category category = new Category(categoryElement.getAttributeValue("name"));
            category.setDescription(categoryElement.getChildText("description"));
            category.setTags(DOMModelProvider.parseTags(categoryElement));
            categories.add(category);
        }
        model.setCategories(categories);
        return model;
    }

    private static ArrayList<Tag> parseTags(Element categoryElement) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List tagElements = categoryElement.getChildren("meta");
        for (Element tagElement : tagElements) {
            tags.add(new Tag(tagElement.getTextNormalize()));
        }
        return tags;
    }

    public static Object buildMetadata(ArrayList<IProject> projects) throws CoreException, SAXException, IOException {
        HashMap<String, String> piEclipse = new HashMap<String, String>();
        piEclipse.put("version", "3.4");
        Document document = new Document();
        document.addContent((Content)new ProcessingInstruction("eclipse", piEclipse));
        Element root = new Element("plugin");
        Element ext = new Element("extension");
        Attribute attPoint = new Attribute("point", "com.st.stellar.appbundle");
        ext.setAttribute(attPoint);
        for (IProject project : projects) {
            Element app = new Element("application");
            Attribute attName = new Attribute("name", project.getName());
            ArrayList<Element> meta = new ArrayList<Element>();
            StringHolder holder = new StringHolder();
            ArrayList<Element> metaApp = DOMModelProvider.addMetaFromAppMetadata(project);
            if (metaApp != null) {
                meta.addAll(metaApp);
            }
            Element desc = new Element("description");
            if (holder.value != null) {
                desc.setText(holder.value);
            } else {
                desc.setText("");
            }
            app.addContent((Content)desc);
            app.addContent(meta);
            app.setAttribute(attName);
            ext.addContent((Content)app);
        }
        root.addContent((Content)ext);
        document.addContent((Content)root);
        return document;
    }

    private static ArrayList<Tag> buildTags(String category) {
        Tag tag;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (category.equals(Category.BOARD)) {
            Tag tag2 = DOMModelProvider.getBoardTag();
            if (tag2 != null) {
                tags.add(tag2);
            }
        } else if (category.equals(Category.DEVICE)) {
            Tag tag3 = DOMModelProvider.getDeviceTag();
            if (tag3 != null) {
                tags.add(tag3);
            }
        } else if (category.equals(Category.DRIVERS)) {
            ArrayList<Tag> driverTags = DOMModelProvider.getDriverTags();
            if (driverTags != null) {
                tags.addAll(driverTags);
            }
        } else if (category.equals(Category.SHIELD) && (tag = DOMModelProvider.getShieldTags()) != null) {
            tags.add(tag);
        }
        return tags;
    }

    public static ArrayList<Tag> getDriverTags() {
        ArrayList<Tag> tags = null;
        return tags;
    }

    public static Tag getBoardTag() {
        Tag tag = null;
        return tag;
    }

    public static Tag getShieldTags() {
        Tag tag = null;
        return tag;
    }

    private static Tag getDeviceTag() {
        Tag tag = null;
        return tag;
    }

    private static ArrayList<Element> addMetaFromAppMetadata(IProject project) throws CoreException, SAXException, IOException {
        IFile file = project.getFile((IPath)new Path("/application.meta"));
        if (file.exists()) {
            InputStream is = file.getContents(true);
            DOMBuilder builder = new DOMBuilder();
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(is));
            org.w3c.dom.Document doc = parser.getDocument();
            Document domModel = builder.build(doc);
            Metadata model = DOMModelProvider.parseDOM(domModel);
            return DOMModelProvider.buildMetadataXML(model);
        }
        return null;
    }

    public static ArrayList<Element> buildMetadataXML(Metadata model) {
        if (model == null) {
            return null;
        }
        ArrayList<Element> children = new ArrayList<Element>();
        ArrayList<Category> categories = model.getCategories();
        for (Category category : categories) {
            Element catElement = new Element("category");
            Element desc = new Element("description");
            desc.setText(category.getDescription());
            catElement.addContent((Content)desc);
            Attribute attName = new Attribute("name", category.getName());
            catElement.setAttribute(attName);
            ArrayList<Tag> tags = category.getTags();
            for (Tag tag : tags) {
                Element tagElement = new Element("metadata");
                Attribute attValue = new Attribute("value", tag.getName());
                tagElement.setAttribute(attValue);
                catElement.addContent((Content)tagElement);
            }
            children.add(catElement);
        }
        return children;
    }

    public static void createPluginXML(String destFile, Document document) throws IOException {
        File file = new File(destFile);
        FileOutputStream os = new FileOutputStream(file);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(document, (OutputStream)os);
    }

    public static ArrayList<FilterTagCategory> loadFilters(ArrayList<BoardType> boards) {
        ArrayList<FilterTagCategory> categories = new ArrayList<FilterTagCategory>();
        ArrayList<ApplicationType> applications = Activator.getDefault().getApplicationsRegistry();
        for (ApplicationType application : applications) {
            if (!application.supportBoard(boards)) continue;
            ArrayList<FilterTagCategory> appCategories = application.getCategories();
            for (FilterTagCategory appCategory : appCategories) {
                if (appCategory.getName().equals(Category.DEVICE)) continue;
                FilterTagCategory added = DOMModelProvider.alreadyAdded(categories, appCategory);
                if (added == null) {
                    FilterTagCategory cat = new FilterTagCategory(appCategory.getName());
                    cat.setDescription(appCategory.getDescription());
                    cat.getTags().addAll(appCategory.getTags());
                    categories.add(cat);
                    continue;
                }
                ArrayList<FilterTagType> tags = new ArrayList<FilterTagType>();
                for (FilterTagType tag : appCategory.getTags()) {
                    if (DOMModelProvider.alreadyAdded(added.getTags(), tag)) continue;
                    tags.add(tag);
                }
                added.getTags().addAll(tags);
            }
        }
        return categories;
    }

    private static boolean alreadyAdded(ArrayList<FilterTagType> tags, FilterTagType entry) {
        for (FilterTagType tag : tags) {
            if (!tag.getName().equalsIgnoreCase(entry.getName())) continue;
            return true;
        }
        return false;
    }

    private static FilterTagCategory alreadyAdded(ArrayList<FilterTagCategory> categories, FilterTagCategory appCategory) {
        for (FilterTagCategory cat : categories) {
            if (!cat.getName().equalsIgnoreCase(appCategory.getName())) continue;
            return cat;
        }
        return null;
    }

    public static ArrayList<ApplicationType> getApplications(String line, String device, ArrayList<BoardType> boards) {
        ArrayList<ApplicationType> applications = Activator.getDefault().getApplicationsRegistry();
        ArrayList<ApplicationType> filteredApps = new ArrayList<ApplicationType>();
        if (boards == null) {
            filteredApps.addAll(applications);
        } else {
            block0: for (ApplicationType app : applications) {
                for (FilterTagCategory cat : app.getCategories()) {
                    FilterTagType tag;
                    if (!cat.getName().equals(Category.BOARD)) continue;
                    Iterator<FilterTagType> iterator = cat.getTags().iterator();
                    if (!iterator.hasNext() || !ApplicationType.checkBoard((tag = iterator.next()).getName(), boards) || !app.supportLine(line) || !app.supportDevice(device)) continue block0;
                    filteredApps.add(app);
                    continue block0;
                }
            }
        }
        return filteredApps;
    }
}

