/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.Messages;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractWizardPage
extends WizardPage {
    protected static final int DEFAULT_HEIGHT = 300;
    protected FormToolkit toolkit;
    protected ScrolledForm form;
    protected Map<String, Object> props;
    private String description;
    protected Composite container;
    protected Group section;
    private int step;
    private String title;
    public static final String KEY_APPLICATIONS = "applications";
    public static final String KEY_FAMILY = "family";
    public static final String KEY_LINE = "line";
    public static final String KEY_DEVICE = "Device";
    public static final String KEY_BOARD = "board";
    public static final String KEY_SELECTED = "selected";
    public static final int TYPE_LIB = 0;
    public static final int TYPE_SCR = 1;
    public static final int TYPE_COM = 2;
    protected static final Color BACKGROUND = new Color((Device)Display.getDefault(), new RGB(240, 240, 240));

    public AbstractWizardPage(ISelection selection, String title, String description, int step) {
        super(title);
        this.title = title;
        this.step = step;
        this.description = description;
        this.props = (Map)((IStructuredSelection)selection).getFirstElement();
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("wiz.ban"));
    }

    public void createControl(Composite parent) {
        Control[] c;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.paintBordersFor(parent);
        Composite pageParent = this.toolkit.createComposite(parent, 2048);
        pageParent.setLayout((Layout)new FormLayout());
        this.form = this.toolkit.createScrolledForm(pageParent);
        this.form.setBackground(BACKGROUND);
        this.form.setLayout((Layout)new TableWrapLayout());
        FormData formLayoutData = new FormData();
        formLayoutData.top = new FormAttachment(0);
        formLayoutData.bottom = new FormAttachment(100);
        formLayoutData.left = new FormAttachment(0);
        formLayoutData.right = new FormAttachment(100);
        this.form.setLayoutData((Object)formLayoutData);
        this.form.getBody().setLayout((Layout)new FormLayout());
        this.form.getBody().setLayoutData((Object)new TableWrapData(256, 256));
        this.form.getBody().setBackground(BACKGROUND);
        this.form.getForm().getHead().setBackground(BACKGROUND);
        for (Control control : c = this.form.getForm().getHead().getChildren()) {
            control.setBackground(BACKGROUND);
        }
        this.form.setText(this.title);
        this.form.getForm().setBackground(BACKGROUND);
        this.form.setImage(Activator.getDefault().getImage("logo32"));
        this.section = new Group(this.form.getBody(), 4);
        this.section.setText(Messages.AbstractWizardPage_1 + this.step + ":");
        this.section.setToolTipText(this.description);
        this.section.setLayout((Layout)new TableWrapLayout());
        FormData sectionLayoutData = new FormData();
        sectionLayoutData.top = new FormAttachment(0);
        sectionLayoutData.bottom = new FormAttachment(100);
        sectionLayoutData.left = new FormAttachment(0);
        sectionLayoutData.right = new FormAttachment(100);
        this.section.setLayoutData((Object)sectionLayoutData);
        this.container = this.section;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public abstract void refresh();

    public abstract void checkDialog();
}

