/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.Messages;
import com.st.stellar.app.wizard.listeners.AppViewerSortListener;
import com.st.stellar.app.wizard.persistence.DOMModelProvider;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.types.FilterTagCategory;
import com.st.stellar.app.wizard.types.FilterType;
import com.st.stellar.app.wizard.wizards.AbstractWizardPage;
import com.st.stellar.app.wizard.wizards.AppTableComparator;
import com.st.stellar.app.wizard.wizards.AppsFilter;
import com.st.stellar.app.wizard.wizards.AppsLabelProvider;
import com.st.stellar.app.wizard.wizards.FilterCellLabelProvider;
import com.st.stellar.app.wizard.wizards.FilterContentProvider;
import com.st.stellar.app.wizard.wizards.FilterEditingSupport;
import com.st.stellar.app.wizard.wizards.IFilterTextprovider;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class StellarNewWizardPage2
extends AbstractWizardPage
implements IFilterTextprovider {
    public static final String TITLE = Messages.StellarNewWizardPage2_1;
    public static final String DESCRIPTION = Messages.StellarNewWizardPage2_13;
    private TableViewer filterViewer;
    private CheckboxTableViewer appsViewer;
    private Text filterText;
    private ArrayList<FilterTagCategory> categories;
    private FilterType filter;
    private static final String TITLE_WIZARD = Messages.StellarNewWizardPage2_3;
    private static final String DESCRIPTION_WIZARD = Messages.StellarNewWizardPage2_4;
    private static final int FILTERVIEWER_WIDTH = 200;
    private static final Color WHITE = new Color((Device)Display.getDefault(), new RGB(255, 255, 255));
    protected static final Color BACKGROUND = new Color((Device)Display.getDefault(), new RGB(240, 240, 240));

    public StellarNewWizardPage2(ISelection selection) {
        super(selection, TITLE, DESCRIPTION, 2);
        this.setTitle(TITLE_WIZARD);
        this.setDescription(DESCRIPTION_WIZARD);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite shell = parent;
        while (!(shell instanceof Shell) && shell.getParent() != null) {
            shell = shell.getParent();
        }
        Point newSize = shell.computeSize(800, 600);
        shell.setSize(new Point(newSize.x, newSize.y));
        final Map<String, Object> props = this.getProps();
        FormLayout containerLayout = new FormLayout();
        this.container.setLayout((Layout)containerLayout);
        Composite container1 = new Composite(this.container, 0);
        Composite container2 = new Composite(this.container, 0);
        Composite container3 = new Composite(this.container, 0);
        Composite container4 = new Composite(this.container, 0);
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 5);
        data1.right = new FormAttachment(100, -5);
        data1.top = new FormAttachment(0, 5);
        container1.setLayoutData((Object)data1);
        TableWrapLayout layout = new TableWrapLayout();
        container1.setLayout((Layout)layout);
        container1.setBackground(BACKGROUND);
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 5);
        data2.right = new FormAttachment(100, -5);
        data2.top = new FormAttachment((Control)container1, 0);
        container2.setLayoutData((Object)data2);
        TableWrapLayout layout2 = new TableWrapLayout();
        layout2.numColumns = 3;
        container2.setLayout((Layout)layout2);
        container2.setBackground(BACKGROUND);
        FormData data3 = new FormData();
        data3.left = new FormAttachment(0, 5);
        data3.right = new FormAttachment(100, -5);
        data3.top = new FormAttachment((Control)container2, 0);
        data3.bottom = new FormAttachment((Control)container4, 5);
        container3.setLayoutData((Object)data3);
        container3.setBackground(BACKGROUND);
        TableWrapLayout layout3 = new TableWrapLayout();
        layout3.numColumns = 1;
        container3.setLayout((Layout)layout3);
        FormData data4 = new FormData();
        data4.bottom = new FormAttachment(100, 5);
        container4.setLayoutData((Object)data4);
        TableWrapLayout layout4 = new TableWrapLayout();
        layout4.numColumns = 1;
        container4.setLayout((Layout)layout4);
        container4.setBackground(BACKGROUND);
        Composite comp = this.toolkit.createComposite(container1);
        comp.setLayout((Layout)new TableWrapLayout());
        comp.setLayoutData((Object)new TableWrapData(256, 256));
        comp.setBackground(BACKGROUND);
        Label label = this.toolkit.createLabel(comp, Messages.StellarNewWizardPage2_5, 0);
        label.setLayoutData((Object)new TableWrapData(256, 256));
        label.setBackground(BACKGROUND);
        TableWrapData layoutDataFilter = new TableWrapData(256, 256);
        layoutDataFilter.maxHeight = 150;
        layoutDataFilter.heightHint = 150;
        this.categories = DOMModelProvider.loadFilters(null);
        this.filter = new FilterType(this.categories, this);
        this.filterViewer = new TableViewer(comp, 84736);
        Table table = this.filterViewer.getTable();
        table.setLayout((Layout)new TableWrapLayout());
        table.setLayoutData((Object)layoutDataFilter);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.filterViewer.setContentProvider((IContentProvider)new FilterContentProvider());
        this.filterViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StellarNewWizardPage2.this.updateSelections();
            }
        });
        this.filterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StellarNewWizardPage2.this.filterViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        int columnCount = 0;
        for (FilterTagCategory c : this.categories) {
            TableViewerColumn column = new TableViewerColumn(this.filterViewer, 768);
            column.getColumn().setMoveable(true);
            column.getColumn().setResizable(true);
            column.getColumn().setText(c.getName());
            column.getColumn().setToolTipText(c.getDescription());
            column.getColumn().setWidth(200);
            column.setLabelProvider((CellLabelProvider)new FilterCellLabelProvider(c));
            column.setEditingSupport((EditingSupport)new FilterEditingSupport(column.getViewer(), this, columnCount++));
        }
        this.filterViewer.setInput((Object)this.filter);
        this.toolkit.adapt((Composite)table);
        table.update();
        ArrayList selectedApplications = new ArrayList();
        props.put("applications", selectedApplications);
        label = this.toolkit.createLabel(container2, Messages.StellarNewWizardPage2_6, 0);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        label.setBackground(BACKGROUND);
        this.filterText = new Text(container2, 2048);
        this.filterText.setLayoutData((Object)new TableWrapData(256, 256));
        this.filterText.setMessage(Messages.StellarNewWizardPage2_11);
        this.filterText.setToolTipText(Messages.StellarNewWizardPage2_16);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                StellarNewWizardPage2.this.appsViewer.refresh();
            }
        });
        ToolBar bar = new ToolBar(container2, 0);
        bar.setLayoutData((Object)new TableWrapData(8, 256));
        ToolItem selectAll = new ToolItem(bar, 8);
        selectAll.setToolTipText(Messages.StellarNewWizardPage2_0);
        selectAll.setImage(Activator.getDefault().getImage("select.all"));
        selectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StellarNewWizardPage2.this.appsViewer.setAllChecked(true);
                ArrayList apps = (ArrayList)props.get("applications");
                for (int index = 0; index < StellarNewWizardPage2.this.appsViewer.getTable().getItemCount(); ++index) {
                    ApplicationType app = (ApplicationType)StellarNewWizardPage2.this.appsViewer.getElementAt(index);
                    if (apps.contains(app)) continue;
                    apps.add(app);
                }
                StellarNewWizardPage2.this.checkDialog();
                ((AbstractWizardPage)StellarNewWizardPage2.this.getNextPage()).refresh();
            }
        });
        ToolItem deselectAll = new ToolItem(bar, 8);
        deselectAll.setToolTipText(Messages.StellarNewWizardPage2_2);
        deselectAll.setImage(Activator.getDefault().getImage("deselect.all"));
        deselectAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StellarNewWizardPage2.this.appsViewer.setAllChecked(false);
                ArrayList apps = (ArrayList)props.get("applications");
                apps.clear();
                StellarNewWizardPage2.this.checkDialog();
                ((AbstractWizardPage)StellarNewWizardPage2.this.getNextPage()).refresh();
            }
        });
        AppTableComparator comparator = new AppTableComparator();
        table = new Table(container3, 68384);
        this.appsViewer = new CheckboxTableViewer(table);
        TableWrapData layoutDataApps = new TableWrapData(256, 256);
        table.setLayout((Layout)new TableWrapLayout());
        table.setLayoutData((Object)layoutDataApps);
        table.setHeaderVisible(true);
        this.appsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.appsViewer.setFilters(new ViewerFilter[]{new AppsFilter(this.filter)});
        this.appsViewer.setComparator((ViewerComparator)comparator);
        TableViewerColumn column = new TableViewerColumn((TableViewer)this.appsViewer, 16384);
        column.getColumn().setMoveable(true);
        column.getColumn().setResizable(true);
        column.getColumn().setText(Messages.StellarNewWizardPage2_7);
        column.getColumn().setToolTipText(Messages.StellarNewWizardPage2_8);
        column.getColumn().setWidth(250);
        column.setLabelProvider((CellLabelProvider)new AppsLabelProvider());
        column.getColumn().addSelectionListener((SelectionListener)new AppViewerSortListener(comparator, 0, (TableViewer)this.appsViewer, column));
        column = new TableViewerColumn((TableViewer)this.appsViewer, 16384);
        column.getColumn().setMoveable(true);
        column.getColumn().setResizable(true);
        column.getColumn().setText(Messages.StellarNewWizardPage2_9);
        column.getColumn().setToolTipText(Messages.StellarNewWizardPage2_10);
        column.getColumn().setWidth(300);
        column.setLabelProvider((CellLabelProvider)new AppsLabelProvider());
        column.getColumn().addSelectionListener((SelectionListener)new AppViewerSortListener(comparator, 1, (TableViewer)this.appsViewer, column));
        column = new TableViewerColumn((TableViewer)this.appsViewer, 16384);
        column.getColumn().setMoveable(true);
        column.getColumn().setResizable(true);
        column.getColumn().setText(Messages.StellarNewWizardPage2_14);
        column.getColumn().setToolTipText(Messages.StellarNewWizardPage2_15);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)new AppsLabelProvider());
        column.getColumn().addSelectionListener((SelectionListener)new AppViewerSortListener(comparator, 1, (TableViewer)this.appsViewer, column));
        columnCount = 2;
        for (FilterTagCategory c : this.categories) {
            column = new TableViewerColumn((TableViewer)this.appsViewer, 16384);
            column.getColumn().setMoveable(true);
            column.getColumn().setResizable(true);
            column.getColumn().setText(c.getName());
            column.getColumn().setToolTipText(c.getDescription());
            column.getColumn().setWidth(80);
            column.setLabelProvider((CellLabelProvider)new AppsLabelProvider());
            column.getColumn().addSelectionListener((SelectionListener)new AppViewerSortListener(comparator, columnCount++, (TableViewer)this.appsViewer, column));
        }
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    ArrayList apps = (ArrayList)props.get("applications");
                    TableItem item = (TableItem)event.item;
                    int index = -1;
                    for (index = 0; index < StellarNewWizardPage2.this.appsViewer.getTable().getItemCount() && !StellarNewWizardPage2.this.appsViewer.getTable().getItem(index).equals(item); ++index) {
                    }
                    ApplicationType app = (ApplicationType)StellarNewWizardPage2.this.appsViewer.getElementAt(index);
                    if (item.getChecked()) {
                        if (!apps.contains(app)) {
                            apps.add(app);
                        }
                    } else {
                        apps.remove(app);
                    }
                    StellarNewWizardPage2.this.checkDialog();
                    ((AbstractWizardPage)StellarNewWizardPage2.this.getNextPage()).refresh();
                }
            }
        });
        this.toolkit.adapt((Composite)table);
        table.update();
        Label ilabel = this.toolkit.createLabel(container4, "", 0);
        ilabel.setImage(Activator.getDefault().getImage("step.banner"));
        TableWrapData ilabelData = new TableWrapData(256, 16);
        ilabel.setLayoutData((Object)ilabelData);
        data4.left = new FormAttachment(50, -ilabel.getImage().getBounds().width / 2);
        ilabel.setBackground(BACKGROUND);
        this.container.setBackground(BACKGROUND);
        this.setControl((Control)this.form.getParent());
        this.refresh();
    }

    @Override
    public void checkDialog() {
        TableItem[] items;
        boolean atLeastOneApp = false;
        this.updateSelections();
        for (TableItem item : items = this.appsViewer.getTable().getItems()) {
            if (!item.getChecked()) continue;
            atLeastOneApp = true;
        }
        if (!atLeastOneApp) {
            this.setErrorMessage(Messages.StellarNewWizardPage2_12);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private void updateSelections() {
        boolean found = false;
        ArrayList apps = (ArrayList)this.getProps().get("applications");
        ArrayList<ApplicationType> removed = new ArrayList<ApplicationType>();
        for (ApplicationType app : apps) {
            found = false;
            for (int index = 0; index < this.appsViewer.getTable().getItemCount(); ++index) {
                ApplicationType tableApp = (ApplicationType)this.appsViewer.getElementAt(index);
                if (!tableApp.equals(app)) continue;
                found = true;
                this.appsViewer.getTable().getItem(index).setChecked(true);
            }
            if (found) continue;
            removed.add(app);
        }
        apps.removeAll(removed);
    }

    @Override
    public void refresh() {
        if (this.appsViewer != null && this.filterViewer != null) {
            ArrayList boards = (ArrayList)this.getProps().get("board");
            String line = (String)this.getProps().get("line");
            String device = (String)this.getProps().get("Device");
            this.appsViewer.setInput(DOMModelProvider.getApplications(line, device, boards));
            this.categories = DOMModelProvider.loadFilters(boards);
            this.filter.setCategories(this.categories);
            this.updatefiltercategories();
            for (int columnIndex = 0; columnIndex < this.categories.size(); ++columnIndex) {
                CellLabelProvider columnLabelProvider = this.filterViewer.getLabelProvider(columnIndex);
                if (!(columnLabelProvider instanceof FilterCellLabelProvider)) continue;
                ((FilterCellLabelProvider)columnLabelProvider).setCategory(this.categories.get(columnIndex));
            }
            this.filterViewer.setInput((Object)this.filter);
            this.appsViewer.refresh(true);
            this.filterViewer.refresh(true);
            ((AbstractWizardPage)this.getNextPage()).refresh();
            this.getContainer().updateButtons();
            this.checkDialog();
        }
        this.getShell().layout(true, true);
    }

    public void updatefiltercategories() {
        for (int columnindex = 0; columnindex < this.filterViewer.getTable().getColumnCount(); ++columnindex) {
            this.filterViewer.getTable().getColumn(columnindex).setText("");
            if (columnindex < this.categories.size()) {
                this.filterViewer.getTable().getColumn(columnindex).setText(this.categories.get(columnindex).getName());
                this.filterViewer.getTable().getColumn(columnindex).setWidth(200);
                continue;
            }
            this.filterViewer.getTable().getColumn(columnindex).setWidth(0);
        }
    }

    @Override
    public String getFilterText() {
        return this.filterText.getText();
    }
}

