/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.app.wizard.wizards;

import com.st.stellar.app.wizard.Activator;
import com.st.stellar.app.wizard.Messages;
import com.st.stellar.app.wizard.resources.types.BoardType;
import com.st.stellar.app.wizard.types.ApplicationType;
import com.st.stellar.app.wizard.wizards.AbstractWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class StellarNewWizardPage3
extends AbstractWizardPage {
    public static final String TITLE = Messages.StellarNewWizardPage3_1;
    public static final String DESCRIPTION = Messages.StellarNewWizardPage3_2;
    private Table table;
    private Label boardLabel;
    private static final String TITLE_WIZARD = Messages.StellarNewWizardPage3_3;
    private static final String DESCRIPTION_WIZARD = Messages.StellarNewWizardPage3_4;
    private WorkingSetGroup _workingSetGroup;

    public StellarNewWizardPage3(ISelection selection) {
        super(selection, TITLE, DESCRIPTION, 3);
        this.setTitle(TITLE_WIZARD);
        this.setDescription(DESCRIPTION_WIZARD);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite shell = parent;
        while (!(shell instanceof Shell) && shell.getParent() != null) {
            shell = shell.getParent();
        }
        Point newSize = shell.computeSize(800, 600);
        shell.setSize(new Point(newSize.x, newSize.y));
        FormLayout containerLayout = new FormLayout();
        this.container.setLayout((Layout)containerLayout);
        Composite container1 = new Composite(this.container, 0);
        Composite container2 = new Composite(this.container, 0);
        Composite container3 = new Composite(this.container, 0);
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 5);
        data1.right = new FormAttachment(100, -5);
        data1.top = new FormAttachment(0, 5);
        container1.setLayoutData((Object)data1);
        TableWrapLayout layout1 = new TableWrapLayout();
        container1.setLayout((Layout)layout1);
        container1.setBackground(BACKGROUND);
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 5);
        data2.right = new FormAttachment(100, -5);
        data2.top = new FormAttachment((Control)container1, 0);
        data2.bottom = new FormAttachment((Control)container3, 5);
        container2.setLayoutData((Object)data2);
        container2.setBackground(BACKGROUND);
        TableWrapLayout layout2 = new TableWrapLayout();
        layout2.numColumns = 1;
        container2.setLayout((Layout)layout2);
        FormData data3 = new FormData();
        data3.left = new FormAttachment(0, 5);
        data3.bottom = new FormAttachment(100, 5);
        data3.right = new FormAttachment(100, -5);
        container3.setLayoutData((Object)data3);
        TableWrapLayout layout3 = new TableWrapLayout();
        layout3.numColumns = 1;
        container3.setLayout((Layout)layout3);
        Label doneImage = this.toolkit.createLabel(container1, "");
        doneImage.setImage(Activator.getDefault().getImage("step.4.done"));
        doneImage.setLayoutData((Object)new TableWrapData(4, 256));
        doneImage.setBackground(BACKGROUND);
        this.boardLabel = this.toolkit.createLabel(container1, "", 0);
        this.boardLabel.setLayoutData((Object)new TableWrapData(256, 256));
        this.boardLabel.setBackground(BACKGROUND);
        this.table = this.toolkit.createTable(container2, 2816);
        TableWrapData layoutTable = new TableWrapData(256, 256);
        this.table.setLayoutData((Object)layoutTable);
        this.table.setHeaderVisible(true);
        TableColumn tc0 = new TableColumn(this.table, 0);
        tc0.setWidth(150);
        tc0.setResizable(true);
        tc0.setText(Messages.StellarNewWizardPage3_7);
        TableColumn tcq = new TableColumn(this.table, 0);
        tcq.setWidth(450);
        tcq.setText(Messages.StellarNewWizardPage3_8);
        tcq.setResizable(true);
        Composite wsContainer = new Composite(container3, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        wsContainer.setLayout((Layout)layout);
        TableWrapData layoutWsGroup = new TableWrapData(256, 256);
        wsContainer.setLayoutData((Object)layoutWsGroup);
        IWorkingSet[] wsList = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        List<String> distinctWsList = Arrays.stream(wsList).map(IWorkingSet::getId).distinct().collect(Collectors.toList());
        if (!distinctWsList.contains("org.eclipse.ui.resourceWorkingSetPage")) {
            distinctWsList.add("org.eclipse.ui.resourceWorkingSetPage");
        }
        this._workingSetGroup = new WorkingSetGroup(wsContainer, (IStructuredSelection)StructuredSelection.EMPTY, distinctWsList.toArray(new String[distinctWsList.size()]));
        this.setControl((Control)this.form.getParent());
        this.refresh();
    }

    @Override
    public void checkDialog() {
    }

    @Override
    public void refresh() {
        String board = null;
        if (this.boardLabel != null && this.table != null) {
            Map<String, Object> props = this.getProps();
            ArrayList apps = (ArrayList)props.get("applications");
            ArrayList boards = (ArrayList)props.get("board");
            if (boards != null && boards.size() == 1) {
                board = (BoardType)boards.get(0);
            }
            this.boardLabel.setText(Messages.StellarNewWizardPage3_15 + String.valueOf(board != null ? board : Messages.StellarNewWizardPage3_16));
            this.table.removeAll();
            for (ApplicationType app : apps) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(new String[]{app.getName(), app.getDescription()});
            }
            this.table.update();
            this.checkDialog();
        }
        this.getShell().layout(true, true);
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this._workingSetGroup == null ? new IWorkingSet[]{} : this._workingSetGroup.getSelectedWorkingSets();
    }
}

