/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.clock.api.impl;

import com.st.stellar.clocktree.api.ClockAPI;
import com.st.stellar.clocktree.api.ClockPointReference;
import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.component.API.ExternalAttributeValueResult;
import com.st.stellar.component.Application;
import com.st.stellar.component.Component;
import com.st.stellar.component.DerivedAttributesNotifier;
import com.st.stellar.external.api.ExternalAPI;
import com.st.stellar.external.api.ExternalAPIFactory;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ClockAPIImpl
implements ClockAPI {
    EMap<String, EMap<String, ClockPointReference>> clockPoints = new BasicEMap();
    static Logger logger = LogManager.getLogger(DerivedAttributesNotifier.class);
    static int indent = 0;

    public ClockAPIImpl() {
        ExternalAPIFactory.INSTANCE.declareAPI("ClockAPI", (ExternalAPI)this);
    }

    @Override
    public ExternalAttributeValueResult getClockPoint(EObject obj, Component previousComponent, String pluginId, String clockPointName, EAttribute attr, Long oldValue) {
        Application app = ComponentAPI.getApplication((Resource)obj.eResource());
        if (app == null) {
            return null;
        }
        Component dependentComponent = ComponentAPI.getConfigurator((Application)app, (String)pluginId);
        Component root = ComponentAPI.getConfiguratorProperty((Component)dependentComponent);
        if (Component.class.isInstance(root)) {
            Component comp = (Component)Component.class.cast(root);
            EMap pluginsFunctions = (EMap)this.clockPoints.get((Object)clockPointName);
            if (pluginsFunctions == null) {
                logger.error((Object)("No plugin provides clockPoint named '" + clockPointName + "'"));
            } else {
                Set pluginSet = pluginsFunctions.keySet();
                for (String plugin : pluginSet) {
                    if (!comp.getExportedFeatures().contains((Object)plugin)) continue;
                    String componentActualPlugin = comp.eClass().getEPackage().getNsPrefix();
                    ClockPointReference callback = (ClockPointReference)pluginsFunctions.get((Object)componentActualPlugin);
                    Object res = callback.getClockPoint((EObject)comp);
                    ComponentAPI.getInstance().setAttributeValue((EObject)comp, attr, res.toString());
                    if (previousComponent != comp) {
                        ExternalAttributeValueResult result = new ExternalAttributeValueResult(res, null);
                        return result;
                    }
                    ExternalAttributeValueResult result = new ExternalAttributeValueResult(res, comp);
                    return result;
                }
            }
        } else {
            ComponentAPI.openConfiguratorInEditor((Component)dependentComponent);
            return new ExternalAttributeValueResult((Object)oldValue, null);
        }
        return null;
    }

    @Override
    public void addClockPoint(String clockPointName, ClockPointReference callback, String ... pluginIds) {
        EMap pluginsFunctions = (EMap)this.clockPoints.get((Object)clockPointName);
        if (pluginsFunctions == null) {
            pluginsFunctions = new BasicEMap();
            this.clockPoints.put((Object)clockPointName, (Object)pluginsFunctions);
        }
        for (String pluginId : pluginIds) {
            pluginsFunctions.put((Object)pluginId, (Object)callback);
        }
    }
}

