/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.clocktree.ui;

import com.st.stellar.component.Component;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emfforms.spi.swt.core.ui.SWTValidationHelper;
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;

public class ClockValidationServiceLabelDecorator
implements ILabelDecorator {
    private final DiagnosticCache cache;
    private final TreeViewer viewer;
    private final ResourceManager images;

    public ClockValidationServiceLabelDecorator(TreeViewer viewer, Notifier input, DiagnosticCache cache) {
        this.viewer = viewer;
        this.cache = cache;
        this.images = new DeviceResourceManager((Device)viewer.getControl().getDisplay());
        cache.registerValidationListener(new DiagnosticCache.ValidationListener(){

            public void revalidationOccurred(Collection<EObject> object, boolean potentialStructuralChange) {
                if (potentialStructuralChange) {
                    for (EObject o : object) {
                        ClockValidationServiceLabelDecorator.this.refreshViewer(o);
                    }
                } else {
                    for (EObject o : object) {
                        ClockValidationServiceLabelDecorator.this.updateViewer(o);
                    }
                }
            }
        });
        viewer.refresh();
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return image;
        }
        if (!EObject.class.isInstance(element) && !Resource.class.isInstance(element)) {
            return image;
        }
        Diagnostic diagnostic = Component.class.isInstance(element) ? Diagnostician.INSTANCE.validate((EObject)EObject.class.cast(element)) : (Diagnostic)this.cache.getCachedValue(element);
        int severity = diagnostic.getSeverity();
        ImageDescriptor validationOverlayDescriptor = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(severity);
        if (validationOverlayDescriptor == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        Point size = new Point(bounds.width, bounds.height);
        DecorationOverlayIcon icon = new DecorationOverlayIcon(image, new ImageDescriptor[]{validationOverlayDescriptor}, size);
        return (Image)this.images.get((DeviceResourceDescriptor)icon);
    }

    protected void refreshViewer(EObject element) {
        this.viewer.refresh((Object)element, true);
    }

    protected void updateViewer(EObject element) {
        this.viewer.update((Object)element, null);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.cache.dispose();
        this.images.dispose();
    }
}

