/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.noc.noccfg.ui.wizard;

import com.st.stellar.component.API.ComponentAPI;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import com.st.stellar.noc.nocCfg.Configuration;
import com.st.stellar.noc.nocCfg.Include;
import com.st.stellar.noc.nocCfg.NocCfgFactory;
import com.st.stellar.noc.nocCfg.NocCfgPackage;
import com.st.stellar.noc.nocCfg.presentation.NocCfgEditorPlugin;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NoCConfigModelWizard
extends Wizard
implements INewWizard {
    static final Logger LOG = Logger.getLogger(NoCConfigModelWizard.class);
    protected NocCfgPackage nocCfgPackage = NocCfgPackage.eINSTANCE;
    protected NocCfgFactory nocCfgFactory = this.nocCfgPackage.getNocCfgFactory();
    protected NocCfgFileNamePage newFileCreationPage;
    protected NocCfgChooseModelPage chooseModelPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Creation of a NoC configuration");
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(NocCfgEditorPlugin.INSTANCE.getImage("full/wizban/NewNocCfg")));
    }

    protected Collection<URI> getNoCModels() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (ExtensionDescription desc : ModelProvider.getInstance().getModels("spirit")) {
            String type = (String)desc.getKeyValuePairs().get("type");
            if (!"com.st.stellar.noc.registers".equals(type)) continue;
            list.add(desc.getURI());
        }
        Collection<URI> localModels = this.getLocalModels(this.getModelFile(), Arrays.asList("spirit"));
        for (URI uri : localModels) {
            list.add(uri);
        }
        return list;
    }

    private String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        int i = lastSegment.lastIndexOf(46);
        return i < 0 ? null : lastSegment.substring(0, i);
    }

    protected EObject createInitialModel(Resource resource) {
        Configuration root = this.nocCfgFactory.createConfiguration();
        root.setName(this.fileName(resource.getURI()));
        Include inc = this.nocCfgFactory.createInclude();
        try {
            String decodedUri = URLDecoder.decode(this.chooseModelPage.getModelURI().toString(), "UTF-8");
            inc.setImportURI(decodedUri);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        root.setIncludes(inc);
        root.setOutputFolder(root.getName());
        return root;
    }

    public boolean performFinish() {
        final IFile modelFile = this.getModelFile();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                    Resource resource = resourceSet.createResource(fileURI);
                    EObject rootObject = NoCConfigModelWizard.this.createInitialModel(resource);
                    if (rootObject != null) {
                        resource.getContents().add((Object)rootObject);
                    }
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("ENCODING", "UTF-8");
                    resource.save(options);
                    ComponentAPI.refreshApplication((Resource)resource);
                }
                catch (Exception exception) {
                    LOG.error((Object)exception);
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable(){
                    final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
                return false;
            }
            URI modelUri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toOSString(), (boolean)true);
            String fileName = modelFile.getFullPath().toOSString();
            return true;
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new NocCfgFileNamePage(this, "Whatever", this.selection);
        this.newFileCreationPage.setTitle("NoC configuration");
        this.newFileCreationPage.setDescription("Create a NoC configuration model");
        this.newFileCreationPage.setFileName("conf1.noccfg");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = "conf";
                String defaultModelFilenameExtension = "noccfg";
                String modelFilename = defaultModelBaseFilename + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = defaultModelBaseFilename + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.chooseModelPage = new NocCfgChooseModelPage("Whatever2");
        this.chooseModelPage.setTitle("NoC model");
        this.chooseModelPage.setDescription("Select a NoC model");
        this.addPage((IWizardPage)this.chooseModelPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public Collection<URI> getLocalModels(IFile resource, List<String> extensions) {
        ArrayList<IResource> files = new ArrayList<IResource>();
        IFile file = resource;
        if (file == null) {
            return new ArrayList<URI>();
        }
        IProject project = file.getProject();
        ProjectVisitor visitor = new ProjectVisitor(files, extensions);
        ArrayList<URI> handles = new ArrayList<URI>();
        try {
            project.accept((IResourceProxyVisitor)visitor, 0);
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage());
            return handles;
        }
        for (IFile iFile : files) {
            try {
                String decodedUri = URLDecoder.decode(iFile.getProjectRelativePath().toOSString(), "UTF-8");
                URI uri = URI.createFileURI((String)decodedUri);
                handles.add(uri);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return handles;
    }

    public class NocCfgChooseModelPage
    extends WizardPage {
        protected Combo NocModelField;
        protected ModifyListener validator;

        public NocCfgChooseModelPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NocCfgChooseModelPage.this.setPageComplete(NocCfgChooseModelPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText("&NoC model");
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.NocModelField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.NocModelField.setLayoutData((Object)data);
            for (URI objectName : NoCConfigModelWizard.this.getNoCModels()) {
                this.NocModelField.add(objectName.toString());
            }
            this.NocModelField.addModifyListener(this.validator);
            this.NocModelField.select(0);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getModelURI() != null;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.NocModelField.getItemCount() == 1) {
                    this.NocModelField.clearSelection();
                } else {
                    this.NocModelField.setFocus();
                }
            }
        }

        public URI getModelURI() {
            URI res = null;
            String label = this.NocModelField.getText();
            for (URI name : NoCConfigModelWizard.this.getNoCModels()) {
                if (!name.toString().equals(label)) continue;
                res = name;
            }
            return res;
        }

        protected String getLabel(String typeName) {
            return typeName;
        }
    }

    public class NocCfgFileNamePage
    extends WizardNewFileCreationPage {
        public NocCfgFileNamePage(NoCConfigModelWizard this$0, String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            return super.validatePage();
        }

        public IFile getModelFile() {
            if (this.getContainerFullPath() != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
            }
            return null;
        }
    }

    static class ProjectVisitor
    implements IResourceProxyVisitor {
        List<IResource> _list;
        List<String> _extensions;

        ProjectVisitor(List<IResource> list, List<String> extensions) {
            this._list = list;
            this._extensions = extensions;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1) {
                String ext = new Path(proxy.getName()).getFileExtension();
                if (this._extensions.contains(ext)) {
                    this._list.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

