/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.noc.ui.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.st.stellar.model.lib.extension.ExtensionDescription;
import com.st.stellar.model.lib.utils.ModelProvider;
import com.st.stellar.noc.NocHelper.NocHelper;
import com.st.stellar.noc.nocCfg.Configuration;
import com.st.stellar.noc.nocCfg.FieldInstance;
import com.st.stellar.noc.nocCfg.Initiator;
import com.st.stellar.noc.nocCfg.RegisterConfig;
import com.st.stellar.noc.ui.contentassist.AbstractNocCfgProposalProvider;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AccessType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BusInterfaceType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.SlaveType;

public class NocCfgProposalProvider
extends AbstractNocCfgProposalProvider {
    @Inject
    @Extension
    private NocHelper _nocHelper;

    public Collection<URI> getNocModels(EObject model) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        List _models = ModelProvider.getInstance().getModels("spirit");
        for (ExtensionDescription desc : _models) {
            Object type = desc.getKeyValuePairs().get("type");
            boolean _equals = "com.st.stellar.noc.registers".equals(type);
            if (!_equals) continue;
            list.add(desc.getURI());
        }
        List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{"spirit"}));
        for (URI uri : _localModels) {
            list.add(uri);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    @Override
    public void completeInclude_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            List _localModels = ModelProvider.getInstance().getLocalModels(model.eResource(), (List)CollectionLiterals.newArrayList((Object[])new String[]{"spirit"}));
            for (URI uri : _localModels) {
                InputOutput.println((Object)uri.toString());
                String decodedUri = URLDecoder.decode(uri.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
            Collection<URI> _nocModels = this.getNocModels(model);
            for (URI uri_1 : _nocModels) {
                String decodedUri = URLDecoder.decode(uri_1.toString(), "UTF-8");
                acceptor.accept(this.createCompletionProposal("\"" + decodedUri + "\"", decodedUri, null, context));
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void completeInitiator_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _eContainer = model.eContainer();
        IsSlavePredicate filter = new IsSlavePredicate((Configuration)_eContainer);
        AbstractElement _terminal = assignment.getTerminal();
        this.lookupCrossReference((CrossReference)_terminal, context, acceptor, filter);
    }

    @Override
    public void complete_RegisterConfig(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        InputOutput.println((Object)model.toString());
        Initiator busInterface = (Initiator)model;
        BusInterfaceType bit = busInterface.getName();
        MemoryMapType mm = this._nocHelper.memoryMap(bit);
        if (mm != null) {
            EList _addressBlock = mm.getAddressBlock();
            for (AddressBlockType addressBlock : _addressBlock) {
                Functions.Function1 _function = it -> {
                    boolean _contains = it.getName().contains("_Reserved_");
                    return !_contains;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)addressBlock.getRegister(), (Functions.Function1)_function);
                for (RegisterType reg : _filter) {
                    String regName = this._nocHelper.addressBlockName(reg);
                    acceptor.accept(this.createCompletionProposal(regName, regName, null, context));
                }
            }
        }
    }

    @Override
    public void completeFieldInstance_Attr(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        RegisterConfig regConfig = (RegisterConfig)model;
        List registers = this._nocHelper.getRegisters(regConfig);
        EList alreadyThere = regConfig.getProperties();
        for (RegisterType reg : registers) {
            Functions.Function1 _function = it -> {
                AccessType _access = it.getAccess();
                return !Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType field : _filter) {
                String _name;
                String name;
                String alias = this._nocHelper.alias(reg);
                Functions.Function1 _function_1 = arg_0 -> NocCfgProposalProvider.lambda$completeFieldInstance_Attr$2(alias, name = alias + "." + (_name = field.getName()), arg_0);
                FieldInstance there = (FieldInstance)IterableExtensions.findFirst((Iterable)alreadyThere, (Functions.Function1)_function_1);
                if (there != null) continue;
                acceptor.accept(this.createCompletionProposal(name, name, null, context));
            }
        }
    }

    @Override
    public void completeFieldInstance_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        FieldInstance fieldInstance = (FieldInstance)model;
        FieldType attr = fieldInstance.getAttr();
        EnumeratedValuesType values = attr.getEnumeratedValues();
        EObject _eContainer = attr.eContainer();
        RegisterType reg = (RegisterType)_eContainer;
        if (reg == null || reg.getName() == null) {
            return;
        }
        boolean _contains = reg.getName().contains("QosGenerator_Mode");
        if (_contains) {
            this.completeQoS_Value(model, assignment, context, acceptor);
        } else if (values != null) {
            EList _enumeratedValue = values.getEnumeratedValue();
            for (EnumeratedValueType e : _enumeratedValue) {
                String _name = e.getName();
                String _plus = "'" + _name;
                String _plus_1 = _plus + "'";
                acceptor.accept(this.createCompletionProposal(_plus_1, e.getName(), null, context));
            }
        } else {
            int bits = attr.getBitWidth().getValue().intValue();
            if (bits == 1) {
                acceptor.accept(this.createCompletionProposal("'0x0'", "0x0", null, context));
                acceptor.accept(this.createCompletionProposal("'0x1'", "0x1", null, context));
            }
        }
    }

    public String completeQoS_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String _xtrycatchfinallyexpression = null;
        try {
            FieldInstance fieldInstance = (FieldInstance)model;
            FieldType attr = fieldInstance.getAttr();
            EObject _eContainer = fieldInstance.getAttr().eContainer();
            RegisterType reg = (RegisterType)_eContainer;
            long resetRawValue = this._nocHelper.getLongValue(this._nocHelper.defaultRawValue(reg, fieldInstance.getAttr()));
            EnumeratedValuesType values = attr.getEnumeratedValues();
            if (values != null) {
                EList _enumeratedValue = values.getEnumeratedValue();
                for (EnumeratedValueType e : _enumeratedValue) {
                    long value = this._nocHelper.getLongValue(e.getValue());
                    if (value > resetRawValue && value != 2L) continue;
                    String _name = e.getName();
                    String _plus = "'" + _name;
                    String _plus_1 = _plus + "'";
                    acceptor.accept(this.createCompletionProposal(_plus_1, e.getName(), null, context));
                }
            } else {
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, 4, true);
                for (Integer value : _doubleDotLessThan) {
                    if ((long)value.intValue() > resetRawValue && (long)value.intValue() != 2L) continue;
                    acceptor.accept(this.createCompletionProposal(value.toString(), value.toString(), null, context));
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e_1 = (Exception)_t;
                String _message = e_1.getMessage();
                String _plus = "pno:" + _message;
                _xtrycatchfinallyexpression = (String)InputOutput.println((Object)_plus);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private static /* synthetic */ Boolean lambda$completeFieldInstance_Attr$2(String alias, String name, FieldInstance it) {
        String _name_1 = it.getAttr().getName();
        return (alias + "." + _name_1).equals(name);
    }

    public static class IsSlavePredicate
    implements Predicate<IEObjectDescription> {
        private List<String> alreadyThere = CollectionLiterals.newArrayList();

        public IsSlavePredicate(Configuration config) {
            Consumer<Initiator> _function = it -> {
                boolean _tripleNotEquals;
                BusInterfaceType _name = it.getName();
                boolean bl = _tripleNotEquals = _name != null;
                if (_tripleNotEquals) {
                    this.alreadyThere.add(it.getName().getName());
                }
            };
            config.getInitiators().forEach(_function);
        }

        public boolean apply(IEObjectDescription input) {
            EObjectDescription od;
            EObject _eObjectOrProxy;
            if (input instanceof EObjectDescription && (_eObjectOrProxy = (od = (EObjectDescription)input).getEObjectOrProxy()) instanceof BusInterfaceType) {
                boolean _tripleNotEquals;
                EObject _eObjectOrProxy_1 = od.getEObjectOrProxy();
                BusInterfaceType bi = (BusInterfaceType)_eObjectOrProxy_1;
                SlaveType _slave = bi.getSlave();
                boolean bl = _tripleNotEquals = _slave != null;
                if (_tripleNotEquals) {
                    MemoryMapType mm = NocHelper.getInstance().memoryMap(bi);
                    return mm.getAddressBlock().size() > 0 && !this.alreadyThere.contains(bi.getName());
                }
                return false;
            }
            return false;
        }
    }
}

