/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.noc.NocHelper;

import com.google.inject.Inject;
import com.st.stellar.noc.nocCfg.Configuration;
import com.st.stellar.noc.nocCfg.FieldInstance;
import com.st.stellar.noc.nocCfg.Include;
import com.st.stellar.noc.nocCfg.Initiator;
import com.st.stellar.noc.nocCfg.NocCfgFactory;
import com.st.stellar.noc.nocCfg.RegisterConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe2.language.scoping.QualifiedNameProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AccessType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BusInterfaceType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BusInterfacesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ComponentType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValuesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapRefType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ResetType1;
import org.spiritconsorsium.xml.spiritmodel.Spirit.SlaveType;

public class NocHelper {
    private static final Logger logger = Logger.getLogger(NocHelper.class);
    private static final NocHelper _instance = new NocHelper();
    private static Map _resourceCache = new HashMap();
    @Inject
    private QualifiedNameProvider qnp;

    public MemoryMapType memoryMap(BusInterfaceType bi) {
        boolean _tripleEquals;
        MemoryMapType _xblockexpression = null;
        EObject _eContainer = bi.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            return null;
        }
        EObject _eContainer_1 = bi.eContainer().eContainer();
        ComponentType comp = (ComponentType)_eContainer_1;
        SlaveType slave = bi.getSlave();
        EList mmlist = comp.getMemoryMaps().getMemoryMap();
        MemoryMapRefType mmref = slave.getMemoryMapRef();
        Functions.Function1 _function = it -> it.getName().equals(mmref.getMemoryMapRef());
        _xblockexpression = (MemoryMapType)IterableExtensions.findFirst((Iterable)mmlist, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public static NocHelper getInstance() {
        return _instance;
    }

    public ArrayList<FieldInstance> getFields(RegisterConfig registerConfig, RegisterType reg) {
        ArrayList _xblockexpression = null;
        List<RegisterType> registers = this.getRegisters(registerConfig);
        ArrayList fieldInstances = CollectionLiterals.newArrayList();
        for (RegisterType r : registers) {
            boolean _equals = reg.getName().equals(r.getName());
            if (!_equals) continue;
            Functions.Function1 _function = it -> {
                AccessType _access = it.getAccess();
                return !Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable fields = IterableExtensions.filter((Iterable)r.getField(), (Functions.Function1)_function);
            EList<FieldInstance> _properties = registerConfig.getProperties();
            for (FieldInstance p : _properties) {
                for (FieldType ff : fields) {
                    List attrSegments = this.qnp.getFullyQualifiedName((EObject)p.getAttr()).getSegments();
                    int index = attrSegments.size();
                    String reg1 = (String)attrSegments.get(index - 2);
                    String reg2 = (String)IterableExtensions.lastOrNull((Iterable)this.qnp.getFullyQualifiedName((EObject)r).getSegments());
                    if (!ff.getName().equals(p.getAttr().getName()) || !reg1.equals(reg2)) continue;
                    fieldInstances.add(p);
                }
            }
        }
        _xblockexpression = fieldInstances;
        return _xblockexpression;
    }

    public ArrayList<SlaveType> getSlaves(Configuration configuration) {
        ArrayList _xblockexpression = null;
        ArrayList slaves = CollectionLiterals.newArrayList();
        Include inc = configuration.getIncludes();
        Object _get = _resourceCache.get(inc.getImportURI());
        Resource resource = (Resource)_get;
        if (resource == null) {
            Resource r;
            resource = configuration.eResource();
            resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
            _resourceCache.put(inc.getImportURI(), resource);
        }
        if (resource != null) {
            EObject _get_1 = (EObject)resource.getContents().get(0);
            DocumentRoot root = (DocumentRoot)_get_1;
            ComponentType component = root.getComponent();
            BusInterfacesType busInterfaces = component.getBusInterfaces();
            EList _busInterface = busInterfaces.getBusInterface();
            for (BusInterfaceType bi : _busInterface) {
                SlaveType slave = bi.getSlave();
                if (slave == null) continue;
                slaves.add(slave);
            }
        }
        _xblockexpression = slaves;
        return _xblockexpression;
    }

    public ArrayList<MemoryMapType> getMemoryBlocks(Configuration configuration) {
        ArrayList _xblockexpression = null;
        ArrayList memoryBlocks = CollectionLiterals.newArrayList();
        Include inc = configuration.getIncludes();
        Object _get = _resourceCache.get(inc.getImportURI());
        Resource resource = (Resource)_get;
        if (resource == null) {
            Resource r;
            resource = configuration.eResource();
            resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
            _resourceCache.put(inc.getImportURI(), resource);
        }
        if (resource != null) {
            EObject _get_1 = (EObject)resource.getContents().get(0);
            DocumentRoot root = (DocumentRoot)_get_1;
            ComponentType component = root.getComponent();
            BusInterfacesType busInterfaces = component.getBusInterfaces();
            EList _busInterface = busInterfaces.getBusInterface();
            for (BusInterfaceType bi : _busInterface) {
                SlaveType slave = bi.getSlave();
                if (slave == null) continue;
                MemoryMapType mm = this.memoryMap(bi);
                memoryBlocks.add(mm);
            }
        }
        _xblockexpression = memoryBlocks;
        return _xblockexpression;
    }

    public List<RegisterType> getRegisters(RegisterConfig registerConfig) {
        boolean _tripleNotEquals;
        ArrayList _xblockexpression = null;
        EObject _eContainer = registerConfig.eContainer();
        Initiator initiator = (Initiator)_eContainer;
        EObject _eContainer_1 = initiator.eContainer();
        Configuration conf = (Configuration)_eContainer_1;
        String _name = initiator.getName().getName();
        String _plus = _name + "_";
        String _name_1 = registerConfig.getName();
        String memoryBlockName = _plus + _name_1;
        List registers = CollectionLiterals.newArrayList();
        Include inc = conf.getIncludes();
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals) {
            Object _get_1;
            boolean _isNullOrEmpty;
            boolean _not;
            Object _get = _resourceCache.get(inc.getImportURI());
            Resource resource = (Resource)_get;
            if (resource == null) {
                Resource r;
                resource = conf.eResource();
                resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
                _resourceCache.put(inc.getImportURI(), resource);
            }
            boolean bl2 = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(resource = (Resource)(_get_1 = _resourceCache.get(inc.getImportURI()))).getContents()));
            if (_not) {
                EObject _get_2 = (EObject)resource.getContents().get(0);
                DocumentRoot root = (DocumentRoot)_get_2;
                ComponentType component = root.getComponent();
                EList _memoryMap = component.getMemoryMaps().getMemoryMap();
                for (MemoryMapType mm : _memoryMap) {
                    EList _addressBlock = mm.getAddressBlock();
                    for (AddressBlockType ab : _addressBlock) {
                        boolean _equals = ab.getName().equals(memoryBlockName);
                        if (!_equals) continue;
                        Functions.Function1 _function = it -> {
                            boolean _contains = it.getName().contains("_Reserved_");
                            return !_contains;
                        };
                        registers = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ab.getRegister(), (Functions.Function1)_function));
                    }
                }
            }
        }
        _xblockexpression = registers;
        return _xblockexpression;
    }

    public String toHex(RegisterType reg) {
        return this.toHex(reg, null);
    }

    public String toHex(RegisterType reg, RegisterConfig registerConfig) {
        long hexValue = 0L;
        Object hexValueStr = "";
        if (reg != null && reg.getReset() != null) {
            hexValueStr = reg.getReset().getValue().getValue();
            if (hexValueStr == null) {
                return "0x0";
            }
            hexValue = Long.parseLong(((String)hexValueStr).substring(2), 16);
            ArrayList<FieldInstance> regInstances = CollectionLiterals.newArrayList();
            regInstances = registerConfig != null ? this.getFields(registerConfig, reg) : CollectionLiterals.newArrayList();
            for (FieldInstance inst : regInstances) {
                FieldType field;
                String bits;
                if (inst.getAttr() == null || inst.getValue() == null || (bits = NocHelper.bits(field = inst.getAttr())) == null) continue;
                boolean _contains = bits.contains(":");
                if (_contains) {
                    boolean _notEquals;
                    String[] bitlist = bits.split(":");
                    int _length = bitlist.length;
                    boolean bl = _notEquals = _length != 2;
                    if (_notEquals) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from = Integer.parseInt(bitlist[0]);
                    int to = Integer.parseInt(bitlist[1]);
                    hexValue = this.getBitFieldValue(inst, hexValue, from, to);
                    continue;
                }
                int from_1 = Integer.parseInt(bits);
                hexValue = this.getBitFieldValue(inst, hexValue, from_1);
            }
            Functions.Function1 _function = it -> {
                AccessType _access = it.getAccess();
                return Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType roField : _filter) {
                String bits_1 = NocHelper.bits(roField);
                if (bits_1 == null) continue;
                boolean _contains_1 = bits_1.contains(":");
                if (_contains_1) {
                    boolean _notEquals_1;
                    String[] bitlist_1 = bits_1.split(":");
                    int _length_1 = bitlist_1.length;
                    boolean bl = _notEquals_1 = _length_1 != 2;
                    if (_notEquals_1) {
                        logger.error((Object)"malformed bit list");
                    }
                    int from_2 = Integer.parseInt(bitlist_1[0]);
                    int to_1 = Integer.parseInt(bitlist_1[1]);
                    hexValue = this.eraseBits(hexValue, from_2, to_1);
                    continue;
                }
                int from_3 = Integer.parseInt(bits_1);
                hexValue = this.eraseBits(hexValue, from_3);
            }
        }
        String _upperCase = Long.toHexString(hexValue).toUpperCase(Locale.ENGLISH);
        String _plus = "0x" + _upperCase;
        hexValueStr = _plus;
        return hexValueStr;
    }

    public static String bits(FieldType field) {
        String _xblockexpression = null;
        int start = field.getBitOffset().intValue();
        int _intValue = field.getBitOffset().intValue();
        int _intValue_1 = field.getBitWidth().getValue().intValue();
        int _plus = _intValue + _intValue_1;
        int end = _plus - 1;
        Object res = "";
        if (end == start) {
            res = String.valueOf(31 - start);
        } else {
            String _valueOf = String.valueOf(31 - end);
            String _plus_1 = _valueOf + ":";
            String _valueOf_1 = String.valueOf(31 - start);
            String _plus_2 = _plus_1 + _valueOf_1;
            res = _plus_2;
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public long getBitFieldValue(FieldInstance inst, long hexInput, int from, int to) {
        long _xblockexpression = 0L;
        FieldType field = inst.getAttr();
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return 0L;
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = inst.getValue();
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = this.getLongValue(inst.getValue());
                if (valueLong < 0L) {
                    String nameStr = inst.getValue().replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        String enumVal = it.getValue().replaceAll("'", "").replaceAll("\"", "");
                        enumVal.equals(valueStr);
                        long enumvalue = this.getLongValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                if (enumDisplay == null) {
                    hexValue = 0L;
                    _xifexpression_2 = 0L;
                } else {
                    long _xblockexpression_3 = 0L;
                    long longValue = this.getLongValue(enumDisplay.getValue());
                    long _xifexpression_3 = 0L;
                    if (longValue > 0L && !Objects.equals(field.getAccess(), AccessType.READ_ONLY)) {
                        long _xblockexpression_4 = 0L;
                        long valmask = longValue << 31 - to;
                        _xifexpression_3 = _xblockexpression_4 = (hexValue |= valmask);
                    } else {
                        hexValue = 0L;
                        _xifexpression_3 = 0L;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long _xblockexpression_2 = 0L;
            long longValue = this.getLongValue(inst.getValue());
            AccessType _access = field.getAccess();
            boolean _equals = Objects.equals(_access, AccessType.READ_ONLY);
            if (_equals) {
                longValue = 0L;
            }
            long valmask = longValue << 31 - to;
            longValue = mask & valmask;
            _xifexpression = _xblockexpression_2 = (hexValue |= valmask);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public long eraseBits(long hexInput, int from, int to) {
        long _xblockexpression = 0L;
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return 0L;
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        _xblockexpression = hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        return _xblockexpression;
    }

    public String getDefaultBitFieldValue(FieldType field, long defaultValue, int from) {
        String hexValueStr;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        NocHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        long mask = 1L << 31 - from;
        NocHelper.binaryFormat(hexValue &= mask, "value");
        NocHelper.binaryFormat(hexValue >>= 31 - from, "value");
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            long compval = hexValue;
            Functions.Function1 _function = it -> {
                long _longValue = this.getLongValue(it.getValue());
                return _longValue == compval;
            };
            String enumName = ((EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function)).getName();
            return enumName;
        }
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public String getDefaultBitFieldValue(FieldType field, long defaultValue, int from, int to) {
        String hexValueStr;
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        NocHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return "";
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        NocHelper.binaryFormat(mask, "mask ");
        NocHelper.binaryFormat(hexValue &= mask, "value");
        NocHelper.binaryFormat(hexValue >>= 31 - to, "value");
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            long compval = hexValue;
            Functions.Function1 _function = it -> {
                long _longValue = this.getLongValue(it.getValue());
                return _longValue == compval;
            };
            String enumName = ((EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function)).getName();
            return enumName;
        }
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public String getDefaultBitFieldRawValue(FieldType field, long defaultValue, int from) {
        String hexValueStr;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        NocHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        long mask = 1L << 31 - from;
        NocHelper.binaryFormat(hexValue &= mask, "value");
        NocHelper.binaryFormat(hexValue >>= 31 - from, "value");
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public String getDefaultBitFieldRawValue(FieldType field, long defaultValue, int from, int to) {
        String hexValueStr;
        String _xblockexpression = null;
        long hexValue = defaultValue;
        NocHelper.binaryFormat(hexValue, "value");
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (to >= 32 || to < 0) {
            logger.error((Object)"bit out of range");
            return "";
        }
        if (from >= to) {
            logger.error((Object)"malformed bit list");
            return "";
        }
        long mask = 1L << 31 - from;
        for (int i = from + 1; i <= to; ++i) {
            mask |= 1L << 31 - i;
        }
        NocHelper.binaryFormat(mask, "mask ");
        NocHelper.binaryFormat(hexValue &= mask, "value");
        NocHelper.binaryFormat(hexValue >>= 31 - to, "value");
        String _hexString = Long.toHexString(hexValue);
        _xblockexpression = hexValueStr = "0x" + _hexString;
        return _xblockexpression;
    }

    public static void binaryFormat(long value, String label) {
        String _replace = String.format("%64s", Long.toBinaryString(value)).replace(" ", "0");
        String _plus = label + ": 0b" + _replace;
        logger.debug((Object)_plus);
    }

    public long getLongValue(String valueIn) {
        long _xblockexpression = 0L;
        if (valueIn == null) {
            return 0L;
        }
        long longValue = 0L;
        String value = valueIn;
        try {
            boolean _startsWith = value.startsWith("\"");
            if (_startsWith) {
                value = value.replaceAll("\"", "");
            } else {
                boolean _startsWith_1 = value.startsWith("'");
                if (_startsWith_1) {
                    value = value.replaceAll("'", "");
                }
            }
            boolean _startsWith_2 = value.startsWith("0x");
            longValue = _startsWith_2 ? Long.parseLong(value.substring(2), 16) : Long.parseLong(value);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                longValue = -1L;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = longValue;
        return _xblockexpression;
    }

    public String alias(RegisterType reg) {
        String res;
        String _xblockexpression = null;
        EObject _eContainer = reg.eContainer();
        AddressBlockType addressBlock = (AddressBlockType)_eContainer;
        EObject _eContainer_1 = addressBlock.eContainer();
        MemoryMapType memoryMap = (MemoryMapType)_eContainer_1;
        String memoryMapName = memoryMap.getName().replaceAll("MemoryMap_", "");
        String adbname = addressBlock.getName();
        adbname = adbname.replaceFirst(memoryMapName + "_", "");
        _xblockexpression = res = reg.getName().replaceFirst(adbname + "_", "");
        return _xblockexpression;
    }

    public String addressBlockName(RegisterType reg) {
        String _xblockexpression = null;
        EObject _eContainer = reg.eContainer();
        AddressBlockType addressBlock = (AddressBlockType)_eContainer;
        EObject _eContainer_1 = addressBlock.eContainer();
        MemoryMapType memoryMap = (MemoryMapType)_eContainer_1;
        String memoryMapName = memoryMap.getName().replaceAll("MemoryMap_", "");
        String adbname = addressBlock.getName();
        _xblockexpression = adbname = adbname.replaceFirst(memoryMapName + "_", "");
        return _xblockexpression;
    }

    public boolean allReadOnly(RegisterType reg) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> {
            AccessType _access = it.getAccess();
            return !Objects.equals(_access, AccessType.READ_ONLY);
        };
        Iterable fields = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)fields);
        _xblockexpression = _size == 0;
        return _xblockexpression;
    }

    public long getBitFieldValue(FieldInstance inst, long hexInput, int from) {
        long _xblockexpression = 0L;
        FieldType field = inst.getAttr();
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        long mask = 1L << 31 - from;
        hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        long _xifexpression = 0L;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            long _xblockexpression_1 = 0L;
            String valueStr = inst.getValue();
            long _xifexpression_1 = 0L;
            if (valueStr != null) {
                long _xblockexpression_2 = 0L;
                EnumeratedValueType enumDisplay = null;
                long valueLong = this.getLongValue(inst.getValue());
                if (valueLong < 0L) {
                    String nameStr = inst.getValue().replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_3 = false;
                        String enumVal = it.getValue().replaceAll("'", "").replaceAll("\"", "");
                        enumVal.equals(valueStr);
                        long enumvalue = this.getLongValue(it.getValue());
                        _xblockexpression_3 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_3;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                long _xifexpression_2 = 0L;
                if (enumDisplay == null) {
                    hexValue = 0L;
                    _xifexpression_2 = 0L;
                } else {
                    long _xblockexpression_3 = 0L;
                    long longValue = this.getLongValue(enumDisplay.getValue());
                    long _xifexpression_3 = 0L;
                    if (longValue > 0L && !Objects.equals(field.getAccess(), AccessType.READ_ONLY)) {
                        long hexValueRes;
                        long _xblockexpression_4 = 0L;
                        long valmask = longValue << 31 - from;
                        _xifexpression_3 = _xblockexpression_4 = (hexValue = (hexValueRes = hexValue | valmask));
                    } else {
                        hexValue = 0L;
                        _xifexpression_3 = 0L;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            } else {
                hexValue = 0L;
                _xifexpression_1 = 0L;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            long hexValueRes;
            long _xblockexpression_2 = 0L;
            long longValue = this.getLongValue(inst.getValue());
            long valmask = longValue << 31 - from;
            longValue = mask & valmask;
            _xifexpression = _xblockexpression_2 = (hexValueRes = hexValue | valmask);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public long eraseBits(long hexInput, int from) {
        long _xblockexpression = 0L;
        long hexValue = hexInput;
        if (from >= 32 || from < 0) {
            logger.error((Object)"bit out of range");
            return 0L;
        }
        long mask = 1L << 31 - from;
        _xblockexpression = hexValue &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        return _xblockexpression;
    }

    public String getAddress(RegisterType reg) {
        EObject _eContainer = reg.eContainer();
        AddressBlockType ab = (AddressBlockType)_eContainer;
        if (ab == null) {
            return "";
        }
        long _parseLong = Long.parseLong(ab.getBaseAddress().getValue().substring(2), 16);
        long _parseLong_1 = Long.parseLong(reg.getAddressOffset().substring(2), 16);
        long address = _parseLong + _parseLong_1;
        String _upperCase = String.format("%8s", Long.toHexString(address)).replace(" ", "0").toUpperCase(Locale.ENGLISH);
        return "0x" + _upperCase;
    }

    public String getValues(RegisterType reg, List<FieldInstance> fields) {
        String _xblockexpression = null;
        Object fieldStr = "";
        for (FieldInstance field : fields) {
            boolean _equals;
            String regName = this.alias(reg);
            String _name = field.getAttr().getName();
            String attr = regName + "." + _name;
            String fieldValue = field.getValue();
            fieldValue = this.valueAsString(field.getAttr(), field.getValue());
            int _length = ((String)fieldStr).length();
            boolean bl = _equals = _length == 0;
            if (_equals) {
                String _fieldStr = fieldStr;
                fieldStr = _fieldStr + attr + " -> " + fieldValue;
                continue;
            }
            String _fieldStr_1 = fieldStr;
            fieldStr = _fieldStr_1 + ", " + attr + " -> " + fieldValue;
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String valueAsString(FieldType field, String value) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        if (value == null) {
            return "";
        }
        String fieldValue = value;
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            EnumeratedValueType enumDisplay = null;
            long valueLong = this.getLongValue(value);
            if (valueLong < 0L) {
                String nameStr = value.replaceAll("'", "").replaceAll("\"", "");
                Functions.Function1 _function = it -> it.getName().equals(nameStr);
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            } else {
                Functions.Function1 _function_1 = it -> {
                    boolean _xblockexpression_1 = false;
                    long enumvalue = this.getLongValue(it.getValue());
                    _xblockexpression_1 = Long.valueOf(enumvalue).equals(valueLong);
                    return _xblockexpression_1;
                };
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
            }
            if (enumDisplay != null) {
                fieldValue = enumDisplay.getName();
            }
        }
        _xblockexpression = fieldValue;
        return _xblockexpression;
    }

    public long valueAsLong(FieldType field, String value) {
        boolean _tripleNotEquals;
        long _xblockexpression = 0L;
        long fieldValue = -1L;
        EnumeratedValuesType _enumeratedValues = field.getEnumeratedValues();
        boolean bl = _tripleNotEquals = _enumeratedValues != null;
        if (_tripleNotEquals) {
            EnumeratedValueType enumDisplay = null;
            long valueLong = this.getLongValue(value);
            if (valueLong < 0L) {
                String nameStr = value.replaceAll("'", "").replaceAll("\"", "");
                Functions.Function1 _function = it -> it.getName().equals(nameStr);
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            } else {
                Functions.Function1 _function_1 = it -> {
                    boolean _xblockexpression_1 = false;
                    long enumvalue = this.getLongValue(it.getValue());
                    _xblockexpression_1 = Long.valueOf(enumvalue).equals(valueLong);
                    return _xblockexpression_1;
                };
                enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
            }
            if (enumDisplay != null) {
                fieldValue = this.getLongValue(enumDisplay.getValue());
            }
        } else {
            fieldValue = this.getLongValue(value);
        }
        _xblockexpression = fieldValue;
        return _xblockexpression;
    }

    public String defaultValue(RegisterType reg, FieldType field) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        String hexValueStr = "";
        String bits = NocHelper.bits(field);
        long resetValue = 0L;
        ResetType1 _reset = reg.getReset();
        boolean bl = _tripleNotEquals = _reset != null;
        if (_tripleNotEquals) {
            resetValue = Long.parseLong(reg.getReset().getValue().getValue().substring(2), 16);
        }
        if (bits != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl2 = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from, to);
            } else {
                int from_1 = Integer.parseInt(bits);
                hexValueStr = this.getDefaultBitFieldValue(field, resetValue, from_1);
            }
        }
        _xblockexpression = hexValueStr;
        return _xblockexpression;
    }

    public long rawValue(FieldInstance field) {
        long _xblockexpression = 0L;
        long hexValue = -1L;
        if (field.getAttr().getEnumeratedValues() != null && !field.getAttr().getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            String valueStr = field.getValue();
            if (valueStr != null) {
                long longValue;
                EnumeratedValueType enumDisplay = null;
                long valueLong = this.getLongValue(field.getValue());
                if (valueLong < 0L) {
                    String nameStr = field.getValue().replaceAll("'", "").replaceAll("\"", "");
                    Functions.Function1 _function = it -> it.getName().equals(nameStr);
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getAttr().getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
                } else {
                    Functions.Function1 _function_1 = it -> {
                        boolean _xblockexpression_1 = false;
                        String enumVal = it.getValue().replaceAll("'", "").replaceAll("\"", "");
                        enumVal.equals(valueStr);
                        long enumvalue = this.getLongValue(it.getValue());
                        _xblockexpression_1 = Long.valueOf(enumvalue).equals(valueLong);
                        return _xblockexpression_1;
                    };
                    enumDisplay = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)field.getAttr().getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function_1);
                }
                hexValue = enumDisplay == null ? -1L : ((longValue = this.getLongValue(enumDisplay.getValue())) >= 0L && !Objects.equals(field.getAttr().getAccess(), AccessType.READ_ONLY) ? longValue : -1L);
            } else {
                EObject _eContainer = field.getAttr().eContainer();
                RegisterType reg = (RegisterType)_eContainer;
                hexValue = this.getLongValue(this.defaultRawValue(reg, field.getAttr()));
            }
        } else {
            boolean _tripleNotEquals;
            String _value = field.getValue();
            boolean bl = _tripleNotEquals = _value != null;
            if (_tripleNotEquals) {
                hexValue = this.getLongValue(field.getValue());
            } else {
                EObject _eContainer_1 = field.getAttr().eContainer();
                RegisterType reg_1 = (RegisterType)_eContainer_1;
                hexValue = this.getLongValue(this.defaultRawValue(reg_1, field.getAttr()));
            }
        }
        _xblockexpression = hexValue;
        return _xblockexpression;
    }

    public String defaultRawValue(RegisterType reg, FieldType field) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        String hexValueStr = "";
        String bits = NocHelper.bits(field);
        long resetValue = 0L;
        ResetType1 _reset = reg.getReset();
        boolean bl = _tripleNotEquals = _reset != null;
        if (_tripleNotEquals) {
            resetValue = Long.parseLong(reg.getReset().getValue().getValue().substring(2), 16);
        }
        if (bits != null) {
            boolean _contains = bits.contains(":");
            if (_contains) {
                boolean _notEquals;
                String[] bitlist = bits.split(":");
                int _length = bitlist.length;
                boolean bl2 = _notEquals = _length != 2;
                if (_notEquals) {
                    logger.error((Object)"malformed bit list");
                }
                int from = Integer.parseInt(bitlist[0]);
                int to = Integer.parseInt(bitlist[1]);
                hexValueStr = this.getDefaultBitFieldRawValue(field, resetValue, from, to);
            } else {
                int from_1 = Integer.parseInt(bits);
                hexValueStr = this.getDefaultBitFieldRawValue(field, resetValue, from_1);
            }
        }
        _xblockexpression = hexValueStr;
        return _xblockexpression;
    }

    public String getValues(RegisterType reg) {
        String _xblockexpression = null;
        Object fieldStr = "";
        String regName = this.alias(reg);
        Functions.Function1 _function = it -> {
            AccessType _access = it.getAccess();
            return !Objects.equals(_access, AccessType.READ_ONLY);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
        for (FieldType field : _filter) {
            boolean _equals;
            String _name = field.getName();
            String attr = regName + "." + _name;
            String value = this.defaultValue(reg, field);
            int _length = ((String)fieldStr).length();
            boolean bl = _equals = _length == 0;
            if (_equals) {
                String _fieldStr = fieldStr;
                fieldStr = _fieldStr + attr + " -> " + value;
                continue;
            }
            String _fieldStr_1 = fieldStr;
            fieldStr = _fieldStr_1 + ", " + attr + " -> " + value;
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String getRegisterConfigName(FieldInstance field) {
        String memoryBlock;
        String _xblockexpression = null;
        EObject _eContainer = field.eContainer();
        RegisterConfig registerConfig = (RegisterConfig)_eContainer;
        EObject _eContainer_1 = registerConfig.eContainer();
        Initiator initiator = (Initiator)_eContainer_1;
        String _plus = String.valueOf(initiator) + "_";
        _xblockexpression = memoryBlock = _plus + String.valueOf(registerConfig);
        return _xblockexpression;
    }

    public String getFieldInstanceName(FieldInstance field) {
        String _xblockexpression = null;
        EObject _eContainer = field.eContainer();
        RegisterConfig registerConfig = (RegisterConfig)_eContainer;
        EObject _eContainer_1 = registerConfig.eContainer();
        Initiator initiator = (Initiator)_eContainer_1;
        String _plus = String.valueOf(initiator) + "_";
        String memoryBlock = _plus + String.valueOf(registerConfig);
        FieldType _attr = field.getAttr();
        _xblockexpression = memoryBlock + "_" + String.valueOf(_attr);
        return _xblockexpression;
    }

    public void createFieldInstances(RegisterConfig config) {
        List<RegisterType> _registers = this.getRegisters(config);
        for (RegisterType reg : _registers) {
            Functions.Function1 _function = it -> {
                AccessType _access = it.getAccess();
                return !Objects.equals(_access, AccessType.READ_ONLY);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)reg.getField(), (Functions.Function1)_function);
            for (FieldType field : _filter) {
                boolean _lessThan;
                Functions.Function1 _function_1 = it -> it.getAttr() != null && it.getAttr().getName() != null && it.getAttr().getName().equals(field.getName());
                FieldInstance regInst = (FieldInstance)IterableExtensions.findFirst(config.getProperties(), (Functions.Function1)_function_1);
                if (regInst != null) continue;
                Object value = this.defaultValue(reg, field);
                long _longValue = this.getLongValue((String)value);
                boolean bl = _lessThan = _longValue < 1L;
                if (_lessThan) {
                    value = "'" + (String)value + "'";
                }
                FieldInstance fieldInst = NocCfgFactory.eINSTANCE.createFieldInstance();
                fieldInst.setAttr(field);
                fieldInst.setValue((String)value);
                config.getProperties().add((Object)fieldInst);
            }
        }
    }
}

