/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.noc.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.noc.NocHelper.NocHelper;
import com.st.stellar.noc.nocCfg.Configuration;
import com.st.stellar.noc.nocCfg.FieldInstance;
import com.st.stellar.noc.nocCfg.Initiator;
import com.st.stellar.noc.nocCfg.RegisterConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class NocCfgGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;
    @Inject
    @Extension
    private NocHelper _nocHelper;
    @Inject
    private IOutputConfigurationProvider outputCfgProvider;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            boolean _tripleNotEquals;
            ResourceSet resourceSet = (ResourceSet)this.rsp.get();
            Resource r = resourceSet.getResource(resource.getURI(), true);
            boolean _isEmpty = r.getContents().isEmpty();
            if (_isEmpty) {
                return;
            }
            EObject _head = (EObject)IterableExtensions.head((Iterable)r.getContents());
            Configuration configuration = (Configuration)_head;
            boolean generateReset = context.getCancelIndicator().getClass().getName().contains("GenerateResetCancelIndicator");
            Object outputFolder = "";
            String _outputFolder = configuration.getOutputFolder();
            boolean bl = _tripleNotEquals = _outputFolder != null;
            if (_tripleNotEquals) {
                String _outputFolder_1 = configuration.getOutputFolder();
                String _plus = _outputFolder_1 + "/";
                outputFolder = _plus;
                outputFolder = "../" + (String)outputFolder;
            } else {
                String _outputDirectory = ((OutputConfiguration)IterableExtensions.toList((Iterable)this.outputCfgProvider.getOutputConfigurations()).get(0)).getOutputDirectory();
                String _plus_1 = _outputDirectory + "/";
                outputFolder = _plus_1;
                outputFolder = "../" + (String)outputFolder;
            }
            if (generateReset) {
                String resetValues = this.generateResetValues(configuration);
                IFile fileName = this.getGeneratedFile(resource, configuration.getName(), "_resetValues.c");
                URI resetFileUri = fsa.getURI(fileName.getFullPath().toString(), "DEFAULT_OUTPUT");
                IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                String _platformString = resetFileUri.toPlatformString(true);
                Path _path = new Path(_platformString);
                IFile file = _root.getFile((IPath)_path);
                this.generateResetValues(file, resetValues);
            } else {
                String bootbody = this.generateRegisterConfigurationBody(configuration);
                String _name = configuration.getName();
                String _plus_2 = (String)outputFolder + _name;
                String _plus_3 = _plus_2 + ".c";
                fsa.generateFile(_plus_3, (CharSequence)bootbody);
                String bootheader = this.generateRegisterConfigurationHeader(configuration);
                String _name_1 = configuration.getName();
                String _plus_4 = (String)outputFolder + _name_1;
                String _plus_5 = _plus_4 + ".h";
                fsa.generateFile(_plus_5, (CharSequence)bootheader);
            }
            try {
                IWorkspaceRoot _root_1 = ResourcesPlugin.getWorkspace().getRoot();
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                _root_1.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (!(_t instanceof IllegalStateException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private CharSequence copyright() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2021-2026 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* EVALUATION ONLY - NOT FOR USE IN PRODUCTION");
        _builder.newLine();
        _builder.append("****************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public String generateRegisterConfigurationHeader(Configuration configuration) {
        String headerStr;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this.copyright();
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _NOC_");
        String _upperCase = configuration.getName().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _NOC_");
        String _upperCase_1 = configuration.getName().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase_1);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("extern void ");
        String _name = configuration.getName();
        _builder.append(_name);
        _builder.append("_global_noc();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* _NOC_");
        String _upperCase_2 = configuration.getName().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase_2);
        _builder.append("_H_ */");
        _builder.newLineIfNotEmpty();
        _xblockexpression = headerStr = _builder.toString();
        return _xblockexpression;
    }

    public void createRecursive(IContainer resource) {
        boolean _not;
        boolean _exists = resource.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            boolean _not_1;
            boolean _exists_1 = resource.getParent().exists();
            boolean bl2 = _not_1 = !_exists_1;
            if (_not_1) {
                this.createRecursive(resource.getParent());
            }
            if (resource instanceof IFolder) {
                try {
                    NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                    ((IFolder)resource).create(false, true, (IProgressMonitor)_nullProgressMonitor);
                }
                catch (Throwable _t) {
                    if (_t instanceof CoreException) {
                        CoreException e = (CoreException)_t;
                        CodeGenEcorePlugin.INSTANCE.log((Object)e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    public IFile getGeneratedFile(Resource resource, String folderStr, String ext) {
        try {
            IFile _xblockexpression = null;
            List segments = resource.getURI().segmentsList();
            int segCount = resource.getURI().segmentCount();
            String destFileName = ((String)segments.get(segCount - 1)).replaceAll(".noccfg", ext);
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            IFile _xifexpression = null;
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                IFile _xblockexpression_1 = null;
                StringBuffer platformResourcePath = new StringBuffer();
                int size = uri.segmentCount();
                IFile _xifexpression_1 = null;
                if (size > 3) {
                    IFile file;
                    IFile _xblockexpression_2 = null;
                    for (int j = 2; j < size - 1; ++j) {
                        platformResourcePath.append("/");
                        platformResourcePath.append(uri.segment(j));
                    }
                    platformResourcePath.append("/");
                    platformResourcePath.append(destFileName);
                    IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                    String _string = platformResourcePath.toString();
                    Path _path = new Path(_string);
                    _xifexpression_1 = _xblockexpression_2 = (file = _root.getFile((IPath)_path));
                } else {
                    IFile file;
                    boolean _not;
                    IFile _xblockexpression_3 = null;
                    platformResourcePath.append("/");
                    platformResourcePath.append(uri.segment(1));
                    platformResourcePath.append("/");
                    platformResourcePath.append("./");
                    platformResourcePath.append(folderStr);
                    platformResourcePath.append("/");
                    IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                    String _string = platformResourcePath.toString();
                    Path _path = new Path(_string);
                    IFolder folder = _root.getFolder((IPath)_path);
                    boolean _exists = folder.exists();
                    boolean bl = _not = !_exists;
                    if (_not) {
                        folder.create(true, true, null);
                    }
                    platformResourcePath.append(destFileName);
                    String _string2 = platformResourcePath.toString();
                    String _segment = uri.segment(1);
                    String _plus = "/" + _segment;
                    String filename = _string2.replaceAll(_plus, "");
                    IWorkspaceRoot _root2 = ResourcesPlugin.getWorkspace().getRoot();
                    Path _path2 = new Path(filename);
                    _xifexpression_1 = _xblockexpression_3 = (file = _root2.getFile((IPath)_path2));
                }
                _xifexpression = _xblockexpression_1 = _xifexpression_1;
            } else {
                _xifexpression = null;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateResetValues(IFile filename, String resetValues) {
        try {
            String _xtrycatchfinallyexpression = null;
            try {
                boolean _not;
                File file = filename.getRawLocation().makeAbsolute().toFile();
                boolean _exists = file.exists();
                boolean bl = _not = !_exists;
                if (_not) {
                    try {
                        file.createNewFile();
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IOException) {
                            IOException e = (IOException)_t;
                            InputOutput.println((Object)e.getMessage());
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                FileOutputStream fileOut = new FileOutputStream(file);
                fileOut.write(resetValues.getBytes());
                fileOut.close();
            }
            catch (Throwable _t) {
                if (_t instanceof FileNotFoundException) {
                    FileNotFoundException e = (FileNotFoundException)_t;
                    _xtrycatchfinallyexpression = (String)InputOutput.println((Object)e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return _xtrycatchfinallyexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateRegisterConfigurationBody(Configuration configuration) {
        boolean _greaterThan;
        String _xblockexpression = null;
        ArrayList functionList = CollectionLiterals.newArrayList();
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this.copyright();
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("typedef unsigned long uint32;");
        _builder.newLine();
        _builder.append("#define REG_WRITE32(address, value)       ((*(volatile uint32*)(address))= (uint32)(value))");
        _builder.newLine();
        Object fieldStr = _builder.toString();
        EList<Initiator> _initiators = configuration.getInitiators();
        for (Initiator bi : _initiators) {
            EList<RegisterConfig> _configs = bi.getConfigs();
            for (RegisterConfig config : _configs) {
                List<RegisterType> registers = this._nocHelper.getRegisters(config);
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name = configuration.getName();
                _builder_1.append(_name);
                _builder_1.append("_");
                String _name_1 = config.getName();
                _builder_1.append(_name_1);
                _builder_1.append("()");
                functionList.add(_builder_1.toString());
                Object _fieldStr = fieldStr;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.newLine();
                Object _fieldStr_1 = fieldStr = (String)_fieldStr + String.valueOf(_builder_2);
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("void ");
                String _name_2 = configuration.getName();
                _builder_3.append(_name_2);
                _builder_3.append("_");
                String _name_3 = config.getName();
                _builder_3.append(_name_3);
                _builder_3.append("() { /* ");
                String _name_4 = bi.getName().getName();
                _builder_3.append(_name_4);
                _builder_3.append(" */");
                _builder_3.newLineIfNotEmpty();
                fieldStr = (String)_fieldStr_1 + String.valueOf(_builder_3);
                for (RegisterType reg : registers) {
                    ArrayList<FieldInstance> fields = this._nocHelper.getFields(config, reg);
                    int _size = fields.size();
                    boolean _greaterThan2 = _size > 0;
                    if (!_greaterThan2) continue;
                    Object _fieldStr_2 = fieldStr;
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("\t");
                    _builder_4.append("REG_WRITE32(");
                    String _address = this._nocHelper.getAddress(reg);
                    _builder_4.append(_address, "\t");
                    _builder_4.append(", ");
                    String _hex = this._nocHelper.toHex(reg, config);
                    _builder_4.append(_hex, "\t");
                    _builder_4.append("); /* ");
                    String _values = this._nocHelper.getValues(reg, fields);
                    _builder_4.append(_values, "\t");
                    _builder_4.append(" */");
                    _builder_4.newLineIfNotEmpty();
                    fieldStr = (String)_fieldStr_2 + String.valueOf(_builder_4);
                }
                Object _fieldStr_2 = fieldStr;
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("} /* End of ");
                String _name_5 = configuration.getName();
                _builder_4.append(_name_5);
                _builder_4.append("_");
                String _name_6 = config.getName();
                _builder_4.append(_name_6);
                _builder_4.append(" */");
                _builder_4.newLineIfNotEmpty();
                fieldStr = (String)_fieldStr_2 + String.valueOf(_builder_4);
            }
        }
        int _size = functionList.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _fieldStr = fieldStr;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.newLine();
            _builder_1.append("/* Global init function for ");
            String _name = configuration.getName();
            _builder_1.append(_name);
            _builder_1.append(" */");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("void ");
            String _name_1 = configuration.getName();
            _builder_1.append(_name_1);
            _builder_1.append("_global_noc() {");
            _builder_1.newLineIfNotEmpty();
            fieldStr = _fieldStr + String.valueOf(_builder_1);
            for (String f : functionList) {
                Object _fieldStr_1 = fieldStr;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("\t");
                _builder_2.append(f, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
                fieldStr = (String)_fieldStr_1 + String.valueOf(_builder_2);
            }
            Object _fieldStr_2 = fieldStr;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("}");
            fieldStr = (String)_fieldStr_2 + String.valueOf(_builder_3);
        }
        String _fieldStr_3 = fieldStr;
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.newLine();
        fieldStr = _fieldStr_3 + String.valueOf(_builder_4);
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String generateResetValues(Configuration configuration) {
        String fieldStr;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef unsigned long uint32;");
        _builder.newLine();
        _builder.append("#define REG_WRITE32(address, value)       ((*(volatile uint32*)(address))= (uint32)(value))");
        _builder.newLine();
        _builder.newLine();
        String _generateInitiators = this.generateInitiators(configuration);
        _builder.append(_generateInitiators);
        _builder.newLineIfNotEmpty();
        _xblockexpression = fieldStr = _builder.toString();
        return _xblockexpression;
    }

    public String generateInitiators(Configuration configuration) {
        String _xblockexpression = null;
        String blockName = "";
        Object fieldStr = "\n";
        Functions.Function1 _function = it -> {
            int _size = it.getAddressBlock().size();
            return _size > 0;
        };
        MemoryMapType mm = (MemoryMapType)IterableExtensions.findFirst(this._nocHelper.getMemoryBlocks(configuration), (Functions.Function1)_function);
        HashMap initiators = CollectionLiterals.newHashMap();
        Functions.Function1 _function_1 = it -> {
            boolean _isEmpty = it.getRegister().isEmpty();
            return !_isEmpty;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)mm.getAddressBlock(), (Functions.Function1)_function_1);
        for (AddressBlockType ab : _filter) {
            InputOutput.println((Object)ab.getName());
            blockName = this._nocHelper.defaultValue((RegisterType)ab.getRegister().get(0), (FieldType)((RegisterType)ab.getRegister().get(0)).getField().get(0));
            InputOutput.println((Object)blockName);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/*");
            String _addressBlockName = this._nocHelper.addressBlockName((RegisterType)ab.getRegister().get(0));
            _builder.append(_addressBlockName);
            _builder.append("*/");
            _builder.newLineIfNotEmpty();
            Object field = _builder.toString();
            Functions.Function1 _function_2 = it -> {
                boolean _contains = it.getName().contains("_Reserved_");
                return !_contains;
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)ab.getRegister(), (Functions.Function1)_function_2);
            Iterator iterator = _filter_1.iterator();
            while (iterator.hasNext()) {
                RegisterType reg = (RegisterType)iterator.next();
                String _field = field;
                String _generateRegister = this.generateRegister(reg);
                field = _field + _generateRegister;
            }
            ArrayList fieldStrList = (ArrayList)initiators.get(blockName);
            if (fieldStrList == null) {
                fieldStrList = CollectionLiterals.newArrayList();
                initiators.put(blockName, fieldStrList);
            }
            fieldStrList.add(field);
        }
        List _sort = IterableExtensions.sort(initiators.keySet());
        for (String block : _sort) {
            String _fieldStr = fieldStr;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("void reset_");
            _builder.append(block);
            _builder.append("(){");
            _builder.newLineIfNotEmpty();
            fieldStr = _fieldStr + String.valueOf(_builder);
            ArrayList field = (ArrayList)initiators.get(block);
            for (String f : field) {
                Object _fieldStr_1 = fieldStr;
                fieldStr = (String)_fieldStr_1 + f;
            }
            Object _fieldStr_2 = fieldStr;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("} /* End of ");
            _builder_1.append(block);
            _builder_1.append("_Reset_function() */");
            _builder_1.newLineIfNotEmpty();
            _builder_1.newLine();
            fieldStr = (String)_fieldStr_2 + String.valueOf(_builder_1);
        }
        _xblockexpression = fieldStr;
        return _xblockexpression;
    }

    public String generateRegister(RegisterType reg) {
        boolean _not;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        Object memoryBlockStr = _builder.toString();
        boolean _allReadOnly = this._nocHelper.allReadOnly(reg);
        boolean bl = _not = !_allReadOnly;
        if (_not) {
            String _memoryBlockStr = memoryBlockStr;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("    ");
            _builder_1.append("REG_WRITE32(");
            String _address = this._nocHelper.getAddress(reg);
            _builder_1.append(_address, "    ");
            _builder_1.append(", ");
            String _hex = this._nocHelper.toHex(reg);
            _builder_1.append(_hex, "    ");
            _builder_1.append("); /* ");
            String _values = this._nocHelper.getValues(reg);
            _builder_1.append(_values, "    ");
            _builder_1.append(" */");
            _builder_1.newLineIfNotEmpty();
            memoryBlockStr = _memoryBlockStr + String.valueOf(_builder_1);
        }
        _xblockexpression = memoryBlockStr;
        return _xblockexpression;
    }
}

