/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.noc.scoping;

import com.google.inject.Inject;
import com.st.stellar.noc.NocHelper.NocHelper;
import com.st.stellar.noc.nocCfg.Configuration;
import com.st.stellar.noc.nocCfg.FieldInstance;
import com.st.stellar.noc.nocCfg.Include;
import com.st.stellar.noc.nocCfg.Initiator;
import com.st.stellar.noc.nocCfg.NocCfgPackage;
import com.st.stellar.noc.nocCfg.RegisterConfig;
import com.st.stellar.noc.scoping.AbstractNocCfgScopeProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AccessType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BusInterfaceType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BusInterfacesType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ComponentType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.SlaveType;

public class NocCfgScopeProvider
extends AbstractNocCfgScopeProvider {
    private static final Logger log = Logger.getLogger(NocCfgScopeProvider.class);
    @Inject
    @Extension
    private NocHelper _nocHelper;
    private static Map<String, Resource> _resourceCache = new HashMap<String, Resource>();

    public IScope getScope(EObject context, EReference reference) {
        if (Objects.equals(reference, NocCfgPackage.Literals.INITIATOR__NAME) && context instanceof Initiator) {
            return this.getScopeProjectIncludes((Initiator)context, reference);
        }
        if (Objects.equals(reference, NocCfgPackage.Literals.FIELD_INSTANCE__ATTR) && context instanceof FieldInstance) {
            EObject _eContainer = context.eContainer();
            RegisterConfig config = (RegisterConfig)_eContainer;
            return this.getScopeForAttr(config, reference);
        }
        return super.getScope(context, reference);
    }

    public IScope getScopeForAttr(RegisterConfig regConfig, EReference reference) {
        boolean _tripleNotEquals;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)regConfig);
        Configuration configuration = (Configuration)_rootContainer;
        Include inc = configuration.getIncludes();
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals) {
            Resource _get = _resourceCache.get(inc.getImportURI());
            Resource resource = _get;
            if (resource == null) {
                Resource r;
                resource = configuration.eResource();
                resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
                _resourceCache.put(inc.getImportURI(), resource);
            }
            if (resource != null) {
                EObject _get_1 = (EObject)resource.getContents().get(0);
                scope = this.getScopeForAttr((DocumentRoot)_get_1, regConfig, reference);
            }
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }

    public IScope getScopeForAttr(DocumentRoot registerModel, RegisterConfig config, EReference reference) {
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        try {
            ComponentType component = registerModel.getComponent();
            EObject _eContainer = config.eContainer();
            BusInterfaceType conf = ((Initiator)_eContainer).getName();
            String _name = conf.getName();
            String _plus = _name + "_";
            String _name_1 = config.getName();
            String memoryBlockName = _plus + _name_1;
            ArrayList fields = CollectionLiterals.newArrayList();
            EList _memoryMap = component.getMemoryMaps().getMemoryMap();
            for (MemoryMapType mm : _memoryMap) {
                EList _addressBlock = mm.getAddressBlock();
                for (AddressBlockType ad : _addressBlock) {
                    boolean _equals = ad.getName().equals(memoryBlockName);
                    if (!_equals) continue;
                    Consumer<RegisterType> _function = r -> {
                        Functions.Function1 _function_1 = it -> {
                            AccessType _access = it.getAccess();
                            return !Objects.equals(_access, AccessType.READ_ONLY);
                        };
                        Consumer<FieldType> _function_2 = f -> fields.add(f);
                        IterableExtensions.filter((Iterable)r.getField(), (Functions.Function1)_function_1).forEach(_function_2);
                    };
                    ad.getRegister().forEach(_function);
                }
            }
            ArrayList result = CollectionLiterals.newArrayList();
            for (FieldType f : fields) {
                EObject _eContainer_1 = f.eContainer();
                RegisterType reg = (RegisterType)_eContainer_1;
                String alias = this._nocHelper.alias(reg);
                result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String[])new String[]{alias, f.getName()}), (EObject)f));
            }
            return new SimpleScope(IScope.NULLSCOPE, (Iterable)result);
        }
        catch (Throwable _t) {
            if (!(_t instanceof Exception)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Exception e = (Exception)_t;
            log.error((Object)e.getMessage());
            _xblockexpression = scope;
            return _xblockexpression;
        }
    }

    public IScope getScopeFromRegisterConfig(Configuration config, EReference reference) {
        boolean _tripleNotEquals;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        Resource resource = config.eResource();
        Include includes = config.getIncludes();
        ArrayList comps = CollectionLiterals.newArrayList();
        Include inc = includes;
        String _importURI = inc.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals) {
            Resource r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
            EObject _get = (EObject)r.getContents().get(0);
            ComponentType comp = (ComponentType)_get;
            comps.add(comp);
        }
        _xblockexpression = scope = Scopes.scopeFor((Iterable)comps, (IScope)scope);
        return _xblockexpression;
    }

    private IScope getScopeProjectIncludes(Initiator element, EReference reference) {
        Initiator context;
        IScope _xblockexpression = null;
        IScope scope = IScope.NULLSCOPE;
        for (context = element; context != null && !(context instanceof Configuration); context = context.eContainer()) {
        }
        Configuration model = (Configuration)((Object)context);
        LinkedList<Include> visited = new LinkedList<Include>();
        Include includes = model.getIncludes();
        Include inc = includes;
        if (inc != null && inc.getImportURI() != null && inc.getImportURI().endsWith("spirit") && !visited.contains(inc)) {
            Resource _get;
            visited.add(inc);
            Resource resource = _get = _resourceCache.get(inc.getImportURI());
            if (resource == null) {
                Resource r;
                resource = context.eResource();
                resource = r = EcoreUtil2.getResource((Resource)resource, (String)inc.getImportURI());
                _resourceCache.put(inc.getImportURI(), resource);
            }
            if (resource != null) {
                EObject _get_1 = (EObject)resource.getContents().get(0);
                if (_get_1 instanceof DocumentRoot) {
                    EObject _get_2 = (EObject)resource.getContents().get(0);
                    DocumentRoot root = (DocumentRoot)_get_2;
                    BusInterfacesType busInterfaces = root.getComponent().getBusInterfaces();
                    Functions.Function1 _function = it -> {
                        SlaveType _slave = it.getSlave();
                        return _slave != null;
                    };
                    return Scopes.scopeFor((Iterable)IterableExtensions.filter((Iterable)busInterfaces.getBusInterface(), (Functions.Function1)_function), (IScope)scope);
                }
            } else {
                return super.getScope((EObject)element, reference);
            }
        }
        _xblockexpression = scope;
        return _xblockexpression;
    }
}

