/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.noc.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.st.stellar.noc.NocHelper.NocHelper;
import com.st.stellar.noc.NocHelper.ResourceUtils;
import com.st.stellar.noc.nocCfg.Configuration;
import com.st.stellar.noc.nocCfg.FieldInstance;
import com.st.stellar.noc.nocCfg.Include;
import com.st.stellar.noc.nocCfg.Initiator;
import com.st.stellar.noc.nocCfg.NocCfgPackage;
import com.st.stellar.noc.nocCfg.RegisterConfig;
import com.st.stellar.noc.validation.AbstractNocCfgValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BitWidthType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.BusInterfaceType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.EnumeratedValueType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class NocCfgValidator
extends AbstractNocCfgValidator {
    @Inject
    @Extension
    private NocHelper _nocHelper;
    protected static final String ISSUE_CODE_PREFIX = "com.st.stellar.noc.";
    public static final String INVALID_FIELD_INSTANCE_VALUE = "com.st.stellar.noc.invalidFieldInstanceValue";
    public static final String INVALID_REGISTER_CONFIG_NAME = "com.st.stellar.noc.invalidRegisterConfigName";
    public static final String DUPLICATED_REGISTERCONFIG = "com.st.stellar.noc.duplicatedRegisterConfigName";
    public static final String DUPLICATED_FIELD = "com.st.stellar.noc.duplicatedField";
    public static final String SAME_TARGET_NAME = "com.st.stellar.noc.sameTargetName";
    public static final String FORBIDDEN_QOS_MODE = "com.st.stellar.noc.forbiddenQoSMode";
    public static final String ATBID_DUPLICATED_IN_INITIATOR = "com.st.stellar.noc.duplicatedAtbId";
    public static final String INVALID_INCLUDE = "com.st.stellar.noc.invalidInclude";
    public static final String INVALID_OUTPUTFOLDER = "com.st.stellar.noc.invalidOutputFolder";
    public static final String DUPLICATED_INITIATOR_NAME = "com.st.stellar.noc.duplicatedInitiatorName";

    public Pair<Boolean, String> checkValue(FieldInstance fieldInstance, String valueStr) {
        FieldType field = fieldInstance.getAttr();
        if (field.getEnumeratedValues() == null || field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            boolean outOfRange;
            boolean _tripleEquals;
            BitWidthType _bitWidth = field.getBitWidth();
            boolean bl = _tripleEquals = _bitWidth == null;
            if (_tripleEquals) {
                return new Pair((Object)Boolean.TRUE, (Object)"");
            }
            int bits = field.getBitWidth().getValue().intValue();
            long value = this._nocHelper.getLongValue(fieldInstance.getValue());
            if (value < 0L) {
                String message = NLS.bind((String)"Wrong value ''{0}'' for bit field ''{1}''", (Object)valueStr, (Object)field.getName());
                Boolean error = Boolean.FALSE;
                return new Pair((Object)error, (Object)message);
            }
            long max = (1L << bits) - 1L;
            boolean bl2 = outOfRange = value > max;
            if (outOfRange) {
                String _name = field.getName();
                String _value = fieldInstance.getValue();
                String _upperCase = Long.toHexString(max).toUpperCase(Locale.ENGLISH);
                String _plus = "0x0..0x" + _upperCase;
                Object[] objs = CollectionLiterals.newArrayList((Object[])new String[]{_name, _value, _plus}).toArray();
                String message_1 = NLS.bind((String)"Bit field ''{0}'' value ''{1}'' is out of range ({2})", (Object[])objs);
                Boolean error_1 = Boolean.FALSE;
                return new Pair((Object)error_1, (Object)message_1);
            }
            return new Pair((Object)Boolean.TRUE, (Object)"");
        }
        EList values = field.getEnumeratedValues().getEnumeratedValue();
        EnumeratedValueType enumValue = null;
        long valueLong = this._nocHelper.getLongValue(valueStr);
        if (valueLong < 0L) {
            String nameStr = valueStr.replaceAll("'", "").replaceAll("\"", "");
            Functions.Function1 _function = it -> it.getName().equals(nameStr);
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function);
        } else {
            Functions.Function1 _function_1 = it -> {
                boolean _xblockexpression = false;
                long enumLong = this._nocHelper.getLongValue(it.getValue());
                _xblockexpression = Long.valueOf(enumLong).equals(valueLong);
                return _xblockexpression;
            };
            enumValue = (EnumeratedValueType)IterableExtensions.findFirst((Iterable)values, (Functions.Function1)_function_1);
        }
        if (enumValue == null) {
            String message_2 = NLS.bind((String)"Wrong value ''{0}'' for bit field ''{1}''", (Object)valueStr, (Object)field.getName());
            Boolean error_2 = Boolean.FALSE;
            return new Pair((Object)error_2, (Object)message_2);
        }
        return new Pair((Object)Boolean.TRUE, (Object)"");
    }

    @Check
    public void checkInclude(Include include) {
        EObject _resourceToEObject;
        DocumentRoot importedNoc;
        boolean _tripleNotEquals;
        String _importURI = include.getImportURI();
        boolean bl = _tripleNotEquals = _importURI != null;
        if (_tripleNotEquals && (importedNoc = (DocumentRoot)(_resourceToEObject = ResourceUtils.resourceToEObject(ResourceUtils.openImport(include.eResource(), include.getImportURI())))) == null) {
            String _importURI_1 = include.getImportURI();
            String _plus = "Invalid include value: '" + _importURI_1;
            String _plus_1 = _plus + "', resource does not exist.";
            this.error(_plus_1, include, (EStructuralFeature)NocCfgPackage.eINSTANCE.getInclude_ImportURI(), INVALID_INCLUDE, new String[0]);
        }
    }

    @Check
    public void checkFieldInstanceValue(FieldInstance instance) {
        FieldType bf = instance.getAttr();
        String value = instance.getValue();
        if (bf == null || value == null) {
            return;
        }
        Pair<Boolean, String> res = this.checkValue(instance, value);
        Boolean _key = (Boolean)res.getKey();
        boolean valid = _key;
        if (!valid) {
            String _value;
            String message = _value = (String)res.getValue();
            List<String> values = this.possibleValues(instance);
            this.error(message, (EStructuralFeature)NocCfgPackage.Literals.FIELD_INSTANCE__VALUE, INVALID_FIELD_INSTANCE_VALUE, (String[])Iterables.toArray(values, String.class));
        }
    }

    @Check
    public void checkFieldRegisterConfigValue(RegisterConfig rconfig) {
        boolean _not;
        EObject _eContainer = rconfig.eContainer();
        Initiator initiator = (Initiator)_eContainer;
        BusInterfaceType bit = initiator.getName();
        ArrayList validvalues = CollectionLiterals.newArrayList();
        MemoryMapType mm = this._nocHelper.memoryMap(bit);
        if (mm != null) {
            EList _addressBlock = mm.getAddressBlock();
            for (AddressBlockType addressBlock : _addressBlock) {
                Functions.Function1 _function = it -> {
                    boolean _contains = it.getName().contains("_Reserved_");
                    return !_contains;
                };
                Consumer<RegisterType> _function_1 = it -> validvalues.add(this._nocHelper.addressBlockName((RegisterType)it));
                IterableExtensions.filter((Iterable)addressBlock.getRegister(), (Functions.Function1)_function).forEach(_function_1);
            }
        }
        HashSet seen = CollectionLiterals.newHashSet();
        Predicate _function_2 = it -> {
            boolean _add = seen.add(it);
            return !_add;
        };
        Iterables.removeIf((Iterable)validvalues, (Predicate)_function_2);
        boolean _contains = validvalues.contains(rconfig.getName());
        boolean bl = _not = !_contains;
        if (_not) {
            String message = "Register Config not correct";
            this.error("Register Config not correct", (EStructuralFeature)NocCfgPackage.Literals.REGISTER_CONFIG__NAME, INVALID_REGISTER_CONFIG_NAME, (String[])Iterables.toArray((Iterable)validvalues, String.class));
        }
    }

    @Check
    public void checkNoDuplicatedRegisterConfig(Initiator initiator) {
        HashMultimap multiMap = HashMultimap.create();
        EList<RegisterConfig> _configs = initiator.getConfigs();
        for (RegisterConfig e : _configs) {
            multiMap.put((Object)e.getName(), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (RegisterConfig d : duplicates) {
                String _name = d.getName();
                String _plus = "Duplicated register configs name: " + _name;
                this.error(_plus, d, (EStructuralFeature)NocCfgPackage.eINSTANCE.getRegisterConfig_Name(), DUPLICATED_REGISTERCONFIG, new String[0]);
            }
        }
    }

    @Check
    public void checkNoDuplicatedField(RegisterConfig rconfig) {
        HashMultimap multiMap = HashMultimap.create();
        EList<FieldInstance> _properties = rconfig.getProperties();
        for (FieldInstance e : _properties) {
            multiMap.put((Object)e.getAttr(), (Object)e);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (FieldInstance d : duplicates) {
                String _name = d.getAttr().getName();
                String _plus = "Duplicated Field Name: " + _name;
                this.error(_plus, d, (EStructuralFeature)NocCfgPackage.eINSTANCE.getFieldInstance_Attr(), DUPLICATED_FIELD, new String[0]);
            }
        }
    }

    public List<String> possibleValues(FieldInstance regInstance) {
        ArrayList<String> _xblockexpression = null;
        FieldType field = regInstance.getAttr();
        ArrayList<String> _xifexpression = null;
        if (field.getEnumeratedValues() != null && !field.getEnumeratedValues().getEnumeratedValue().isEmpty()) {
            ArrayList _arrayList;
            ArrayList _elvis = null;
            Functions.Function1 _function = it -> it.getValue();
            ArrayList _map = ListExtensions.map((List)field.getEnumeratedValues().getEnumeratedValue(), (Functions.Function1)_function);
            _elvis = _map != null ? _map : (_arrayList = new ArrayList());
            _xifexpression = _elvis;
        } else {
            ArrayList<String> list;
            ArrayList<String> _xblockexpression_1 = null;
            _xifexpression = _xblockexpression_1 = (list = new ArrayList<String>());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Check
    public void checkSameTargetNameForDifferentInitiators(RegisterConfig rconfig) {
        boolean _tripleNotEquals;
        EObject _eContainer = rconfig.eContainer();
        Initiator init = (Initiator)_eContainer;
        String targetName = rconfig.getName();
        EObject _eContainer_1 = init.eContainer();
        Configuration root = (Configuration)_eContainer_1;
        String _name = init.getName().getName();
        boolean bl = _tripleNotEquals = _name != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function = it -> {
                boolean _equals = it.getName().getName().equals(init.getName().getName());
                return !_equals;
            };
            Iterable otherInitiators = IterableExtensions.filter(root.getInitiators(), (Functions.Function1)_function);
            for (Initiator i : otherInitiators) {
                EList<RegisterConfig> targets = i.getConfigs();
                for (RegisterConfig t : targets) {
                    boolean _equals = t.getName().equals(targetName);
                    if (!_equals) continue;
                    Object[] objs = CollectionLiterals.newArrayList((Object[])new String[]{init.getName().getName(), i.getName().getName(), targetName}).toArray();
                    String errorMessage = NLS.bind((String)"Initiators ''{0}'' and ''{1}'' cannot configure same target ''{2}''", (Object[])objs);
                    this.error(errorMessage, rconfig, (EStructuralFeature)NocCfgPackage.eINSTANCE.getRegisterConfig_Name(), SAME_TARGET_NAME, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkQoSMode(FieldInstance field) {
        boolean _tripleEquals;
        FieldType _attr = field.getAttr();
        boolean bl = _tripleEquals = _attr == null;
        if (_tripleEquals) {
            return;
        }
        if (field.getValue() == null || field.getValue().isEmpty()) {
            return;
        }
        FieldType attr = field.getAttr();
        EObject _eContainer = attr.eContainer();
        RegisterType reg = (RegisterType)_eContainer;
        if (reg != null && reg.getName().contains("QosGenerator_Mode")) {
            String resetValueStr = this._nocHelper.defaultRawValue(reg, attr);
            long resetValue = this._nocHelper.getLongValue(resetValueStr);
            long value = this._nocHelper.rawValue(field);
            if (value != 2L) {
                boolean _matched = false;
                if (Objects.equals(resetValue, 0L)) {
                    _matched = true;
                    if (value > 0L) {
                        String errorMessage = NLS.bind((String)"Cannot set mode to ''{0}'' (reset value for mode is 'FIXED')", (Object)this._nocHelper.valueAsString(attr, field.getValue()));
                        this.error(errorMessage, field, (EStructuralFeature)NocCfgPackage.eINSTANCE.getFieldInstance_Value(), FORBIDDEN_QOS_MODE, new String[0]);
                    }
                }
                if (!_matched && Objects.equals(resetValue, 1L)) {
                    _matched = true;
                    if (value > 1L) {
                        String errorMessage_1 = NLS.bind((String)"Cannot set mode to ''{0}'' (reset value for mode is 'LIMITER')", (Object)this._nocHelper.valueAsString(attr, field.getValue()));
                        this.error(errorMessage_1, field, (EStructuralFeature)NocCfgPackage.eINSTANCE.getFieldInstance_Value(), FORBIDDEN_QOS_MODE, new String[0]);
                    }
                }
                if (!_matched && Objects.equals(resetValue, 3L)) {
                    _matched = true;
                }
                if (!_matched) {
                    // empty if block
                }
            }
        }
    }

    @Check
    public void checkAtbIdInSameInitiator(FieldInstance inst) {
        EObject _eContainer = inst.eContainer();
        RegisterConfig rconfig = (RegisterConfig)_eContainer;
        EObject _eContainer_1 = rconfig.eContainer();
        Initiator init = (Initiator)_eContainer_1;
        HashMultimap multiMap = HashMultimap.create();
        EList<RegisterConfig> _configs = init.getConfigs();
        for (RegisterConfig config : _configs) {
            EList<FieldInstance> _properties = config.getProperties();
            for (FieldInstance field : _properties) {
                FieldType attr = field.getAttr();
                if (attr.getName() == null || !attr.getName().contains("ATBID")) continue;
                multiMap.put((Object)this._nocHelper.getLongValue(field.getValue()), (Object)field);
            }
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (FieldInstance d : duplicates) {
                this.error(NLS.bind((String)"Duplicated value for field AtbId inside same initiator ''{0}''", (Object)init.getName().getName()), d, (EStructuralFeature)NocCfgPackage.eINSTANCE.getFieldInstance_Attr(), ATBID_DUPLICATED_IN_INITIATOR, new String[0]);
            }
        }
    }

    @Check
    public void checkOutputFolder(Configuration configuration) {
        String outputfolder = configuration.getOutputFolder();
        boolean _contains = outputfolder.contains("..");
        if (_contains) {
            this.error("outputFolder does not support relative path", configuration, (EStructuralFeature)NocCfgPackage.eINSTANCE.getConfiguration_OutputFolder(), INVALID_OUTPUTFOLDER, new String[0]);
        }
    }

    @Check
    public void checkUniqueInitiatorName(Configuration config) {
        HashMultimap multiMap = HashMultimap.create();
        EList<Initiator> initiators = config.getInitiators();
        if (initiators != null) {
            for (Initiator e : initiators) {
                multiMap.put((Object)e.getName(), (Object)e);
            }
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (Initiator d : duplicates) {
                this.error(NLS.bind((String)"Duplicated initiator ''{0}''", (Object)d.getName().getName()), d, (EStructuralFeature)NocCfgPackage.eINSTANCE.getInitiator_Name(), DUPLICATED_INITIATOR_NAME, new String[0]);
            }
        }
    }
}

