/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpio.formatting2;

import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.Import;
import com.st.stellar.pinmap.gpio.gpioDsl.Include;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Part;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialFunction;
import com.st.stellar.pinmap.gpio.services.GpioDslGrammarAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class GpioDslFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private GpioDslGrammarAccess _gpioDslGrammarAccess;

    protected void _format(PinmapModel pinmapModel, @Extension IFormattableDocument document) {
        EList<Include> _includes = pinmapModel.getIncludes();
        for (Object include : _includes) {
            document.format(include);
        }
        EList<Import> _imports = pinmapModel.getImports();
        for (Import _import : _imports) {
            document.format((Object)_import);
        }
        EList<Family> _families = pinmapModel.getFamilies();
        for (Family family : _families) {
            document.format((Object)family);
        }
    }

    protected void _format(Family family, @Extension IFormattableDocument document) {
        EList<Part> _parts = family.getParts();
        for (Object part : _parts) {
            document.format(part);
        }
        EList<Peripheral> _peripherals = family.getPeripherals();
        for (Object peripheral : _peripherals) {
            document.format(peripheral);
        }
        EList<Function> _functions = family.getFunctions();
        for (Object function : _functions) {
            document.format(function);
        }
        EList<SpecialFunction> _specialFunctions = family.getSpecialFunctions();
        for (Object specialFunction : _specialFunctions) {
            document.format(specialFunction);
        }
        EList<Configuration> _configurations = family.getConfigurations();
        for (Configuration configuration : _configurations) {
            document.format((Object)configuration);
        }
        EList<Package> _packages = family.getPackages();
        for (Package _package : _packages) {
            document.format((Object)_package);
        }
    }

    @XbaseGenerated
    public void format(Object family, IFormattableDocument document) {
        if (family instanceof XtextResource) {
            this._format((XtextResource)family, document);
            return;
        }
        if (family instanceof Family) {
            this._format((Family)family, document);
            return;
        }
        if (family instanceof PinmapModel) {
            this._format((PinmapModel)family, document);
            return;
        }
        if (family instanceof EObject) {
            this._format((EObject)family, document);
            return;
        }
        if (family == null) {
            this._format(null, document);
            return;
        }
        if (family != null) {
            this._format(family, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(family, document).toString());
    }
}

