/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpio.generator;

import com.google.common.collect.Iterables;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class GpioDslGenerator
extends AbstractGenerator {
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        PinmapModel pinmapModel = (PinmapModel)_head;
        EList<Family> _families = pinmapModel.getFamilies();
        for (Family f : _families) {
            String n = f.getLabel();
            EList<Package> _packages = f.getPackages();
            for (Package p : _packages) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Family: ");
                String _name = f.getName();
                _builder.append(_name);
                _builder.newLineIfNotEmpty();
                String _generatePackage = this.generatePackage(p);
                _builder.append(_generatePackage);
                _builder.newLineIfNotEmpty();
                String fileContent = _builder.toString();
                String _name_1 = p.getName();
                String _plus = "../data-gen/" + n + "_" + _name_1;
                String _plus_1 = _plus + ".txt";
                fsa.generateFile(_plus_1, (CharSequence)fileContent);
            }
        }
    }

    public String generatePackage(Package p) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Package: ");
        String _name = p.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        Object packages = _builder.toString();
        EList<Pin> _pins = p.getPins();
        for (Pin pin : _pins) {
            String _packages = packages;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\t");
            _builder_1.append("Pin: ");
            String _name_1 = pin.getName();
            _builder_1.append(_name_1, "\t");
            _builder_1.newLineIfNotEmpty();
            packages = _packages + String.valueOf(_builder_1);
            Iterable _filter = Iterables.filter(pin.getPinConfigurations(), ConfigurablePin.class);
            for (ConfigurablePin c : _filter) {
                Object _packages_1 = packages;
                String _generateConfig = this.generateConfig(c);
                packages = (String)_packages_1 + _generateConfig;
            }
        }
        _xblockexpression = packages;
        return _xblockexpression;
    }

    public String generateConfig(ConfigurablePin cfg) {
        ConfigurablePin context;
        Object _xblockexpression = null;
        for (context = cfg; context != null && !(context instanceof Family); context = context.eContainer()) {
        }
        Family root = (Family)((Object)context);
        String id = cfg.getRef().getName();
        Pattern pattern = Pattern.compile("P([0-9]*)_([0-9]*)");
        Matcher matcher = pattern.matcher(id);
        StringConcatenation _builder = new StringConcatenation();
        Object config = _builder.toString();
        boolean _find = matcher.find();
        if (_find) {
            StringConcatenation _builder_3;
            String bank = matcher.group(1);
            String index = matcher.group(2);
            Functions.Function1 _function = it -> it.getName().startsWith(bank + "_");
            Iterable registerList = IterableExtensions.filter((Iterable)((AddressBlockType)root.getRef().getAddressBlock().get(0)).getRegister(), (Functions.Function1)_function);
            Object _config = config;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\t\t");
            _builder_1.append("Config: ");
            String _label = cfg.getRef().getLabel();
            _builder_1.append(_label, "\t\t");
            _builder_1.append(" (");
            int _size = IterableExtensions.size((Iterable)registerList);
            _builder_1.append((Object)_size, "\t\t");
            _builder_1.append(" registers)");
            _builder_1.newLineIfNotEmpty();
            config = (String)_config + String.valueOf(_builder_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            Object registerFields = _builder_2.toString();
            for (RegisterType r : registerList) {
                FieldType field;
                block11: {
                    field = null;
                    try {
                        field = (FieldType)r.getField().get(Integer.parseInt(index));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IndexOutOfBoundsException) {
                            field = null;
                            try {
                                EList _field = r.getField();
                                int _parseInt = Integer.parseInt(index);
                                int _minus = 8 - _parseInt;
                                field = (FieldType)_field.get(_minus);
                            }
                            catch (Throwable _t_1) {
                                if (_t_1 instanceof Exception) {
                                    field = null;
                                    break block11;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t_1);
                            }
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                if (field == null) continue;
                String _registerFields = registerFields;
                _builder_3 = new StringConcatenation();
                String _name = field.getName();
                _builder_3.append(_name);
                _builder_3.append(" (address offset: ");
                String _addressOffset = r.getAddressOffset();
                _builder_3.append(_addressOffset);
                _builder_3.append(" bit offset: ");
                int _intValue = field.getBitOffset().intValue();
                _builder_3.append((Object)_intValue);
                _builder_3.append(")");
                _builder_3.newLineIfNotEmpty();
                registerFields = _registerFields + String.valueOf(_builder_3);
            }
            EList<FunctionRef> _functions = cfg.getRef().getFunctions();
            for (FunctionRef f : _functions) {
                Object _config_1 = config;
                _builder_3 = new StringConcatenation();
                _builder_3.append("\t\t\t");
                String _label_1 = f.getName().getLabel();
                _builder_3.append(_label_1, "\t\t\t");
                _builder_3.append(" on ");
                String _name = f.getName().getPeripheralRef().getName();
                _builder_3.append(_name, "\t\t\t");
                _builder_3.append(" (Alt = ");
                String _alt = f.getAlt();
                _builder_3.append(_alt, "\t\t\t");
                _builder_3.append(")");
                _builder_3.newLineIfNotEmpty();
                Object _config_2 = config = (String)_config_1 + String.valueOf(_builder_3);
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("\t\t\t\t");
                _builder_4.append((String)registerFields, "\t\t\t\t");
                config = (String)_config_2 + String.valueOf(_builder_4);
            }
        } else {
            String _config_1 = config;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Cannot find matching register for configuration ");
            _builder_3.append(id);
            config = _config_1 + String.valueOf(_builder_3);
        }
        _xblockexpression = config;
        return _xblockexpression;
    }
}

