/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpio.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.st.stellar.pinmap.gpio.GpioDslStandaloneSetup;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Main {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private GeneratorDelegate generator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;

    public static void main(String[] args) {
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)args)).isEmpty();
        if (_isEmpty) {
            System.err.println("Aborting: no path to EMF resource provided!");
            return;
        }
        Injector injector = new GpioDslStandaloneSetup().createInjectorAndDoEMFRegistration();
        Main main = (Main)injector.getInstance(Main.class);
        main.runGenerator(args[0]);
    }

    protected void runGenerator(String string) {
        boolean _not;
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        Resource resource = set.getResource(URI.createFileURI((String)string), true);
        List issues = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        boolean _isEmpty = issues.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Consumer<Issue> _function = it -> System.err.println(it);
            issues.forEach(_function);
            return;
        }
        this.fileAccess.setOutputPath("src-gen/");
        GeneratorContext _generatorContext = new GeneratorContext();
        Procedures.Procedure1 _function_1 = it -> it.setCancelIndicator(CancelIndicator.NullImpl);
        GeneratorContext context = (GeneratorContext)ObjectExtensions.operator_doubleArrow((Object)_generatorContext, (Procedures.Procedure1)_function_1);
        this.generator.generate(resource, (IFileSystemAccess2)this.fileAccess, (IGeneratorContext)context);
        System.out.println("Code generation finished.");
    }
}

