/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpio.helpers;

import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialPin;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class Utils {
    public static Utils instance = new Utils();
    public static String REGEX_SYMBOL_NAME = "[a-zA-Z0-9_]+";

    public static String sanitize(Object object) {
        String _xblockexpression = null;
        String dest = new String();
        if (object instanceof String) {
            String string = (String)object;
            for (int i = 0; i < string.length(); ++i) {
                String c = string.substring(i, i + 1);
                boolean _matches = Pattern.matches(REGEX_SYMBOL_NAME, c);
                dest = _matches ? dest.concat(c) : dest.concat("_");
            }
        }
        _xblockexpression = dest.toLowerCase(Locale.ENGLISH);
        return _xblockexpression;
    }

    public static String quotify(String string) {
        return "\"" + string + "\"";
    }

    protected String _getCfgName(ConfigurablePin pin, int len) {
        boolean _greaterThan;
        String pad = pin.getRef().getName();
        int _length = pad.length();
        boolean bl = _greaterThan = _length > len;
        if (_greaterThan) {
            return pad.substring(0, len);
        }
        return pad;
    }

    protected String _getCfgName(SpecialPin pin, int len) {
        boolean _greaterThan;
        String pad = pin.getRef().getName();
        int _length = pad.length();
        boolean bl = _greaterThan = _length > len;
        if (_greaterThan) {
            return pad.substring(0, len);
        }
        return pad;
    }

    protected String _getCfgName(SystemFunctionPin pin, int len) {
        boolean _greaterThan;
        String pad = pin.getRef().getName();
        int _length = pad.length();
        boolean bl = _greaterThan = _length > len;
        if (_greaterThan) {
            return pad.substring(0, len);
        }
        return pad;
    }

    protected String _getCfgName(EObject pin, int len) {
        return "";
    }

    public String getTruncatedPad(Pin pin) {
        EList<PinConfig> _pinConfigurations = pin.getPinConfigurations();
        Iterator iterator = _pinConfigurations.iterator();
        if (iterator.hasNext()) {
            PinConfig cfg = (PinConfig)iterator.next();
            return this.getCfgName(cfg, 4);
        }
        return "";
    }

    public String getFullPadName(Pin pin) {
        EList<PinConfig> _pinConfigurations = pin.getPinConfigurations();
        Iterator iterator = _pinConfigurations.iterator();
        if (iterator.hasNext()) {
            PinConfig cfg = (PinConfig)iterator.next();
            return this.getCfgName(cfg, 80);
        }
        return "";
    }

    @XbaseGenerated
    public String getCfgName(EObject pin, int len) {
        if (pin instanceof ConfigurablePin) {
            return this._getCfgName((ConfigurablePin)pin, len);
        }
        if (pin instanceof SpecialPin) {
            return this._getCfgName((SpecialPin)pin, len);
        }
        if (pin instanceof SystemFunctionPin) {
            return this._getCfgName((SystemFunctionPin)pin, len);
        }
        if (pin != null) {
            return this._getCfgName(pin, len);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(pin, len).toString());
    }
}

