/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpio.validation;

import com.google.common.collect.HashMultimap;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.GpioDslPackage;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpio.validation.AbstractGpioDslValidator;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GpioDslValidator
extends AbstractGpioDslValidator {
    protected static final String ISSUE_CODE_PREFIX = "com.st.stellar.pinmap.gpio.";
    public static final String UNUSED_PERIPHERAL = "com.st.stellar.pinmap.gpio.UnusedPeripheral";
    public static final String DUPLICATED_ELEMENT = "com.st.stellar.pinmap.gpio.duplicatedElement";
    public static final String DUPLICATED_FUNCTION_REF = "com.st.stellar.pinmap.gpio.duplicatedFunctionRef";

    @Check
    public void checkFamillyPeripherals(Family family) {
        EList<Peripheral> _peripherals = family.getPeripherals();
        for (Peripheral p : _peripherals) {
            Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().getName().equals(p.getName());
            Iterable functions = IterableExtensions.filter(family.getFunctions(), (Functions.Function1)_function);
            if (functions != null && !IterableExtensions.isEmpty((Iterable)functions)) continue;
            String _name = p.getName();
            String _plus = "Peripheral not used: " + _name;
            this.error(_plus, p, (EStructuralFeature)GpioDslPackage.eINSTANCE.getPeripheral_Name(), UNUSED_PERIPHERAL, new String[0]);
        }
    }

    @Check
    public void checkNoDuplicatedPinNames(Family family) {
        HashMultimap multiMapPeripherals = HashMultimap.create();
        EList<Peripheral> _peripherals = family.getPeripherals();
        for (Object e : _peripherals) {
            multiMapPeripherals.put((Object)e.getName(), e);
        }
        Set _entrySet = multiMapPeripherals.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Peripheral d = (Peripheral)IterableExtensions.head((Iterable)duplicates);
            String _name = d.getName();
            String _plus = "Duplicated identifier: " + _name;
            this.error(_plus, d, (EStructuralFeature)GpioDslPackage.eINSTANCE.getPeripheral_Name(), DUPLICATED_ELEMENT, new String[0]);
        }
        HashMultimap multiMapFunctions = HashMultimap.create();
        EList<Function> _functions = family.getFunctions();
        for (Function f : _functions) {
            multiMapFunctions.put((Object)f.getName(), (Object)f);
        }
        Set _entrySet_1 = multiMapFunctions.asMap().entrySet();
        for (Map.Entry entry_1 : _entrySet_1) {
            Collection duplicates = (Collection)entry_1.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            Function d = (Function)IterableExtensions.head((Iterable)duplicates);
            String _name = d.getName();
            String _plus = "Duplicated identifier: " + _name;
            this.error(_plus, d, (EStructuralFeature)GpioDslPackage.eINSTANCE.getFunction_Name(), DUPLICATED_ELEMENT, new String[0]);
        }
    }

    @Check
    public void checkNoDuplicatedPinNames(PinmapModel model) {
        EList<Family> _families = model.getFamilies();
        for (Family f : _families) {
            this.checkNoDuplicatedPinNames(f);
        }
    }

    @Check
    public void checkNoDuplicatedFunctionRef(Configuration config) {
        HashMultimap functionNamesMap = HashMultimap.create();
        EList<FunctionRef> _functions = config.getFunctions();
        for (FunctionRef e : _functions) {
            functionNamesMap.put((Object)e.getName(), (Object)e);
        }
        Set _entrySet = functionNamesMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (FunctionRef d : duplicates) {
                String _name = d.getName().getName();
                String _plus = "Duplicated function ref: " + _name;
                this.warning(_plus, d, (EStructuralFeature)GpioDslPackage.eINSTANCE.getFunctionRef_Name(), DUPLICATED_FUNCTION_REF, new String[0]);
            }
        }
    }
}

