/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.codeGenerator.runtime;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpioCfg.FieldInstance;
import com.st.stellar.pinmap.gpioCfg.IOFields;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.framework.Bundle;
import org.spiritconsorsium.xml.spiritmodel.Spirit.FieldType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class GpioCfgCodeGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    private OutputConfiguration outputCfg;
    private static int pageWidth = 50;
    private static String PINMAPCFG_BUNDLE_ID = "com.st.stellar.pinmap.gpiocfg";
    private final List<String> ports = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"GPIO_PORT_A", "GPIO_PORT_B", "GPIO_PORT_C", "GPIO_PORT_D", "GPIO_PORT_E", "GPIO_PORT_F", "GPIO_PORT_G", "GPIO_PORT_H", "GPIO_PORT_I", "GPIO_PORT_J", "GPIO_PORT_K", "GPIO_PORT_L", "GPIO_PORT_M", "GPIO_PORT_N", "GPIO_PORT_Q", "GPIO_PORT_R", "GPIO_PORT_S", "GPIO_PORT_T", "GPIO_PORT_V", "GPIO_PORT_W", "GPIO_PORT_X", "GPIO_PORT_Y"}));

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        ResourceSet resourceSet = (ResourceSet)this.rsp.get();
        Resource r = resourceSet.getResource(resource.getURI(), true);
        boolean _isEmpty = r.getContents().isEmpty();
        if (_isEmpty) {
            return;
        }
        try {
            EObject head = (EObject)IterableExtensions.head((Iterable)r.getContents());
            PinConfiguration cfg = (PinConfiguration)head;
            PinSettings _pinSetting = cfg.getPinSetting();
            if (_pinSetting instanceof PinSettings) {
                boolean _tripleNotEquals;
                PinSettings pinSettings = cfg.getPinSetting();
                Object outputFolder = "";
                String _outputFolder = pinSettings.getOutputFolder();
                boolean bl = _tripleNotEquals = _outputFolder != null;
                if (_tripleNotEquals) {
                    String _outputFolder_1 = pinSettings.getOutputFolder();
                    String _plus = "../" + _outputFolder_1;
                    String _plus_1 = _plus + "/";
                    outputFolder = _plus_1;
                } else if (fsa instanceof JavaIoFileSystemAccess) {
                    JavaIoFileSystemAccess fsa2 = (JavaIoFileSystemAccess)fsa;
                    this.outputCfg = (OutputConfiguration)fsa2.getOutputConfigurations().get("GpioCfgCode");
                    String _outputDirectory = this.outputCfg.getOutputDirectory();
                    String _plus_2 = _outputDirectory + "/";
                    outputFolder = _plus_2;
                    outputFolder = "../" + (String)outputFolder;
                } else {
                    outputFolder = "./src-gen/";
                    outputFolder = "../" + (String)outputFolder;
                }
                String bootheader = this.generatePinSettings(pinSettings);
                String _name = pinSettings.getName();
                String _plus_3 = (String)outputFolder + _name;
                String _plus_4 = _plus_3 + ".h";
                fsa.generateFile(_plus_4, "DEFAULT_OUTPUT", (CharSequence)bootheader);
            }
            GpioCfgCodeGenerator.updateExplorer((EObject)cfg);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace(System.err);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static String getVersion() {
        String _xifexpression = null;
        boolean _isRunning = Platform.isRunning();
        if (_isRunning) {
            String _xblockexpression = null;
            Bundle ideBundle = Platform.getBundle((String)PINMAPCFG_BUNDLE_ID);
            _xifexpression = _xblockexpression = ideBundle.getVersion().toString();
        } else {
            _xifexpression = GpioCfgHelper.GPIOCFG_VERSION;
        }
        return _xifexpression;
    }

    public static String getPluginName() {
        String _xifexpression = null;
        boolean _isRunning = Platform.isRunning();
        if (_isRunning) {
            String _xblockexpression = null;
            Bundle ideBundle = Platform.getBundle((String)PINMAPCFG_BUNDLE_ID);
            _xifexpression = _xblockexpression = ideBundle.getSymbolicName();
        } else {
            _xifexpression = PINMAPCFG_BUNDLE_ID;
        }
        return _xifexpression;
    }

    public String generatePinSettings(PinSettings pinSettings) {
        String fieldStr;
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2022-2026 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* PLEASE NOTE THAT THIS FILE IS GENERATED FROM A CONFIGURATION FILE,");
        _builder.newLine();
        _builder.append("* USING ");
        String _pluginName = GpioCfgCodeGenerator.getPluginName();
        _builder.append(_pluginName);
        _builder.append(", Version ");
        String _string = GpioCfgCodeGenerator.getVersion().toString();
        _builder.append(_string);
        _builder.newLineIfNotEmpty();
        _builder.append("* MODIFYING IT IMPLIES POTENTIAL LOSS OF YOUR MODIFICATIONS.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file    ");
        String _name = pinSettings.getName();
        _builder.append(_name, " ");
        _builder.append(".h");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @brief   SR5E1-");
        String _upperCase = GpioCfgHelper.getBoard((PinSettings)pinSettings).getName().toUpperCase(Locale.US);
        _builder.append(_upperCase, " ");
        _builder.append(" board header file.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup PLATFORM");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup BOARD");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @ingroup PLATFORM");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup ");
        String _upperCase_1 = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @ingroup BOARD");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifndef _");
        String _upperCase_2 = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_2);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_3 = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_3);
        _builder.append("_H_");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <gpio.h>");
        _builder.newLine();
        _builder.append("#include <platform.h>");
        _builder.newLine();
        _builder.append("#include <typedefs.h>");
        _builder.newLine();
        _builder.newLine();
        String _familyDescriptionComment = this.getFamilyDescriptionComment(pinSettings);
        _builder.append(_familyDescriptionComment);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module constants.                                                         */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define ");
        String _upperCase_4 = GpioCfgHelper.getBoard((PinSettings)pinSettings).getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_4);
        _builder.append("\t1");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _allModules = GpioCfgHelper.getAllModules((PinSettings)pinSettings);
        for (Object mod : _allModules) {
            boolean _tripleEquals;
            String _comment = mod.getComment();
            boolean bl = _tripleEquals = _comment == null;
            if (_tripleEquals) {
                _builder.append("/*--------------------- ");
                String _name_1 = mod.getName().getName();
                _builder.append(_name_1);
                _builder.append(" pins definitions ---------------------*/");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("/*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* ");
                String _comment_1 = mod.getComment();
                _builder.append(_comment_1, " ");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
            }
            EList _pins = mod.getPins();
            for (PinSetting pin : _pins) {
                int _length = this.toUpper(pin).length();
                int _minus = pageWidth - _length;
                int _length_1 = "#define ".length();
                int _minus_1 = _minus - _length_1;
                int spaces = _minus_1 - 1;
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _upper = this.toUpper(pin);
                _builder.append(_upper);
                _builder.append(" gpio_iopack(");
                String _portName = this.getPortName(pin);
                _builder.append(_portName);
                _builder.append(", ");
                String _pad = this.getPad(pin);
                _builder.append(_pad);
                _builder.append(") /* ");
                String _padName = this.getPadName(pin);
                _builder.append(_padName);
                _builder.append(" */");
                _builder.newLineIfNotEmpty();
                String _iODefinitions = this.getIODefinitions(pin);
                _builder.append(_iODefinitions);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module pre-compile time settings.                                         */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Derived constants and error checks.                                       */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module data structures and types.                                         */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module macros.                                                            */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* External declarations.                                                    */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if !defined(_FROM_ASM_)");
        _builder.newLine();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("extern \"C\" {");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("#endif /* _FROM_ASM_ */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module inline functions.                                                  */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("__STATIC_INLINE void ");
        String _name_2 = pinSettings.getName();
        _builder.append(_name_2);
        _builder.append("_init(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        EList _allModules_1 = GpioCfgHelper.getAllModules((PinSettings)pinSettings);
        for (Module mod_1 : _allModules_1) {
            String _gpio_set_pin_modes = this.gpio_set_pin_modes(mod_1);
            _builder.append(_gpio_set_pin_modes);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module late inclusions.                                                   */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* _");
        String _upperCase_5 = pinSettings.getName().toUpperCase(Locale.US);
        _builder.append(_upperCase_5);
        _builder.append("_H_ */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/** @} */");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = fieldStr = _builder.toString();
        return _xblockexpression;
    }

    public String gpio_set_pin_modes(Module mod) {
        String _xblockexpression = null;
        Object res = "";
        boolean commentDisplayed = false;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.append("/* ");
        String _name = mod.getName().getName();
        _builder.append(_name, "\t");
        _builder.append(" */");
        _builder.newLineIfNotEmpty();
        String comment = _builder.toString();
        EList _pins = mod.getPins();
        for (PinSetting pin : _pins) {
            IOFields _ioFields = pin.getIoFields();
            boolean _tripleNotEquals = _ioFields != null;
            if (!_tripleNotEquals) continue;
            if (!commentDisplayed) {
                commentDisplayed = true;
                String _res = res;
                res = _res + comment;
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\t");
            _builder_1.append("gpio_set_pin_mode(");
            String _upper = this.toUpper(pin);
            _builder_1.append(_upper, "\t");
            _builder_1.append(", ");
            String _upper_1 = this.toUpper(pin);
            _builder_1.append(_upper_1, "\t");
            _builder_1.append("_CFG);");
            _builder_1.newLineIfNotEmpty();
            String ioMode = _builder_1.toString();
            Object _res_1 = res;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(ioMode);
            res = (String)_res_1 + String.valueOf(_builder_2);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public String toUpper(PinSetting ps) {
        return ps.getName().toUpperCase(Locale.US);
    }

    public String getIODefinitions(PinSetting ps) {
        boolean _greaterThan;
        boolean _tripleEquals;
        String _xblockexpression = null;
        String ioDef = "";
        ArrayList instances = CollectionLiterals.newArrayList();
        IOFields _ioFields = ps.getIoFields();
        boolean bl = _tripleEquals = _ioFields == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/* No IO definition for ");
            String _upper = this.toUpper(ps);
            _builder.append(_upper);
            _builder.append(" */");
            return _builder.toString();
        }
        EList regInstances = ps.getIoFields().getReg();
        for (FieldInstance inst : regInstances) {
            FieldType _attr = inst.getAttr();
            FieldType field = _attr;
            EObject _eContainer = field.eContainer();
            RegisterType reg = (RegisterType)_eContainer;
            boolean _isSupported = this._gpioCfgHelper.isSupported(reg);
            if (!_isSupported) continue;
            instances.add(inst);
        }
        int _size = instances.size();
        boolean bl2 = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _equals;
            boolean _greaterThan_1;
            int _length = this.toUpper(ps).length();
            int _minus = pageWidth - _length;
            int _length_1 = "#define ".length();
            int _minus_1 = _minus - _length_1;
            int _minus_2 = _minus_1 - 2;
            int spaces = Math.max(0, _minus_2);
            int i = 1;
            ArrayList lines = CollectionLiterals.newArrayList();
            int _size_1 = instances.size();
            boolean bl3 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("#define ");
                String _upper_1 = this.toUpper(ps);
                _builder_1.append(_upper_1);
                _builder_1.append("_CFG");
                String _repeat = " ".repeat(spaces);
                _builder_1.append(_repeat);
                _builder_1.append("\\");
                lines.add(_builder_1.toString());
            }
            Object line = "";
            int _size_2 = instances.size();
            boolean bl4 = _equals = _size_2 == 1;
            if (_equals) {
                String _iO = this._gpioCfgHelper.toIO((FieldInstance)instances.get(0));
                String _plus = "\t(" + (String)_iO;
                String _plus_1 = _plus + ")";
                Object _line = line = _plus_1;
                int _length_2 = ((String)line).length();
                int _minus_3 = pageWidth - _length_2;
                int _minus_4 = _minus_3 - 1;
                String _repeat_1 = " ".repeat(Math.max(_minus_4, 1));
                line = (String)_line + _repeat_1;
                lines.add(line);
            } else {
                for (FieldInstance inst_1 : instances) {
                    if (i == 1) {
                        String _iO_1 = this._gpioCfgHelper.toIO(inst_1);
                        String _plus_2 = "\t(" + _iO_1;
                        String _plus_3 = _plus_2 + " |";
                        Object _line_1 = line = _plus_3;
                        int _length_3 = ((String)line).length();
                        int _minus_5 = pageWidth - _length_3;
                        int _minus_6 = _minus_5 - 1;
                        String _repeat_2 = " ".repeat(Math.max(_minus_6, 1));
                        Object _line_2 = line = (String)_line_1 + _repeat_2;
                        line = (String)_line_2 + "\\";
                    } else {
                        boolean _equals_1;
                        int _size_3 = instances.size();
                        boolean bl5 = _equals_1 = i == _size_3;
                        if (_equals_1) {
                            String _iO_2 = this._gpioCfgHelper.toIO(inst_1);
                            String _plus_4 = "\t " + _iO_2;
                            String _plus_5 = _plus_4 + ")";
                            line = _plus_5;
                        } else {
                            String _iO_3 = this._gpioCfgHelper.toIO(inst_1);
                            String _plus_6 = "\t " + _iO_3;
                            String _plus_7 = _plus_6 + " |";
                            Object _line_3 = line = _plus_7;
                            int _length_4 = ((String)line).length();
                            int _minus_7 = pageWidth - _length_4;
                            int _minus_8 = _minus_7 - 1;
                            String _repeat_3 = " ".repeat(Math.max(_minus_8, 1));
                            Object _line_4 = line = (String)_line_3 + _repeat_3;
                            line = (String)_line_4 + "\\";
                        }
                    }
                    lines.add(line);
                    ++i;
                }
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            for (String l : lines) {
                _builder_2.newLineIfNotEmpty();
                _builder_2.append(l);
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t\t\t");
            }
            ioDef = _builder_2.toString();
        } else {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("/* No register instances for ");
            String _upper_2 = this.toUpper(ps);
            _builder_3.append(_upper_2);
            _builder_3.append(" */");
            ioDef = _builder_3.toString();
        }
        _xblockexpression = ioDef;
        return _xblockexpression;
    }

    public String getPadName(PinSetting setting) {
        EList configurations = setting.getPin().getPinConfigurations();
        ConfigurablePin first = ((ConfigurablePin[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)configurations, ConfigurablePin.class), ConfigurablePin.class))[0];
        Pattern pattern = Pattern.compile("P([^\\d]+)(\\d+)");
        Matcher matcher = pattern.matcher(first.getRef().getName());
        boolean _find = matcher.find();
        if (_find) {
            String _group = matcher.group(1);
            String _plus = "P" + _group;
            String _plus_1 = _plus + "[";
            String _group_1 = matcher.group(2);
            String _plus_2 = _plus_1 + _group_1;
            return _plus_2 + "]";
        }
        return first.getRef().getLabel();
    }

    public String getPad(PinSetting setting) {
        EList configurations = setting.getPin().getPinConfigurations();
        ConfigurablePin first = ((ConfigurablePin[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)configurations, ConfigurablePin.class), ConfigurablePin.class))[0];
        Pattern pattern = Pattern.compile("P([\\d]+)_(\\d+)");
        Matcher matcher = pattern.matcher(first.getRef().getName());
        boolean _find = matcher.find();
        if (_find) {
            String _group = matcher.group(2);
            return "GPIO_PIN_" + _group;
        }
        return first.getRef().getName();
    }

    public String getPortName(PinSetting setting) {
        EList configurations = setting.getPin().getPinConfigurations();
        ConfigurablePin first = ((ConfigurablePin[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)configurations, ConfigurablePin.class), ConfigurablePin.class))[0];
        Pattern pattern = Pattern.compile("P([\\d]+)_(\\d+)");
        Matcher matcher = pattern.matcher(first.getRef().getName());
        boolean _find = matcher.find();
        if (_find) {
            int index = Integer.parseInt(matcher.group(1));
            return this.ports.get(index);
        }
        return first.getRef().getName();
    }

    public String getFamilyDescriptionComment(PinSettings ps) {
        boolean _greaterThan;
        String _xblockexpression = null;
        StringBuffer sb = new StringBuffer();
        String desc = this._gpioCfgHelper.getFamilyDescription(ps);
        int _length = desc.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            String[] _split;
            sb.append("/*===========================================================================*/\n");
            for (String line : _split = desc.split("\n")) {
                boolean _greaterThan_1;
                String l = line.trim().replaceAll("\n", "");
                String _xifexpression = null;
                int _length_1 = l.length();
                boolean bl2 = _greaterThan_1 = _length_1 > 73;
                if (_greaterThan_1) {
                    _xifexpression = "";
                } else {
                    int _length_2 = l.length();
                    int _minus = 73 - _length_2;
                    _xifexpression = " ".repeat(_minus);
                }
                String _plus = "/* " + l + _xifexpression;
                String _plus_1 = _plus + " */\n";
                sb.append(_plus_1);
            }
            sb.append("/*===========================================================================*/\n");
        }
        _xblockexpression = sb.toString();
        return _xblockexpression;
    }

    public static IProject getProject(EObject model) {
        boolean _not;
        IProject project = null;
        URI uri = model.eResource().getURI();
        boolean _isFile = uri.isFile();
        boolean bl = _not = !_isFile;
        if (_not) {
            project = null;
        }
        String projectName = ((String)uri.segmentsList().get(1)).toString();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    public static void updateExplorer(EObject model) {
        IProject project = GpioCfgCodeGenerator.getProject(model);
        if (project != null) {
            try {
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }
}

