/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.excelGenerator.runtime;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.Include;
import com.st.stellar.pinmap.gpio.gpioDsl.NotConnectedPin;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.PinmapModel;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialPin;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import com.st.stellar.pinmap.gpio.helpers.ResourceUtils;
import com.st.stellar.pinmap.gpioCfg.IncludeBoard;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.spiritconsorsium.xml.spiritmodel.Spirit.AddressBlockType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.ComponentType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.DocumentRoot;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.MemoryMapsType;
import org.spiritconsorsium.xml.spiritmodel.Spirit.RegisterType;

public class ExcelGenerator
extends AbstractGenerator {
    @Inject
    @Extension
    private GpioCfgHelper _gpioCfgHelper;
    @Inject
    private Provider<ResourceSet> rsp;
    private final String[] columns = new String[]{"#", "Pin identifier", "Active", "Function direction", "FunctionName", "Peripheral", "Function alternate", "Pin advanced settings"};

    public void doGenerate(Resource r, IFileSystemAccess2 fsa, IGeneratorContext context) {
        boolean _tripleEquals;
        ResourceSet resourceSet = (ResourceSet)this.rsp.get();
        Resource resource = resourceSet.getResource(r.getURI(), true);
        EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        boolean bl = _tripleEquals = _head == null;
        if (_tripleEquals) {
            return;
        }
        EObject _head_1 = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        PinConfiguration configuration = (PinConfiguration)_head_1;
        boolean generateExcel = context.getCancelIndicator().getClass().getName().contains("GenerateExcelFileCancelIndicator");
        if (generateExcel) {
            boolean _tripleEquals_1;
            PinSettings pinSettings = configuration.getPinSetting();
            if (pinSettings == null) {
                return;
            }
            Package _package = GpioCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage();
            boolean bl2 = _tripleEquals_1 = _package == null;
            if (_tripleEquals_1) {
                return;
            }
            EObject _eContainer = GpioCfgHelper.getBoard((IncludeBoard)pinSettings.getIncludedBoard()).getPackage().eContainer();
            String n = ((Family)_eContainer).getName();
            n = n.replaceAll("x", pinSettings.getName());
            String fileName = this._gpioCfgHelper.getGenerationFileName(pinSettings, "xls");
            URI excelFileUri = fsa.getURI(fileName, "GpioCfgCode");
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            String _platformString = excelFileUri.toPlatformString(true);
            Path _path = new Path(_platformString);
            IFile file2 = _root.getFile((IPath)_path);
            this.generateExcel(file2.getRawLocation().toOSString(), pinSettings);
            ExcelGenerator.updateExplorer((EObject)configuration);
        }
    }

    public static String toText(com.st.stellar.pinmap.gpioCfg.Include imp) {
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)imp.eResource(), (String)imp.getImportURI()));
        PinmapModel importedPinmap = (PinmapModel)_resourceToEObject;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Pinmap model file: ");
        String _importURI = imp.getImportURI();
        _builder.append(_importURI);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        if (importedPinmap == null) {
            _builder.append("File cannot be opened.");
            _builder.newLine();
        } else {
            _builder.append("Number of families: ");
            int _size = importedPinmap.getFamilies().size();
            _builder.append((Object)_size);
            _builder.newLineIfNotEmpty();
            EList _includes = importedPinmap.getIncludes();
            for (Include imp2 : _includes) {
                String _text = ExcelGenerator.toText(imp2);
                _builder.append(_text);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder.toString();
    }

    public static List<RegisterType> registers(DocumentRoot root) {
        ArrayList<RegisterType> _xblockexpression = null;
        ArrayList<RegisterType> registerTypes = new ArrayList<RegisterType>();
        ComponentType a = root.getComponent();
        MemoryMapsType memoryMaps = a.getMemoryMaps();
        Iterable _filter = Iterables.filter((Iterable)memoryMaps.eContents(), MemoryMapType.class);
        Iterator iterator = _filter.iterator();
        while (iterator.hasNext()) {
            MemoryMapType m;
            MemoryMapType mmap = m = (MemoryMapType)iterator.next();
            EList listAB = mmap.getAddressBlock();
            for (AddressBlockType ab : listAB) {
                registerTypes.addAll((Collection<RegisterType>)ab.getRegister());
            }
        }
        _xblockexpression = registerTypes;
        return _xblockexpression;
    }

    public static String toText(Include imp) {
        EObject _resourceToEObject = ResourceUtils.resourceToEObject((Resource)ResourceUtils.openImport((Resource)imp.eResource(), (String)imp.getImportURI()));
        DocumentRoot importedRegister = (DocumentRoot)_resourceToEObject;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Register model file: ");
        String _importURI = imp.getImportURI();
        _builder.append(_importURI);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        if (importedRegister == null) {
            _builder.append("File cannot be opened.");
            _builder.newLine();
        } else {
            _builder.append("Number of registers: ");
            int _size = ExcelGenerator.registers(importedRegister).size();
            _builder.append((Object)_size);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String generateExcel(String filename, PinSettings settings) {
        try {
            int i;
            HSSFRow row;
            int _plusPlus;
            String _xblockexpression = null;
            this._gpioCfgHelper = GpioCfgHelper.instance;
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFCreationHelper createHelper = workbook.getCreationHelper();
            HSSFSheet sheet = workbook.createSheet("PinConfiguration");
            HSSFFont headerFont = workbook.createFont();
            headerFont.setFontHeightInPoints(Short.parseShort("14"));
            headerFont.setColor(IndexedColors.RED.getIndex());
            HSSFCellStyle headerCellStyle = workbook.createCellStyle();
            headerCellStyle.setFont(headerFont);
            HSSFRow headerRow = sheet.createRow(0);
            for (int i2 = 0; i2 < this.columns.length; ++i2) {
                HSSFCell cell = headerRow.createCell(i2);
                cell.setCellValue(this.columns[i2]);
                cell.setCellStyle(headerCellStyle);
            }
            HSSFCellStyle dateCellStyle = workbook.createCellStyle();
            dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("dd-MM-yyyy"));
            int rowNb = 1;
            EList _allModules = GpioCfgHelper.getAllModules((PinSettings)settings);
            for (Object mod : _allModules) {
                EList _pins = mod.getPins();
                for (PinSetting pin : _pins) {
                    _plusPlus = rowNb++;
                    row = sheet.createRow(_plusPlus);
                    for (i = 0; i < this.columns.length; ++i) {
                        row.createCell(0).setCellValue(pin.getPin().getName());
                        row.createCell(1).setCellValue(pin.getName());
                        row.createCell(2).setCellValue("true");
                        row.createCell(3).setCellValue(pin.getConfig().getDirection().getName());
                        row.createCell(4).setCellValue(GpioCfgHelper.getFunctionName((PinSetting)pin));
                        String peripheral = this._gpioCfgHelper.getAssociatedPeripheral(pin);
                        row.createCell(5).setCellValue(peripheral);
                        HSSFCell _createCell = row.createCell(6);
                        _createCell.setCellValue(GpioCfgHelper.getFunctionName((PinSetting)pin));
                        HSSFCell _createCell_1 = row.createCell(7);
                        _createCell_1.setCellValue(this._gpioCfgHelper.getIODefinitions(pin).replaceAll("GPIO_MODE_", ""));
                    }
                }
            }
            EList _pins_1 = GpioCfgHelper.getBoard((IncludeBoard)settings.getIncludedBoard()).getPackage().getPins();
            for (Pin pin_1 : _pins_1) {
                PinConfig _get = (PinConfig)pin_1.getPinConfigurations().get(0);
                boolean _not = !(_get instanceof NotConnectedPin);
                if (!_not) continue;
                _plusPlus = rowNb++;
                row = sheet.createRow(_plusPlus);
                for (i = 0; i < this.columns.length; ++i) {
                    row.createCell(0).setCellValue(pin_1.getName());
                    row.createCell(2).setCellValue("NONE");
                    row.createCell(3).setCellValue(this.direction((PinConfig)pin_1.getPinConfigurations().get(0)));
                    row.createCell(4).setCellValue(this.valueOfCell((PinConfig)pin_1.getPinConfigurations().get(0)));
                }
            }
            for (int i3 = 0; i3 < this.columns.length; ++i3) {
                sheet.autoSizeColumn(i3);
            }
            String _xtrycatchfinallyexpression = null;
            try {
                File _file = new File(filename);
                FileOutputStream fileOut = new FileOutputStream(_file);
                workbook.write((OutputStream)fileOut);
                fileOut.close();
            }
            catch (Throwable _t) {
                if (_t instanceof FileNotFoundException) {
                    FileNotFoundException e = (FileNotFoundException)_t;
                    _xtrycatchfinallyexpression = (String)InputOutput.println((Object)e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _direction(ConfigurablePin config) {
        return "";
    }

    protected String _direction(SystemFunctionPin config) {
        return config.getDirection().getName();
    }

    protected String _direction(SpecialPin config) {
        return config.getDirection().getName();
    }

    protected String _direction(NotConnectedPin config) {
        return "NotConnectedPin";
    }

    protected String _valueOfCell(ConfigurablePin config) {
        return config.getRef().getName();
    }

    protected String _valueOfCell(SystemFunctionPin config) {
        return config.getRef().getName();
    }

    protected String _valueOfCell(SpecialPin config) {
        return config.getRef().getName();
    }

    protected String _valueOfCell(NotConnectedPin config) {
        return "NotConnectedPin";
    }

    public void closeStream(Closeable stream) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) break block3;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    public static IProject getProject(EObject model) {
        boolean _not;
        IProject project = null;
        URI uri = model.eResource().getURI();
        boolean _isFile = uri.isFile();
        boolean bl = _not = !_isFile;
        if (_not) {
            project = null;
        }
        String projectName = ((String)uri.segmentsList().get(1)).toString();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    public static void updateExplorer(EObject model) {
        IProject project = ExcelGenerator.getProject(model);
        if (project != null) {
            try {
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                project.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @XbaseGenerated
    public String direction(PinConfig config) {
        if (config instanceof ConfigurablePin) {
            return this._direction((ConfigurablePin)config);
        }
        if (config instanceof NotConnectedPin) {
            return this._direction((NotConnectedPin)config);
        }
        if (config instanceof SpecialPin) {
            return this._direction((SpecialPin)config);
        }
        if (config instanceof SystemFunctionPin) {
            return this._direction((SystemFunctionPin)config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(config).toString());
    }

    @XbaseGenerated
    public String valueOfCell(PinConfig config) {
        if (config instanceof ConfigurablePin) {
            return this._valueOfCell((ConfigurablePin)config);
        }
        if (config instanceof NotConnectedPin) {
            return this._valueOfCell((NotConnectedPin)config);
        }
        if (config instanceof SpecialPin) {
            return this._valueOfCell((SpecialPin)config);
        }
        if (config instanceof SystemFunctionPin) {
            return this._valueOfCell((SystemFunctionPin)config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(config).toString());
    }
}

