/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor;

import com.google.inject.Injector;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Direction;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpio.gpioDsl.PinConfig;
import com.st.stellar.pinmap.gpio.gpioDsl.SpecialPin;
import com.st.stellar.pinmap.gpio.gpioDsl.SystemFunctionPin;
import com.st.stellar.pinmap.gpio.gpioDsl.provider.GpioDslItemProviderAdapterFactory;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.Module;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinProperties;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.gpioCfg.provider.GpioCfgItemProviderAdapterFactory;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.Activator;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.GpioCfgBrowserFocusControlInstaller;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.MyGLSPDiagramComposite;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.RenameDialog;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.ResetSelection;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.OutlinePinMapView;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.ui.BrowserContextMenuInstaller;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.gpiocfg.glsp.server.operations.AssignPinFunctionOperation;
import com.st.stellar.pinmap.gpiocfg.glsp.server.operations.PopupStateChangeOperation;
import com.st.stellar.pinmap.gpiocfg.glsp.server.operations.RenamePinOperation;
import com.st.stellar.pinmap.gpiocfg.ui.editor.GpioCfgEditor;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.validation.GpiocfgValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.ide.editor.ui.BrowserKeyBindingForwarderInstaller;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.CenterAction;
import org.eclipse.glsp.server.actions.FitToScreenAction;
import org.eclipse.glsp.server.emf.EMFModelIndex;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.glsp.server.features.core.model.UpdateModelAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.spiritconsorsium.xml.spiritmodel.Spirit.provider.SpiritItemProviderAdapterFactory;

public class GpioCfgGLSPDiagramEditor
extends GLSPDiagramEditor
implements IEditingDomainProvider {
    static Logger LOGGER = LogManager.getLogger(GLSPDiagramEditor.class);
    static String CONFIG_EDITOR_ID = "com.st.stellar.pinmap.Gpiocfg";
    static String BOARD_EDITOR_ID = "com.st.stellar.pinmap.Gpiocfg.board";
    protected IContentOutlinePage contentOutlinePage;
    protected TreeViewer contentOutlineViewer;
    protected Viewer currentViewer;
    protected MenuItem menuItemNotUsed = null;
    protected MenuItem menuRenamePin = null;
    protected MenuItem menuItemShowInXtext = null;
    protected MenuItem menuItemNotConfigurable = null;
    protected MenuItem menuItemAlreadyConfigured = null;
    protected ComposedAdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " opened"));
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == GpioCfgGLSPDiagramEditor.this.contentOutlinePage) {
                    GpioCfgGLSPDiagramEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)GpioCfgGLSPDiagramEditor.this);
                    GpioCfgGLSPDiagramEditor.this.setCurrentViewer((Viewer)GpioCfgGLSPDiagramEditor.this.contentOutlineViewer);
                }
            } else if (p == GpioCfgGLSPDiagramEditor.this) {
                GpioCfgGLSPDiagramEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " brought to top"));
        }

        public void partClosed(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " closed"));
        }

        public void partDeactivated(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " deactivated"));
        }

        public void partOpened(IWorkbenchPart p) {
            LOGGER.debug((Object)(p.getSite().getId() + " opened"));
        }
    };
    protected ISelectionChangedListener selectionChangedListener;
    private ISelectionListener updateSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
            if (GpioCfgEditor.class.isInstance(part) && TextSelection.class.isInstance(selection) && GpioCfgGLSPDiagramEditor.this.getInjector() != null) {
                final GpioCfgEditor editor = (GpioCfgEditor)GpioCfgEditor.class.cast(part);
                EMFModelState state = (EMFModelState)GpioCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                GpioCfgModelState PinCfgState = (GpioCfgModelState)state;
                PinConfiguration config = PinCfgState.getPinConfiguration();
                if (config.eResource() != null) {
                    String editorResourceStr = editor.getResource().getRawLocationURI().toString().replaceAll("^file:.*:", "");
                    String configResourceStr = config.eResource().getURI().toString().replaceAll("^file:.*:", "");
                    if (editor.getSite().getId().equals(CONFIG_EDITOR_ID) && configResourceStr.equals(editorResourceStr)) {
                        editor.getDocument().tryReadOnly((IUnitOfWork)new IUnitOfWork<XtextResource, XtextResource>(){

                            public XtextResource exec(XtextResource state) throws Exception {
                                TextSelection ts = (TextSelection)selection;
                                PinSetting config = editor.getPinSettingNearby(state, ts.getOffset());
                                if (config != null) {
                                    GpioCfgGLSPDiagramEditor.this.highlightSelectedPin(config);
                                }
                                return state;
                            }
                        });
                    }
                }
            }
        }
    };
    protected Object contextMenu;
    private MenuManager menuManager = null;
    private Menu menu;
    private OutlinePinMapView outline;
    ISelection mycurrentSelection = StructuredSelection.EMPTY;
    static Integer DIRECT_ANALOG_I = 999;
    static Integer DIRECT_ANALOG_O = 998;
    protected static final String KEY_PIN_MENU_DIRECTION = "pin.menu.direction";
    protected static final String KEY_PIN_MENU_FUNCTION = "pin.menu.function";
    public static String REGEX_SYMBOL_NAME = "[a-zA-Z0-9_]+";
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){
        protected boolean dispatching;

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = GpioCfgGLSPDiagramEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            GpioCfgGLSPDiagramEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            GpioCfgGLSPDiagramEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        this.dispatchUpdateProblemIndication();
                        break;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void dispatchUpdateProblemIndication() {
            if (GpioCfgGLSPDiagramEditor.this.updateProblemIndication && !this.dispatching) {
                this.dispatching = true;
                GpioCfgGLSPDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dispatching = false;
                        GpioCfgGLSPDiagramEditor.this.updateProblemIndication();
                    }
                });
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            GpioCfgGLSPDiagramEditor.this.resourceToDiagnosticMap.remove(target);
            this.dispatchUpdateProblemIndication();
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = GpioCfgGLSPDiagramEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!GpioCfgGLSPDiagramEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    GpioCfgGLSPDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            GpioCfgGLSPDiagramEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!GpioCfgGLSPDiagramEditor.this.isDirty()) {
                                GpioCfgGLSPDiagramEditor.this.getSite().getPage().closeEditor((IEditorPart)GpioCfgGLSPDiagramEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    GpioCfgGLSPDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            GpioCfgGLSPDiagramEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (GpioCfgGLSPDiagramEditor.this.getSite().getPage().getActiveEditor() == GpioCfgGLSPDiagramEditor.this) {
                                GpioCfgGLSPDiagramEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                LOGGER.error((Object)exception);
            }
        }
    };
    private UIJob debouncingJob = null;
    static GModelElement lastSelectedPad = null;

    public GpioCfgGLSPDiagramEditor() {
        LOGGER.setLevel(Level.DEBUG);
        LogManager.getLogger(GLSPDiagramEditor.class).setLevel(Level.DEBUG);
        this.initializeEditingDomain();
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (GpioCfgGLSPDiagramEditor.this.currentViewer != null) {
                        GpioCfgGLSPDiagramEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new GpioCfgItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new GpioDslItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SpiritItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                new UIJob("setSelection"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        GpioCfgGLSPDiagramEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            GpioCfgGLSPDiagramEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.outline = new OutlinePinMapView(this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        if (input instanceof FileEditorInput) {
            FileEditorInput fileinput = (FileEditorInput)input;
            URI.createPlatformResourceURI((String)fileinput.getFile().getFullPath().toString(), (boolean)true);
        }
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("refresh.enabled", true);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext("com.st.stellar.pinmap.gpio.glsp.editor.context");
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.updateSelectionListener);
    }

    private Map<Integer, String> IMAGES() {
        HashMap<Integer, String> options = new HashMap<Integer, String>();
        options.put(0, "image.input");
        options.put(1, "image.output");
        options.put(2, "image.inout");
        options.put(DIRECT_ANALOG_I, "image.input");
        options.put(DIRECT_ANALOG_O, "image.output");
        return options;
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        this.mycurrentSelection = selection;
    }

    protected void fireSelection(Object selectedObject2) {
        if (selectedObject2 != null) {
            StructuredSelection ss = new StructuredSelection(selectedObject2);
            this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)ss));
            this.setSelection((ISelection)ss);
        }
    }

    public void dispose() {
        if (this.outline != null) {
            this.outline.dispose();
            this.outline = null;
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.updateSelectionListener);
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
            this.contentOutlinePage = null;
        }
        super.dispose();
    }

    protected void installBrowserFunctions() {
        new BrowserKeyBindingForwarderInstaller((IServiceLocator)this.getSite()).install(this.getBrowser());
        new GpioCfgBrowserFocusControlInstaller((IEditorPart)this).install(this.getBrowser());
        new BrowserContextMenuInstaller().install(this.getBrowser());
    }

    protected boolean menuExist() {
        return this.menu != null && !this.menu.isDisposed();
    }

    protected void createBrowserMenu() {
        LOGGER.setLevel(Level.DEBUG);
        this.menuManager = new MenuManager();
        this.getSite().registerContextMenu(this.menuManager, this.getSite().getSelectionProvider());
        this.menu = new Menu((Control)this.getBrowser());
        this.getBrowser().setMenu(this.menu);
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Object first;
                ISelection sel = GpioCfgGLSPDiagramEditor.this.getSite().getSelectionProvider().getSelection();
                if (IStructuredSelection.class.isInstance(sel) && GNode.class.isInstance(first = ((IStructuredSelection)IStructuredSelection.class.cast(sel)).getFirstElement())) {
                    if (GpioCfgGLSPDiagramEditor.this.menu.isDisposed()) {
                        return;
                    }
                    for (MenuItem item : GpioCfgGLSPDiagramEditor.this.menu.getItems()) {
                        item.dispose();
                    }
                    GpioCfgGLSPDiagramEditor.this.createMenuItems(GpioCfgGLSPDiagramEditor.this.menu);
                    GpioCfgGLSPDiagramEditor.this.dispatch((Action)new PopupStateChangeOperation(true));
                    return;
                }
                for (MenuItem item : GpioCfgGLSPDiagramEditor.this.menu.getItems()) {
                    item.dispose();
                }
            }

            public void menuHidden(MenuEvent e) {
                GpioCfgGLSPDiagramEditor.this.dispatch((Action)new PopupStateChangeOperation(false));
            }
        });
    }

    protected void createMenuItems(Menu menu) {
        ISelection selection = this.getSelection();
        Optional<PinSetting> ps = this.getSelectedPinSetting(selection);
        if (ps.isPresent()) {
            this.createMenuItems(menu, ps.get(), ps.get().getPin());
        } else {
            Pin pin = this.getSelectedPin(selection);
            if (pin != null) {
                this.createMenuItems(menu, null, pin);
            }
        }
    }

    public static String directionAsString(Integer direction) {
        String text = null;
        switch (direction) {
            case 7: {
                text = "Ground";
                break;
            }
            case 0: {
                text = "Input";
                break;
            }
            case 4: {
                text = "Input alternate";
                break;
            }
            case 3: {
                text = "Input or Output";
                break;
            }
            case 2: {
                text = "InputOutput";
                break;
            }
            case 1: {
                text = "Output";
                break;
            }
            case 5: {
                text = "Output alternate";
                break;
            }
            case 6: {
                text = "Power";
                break;
            }
            default: {
                text = "DirectAnalog";
            }
        }
        return text;
    }

    public static String directionAsString(com.st.stellar.pinmap.gpioCfg.Direction direction) {
        String text = null;
        switch (direction) {
            case INPUT: {
                text = "Input";
            }
            case INPUT_OUTPUT: {
                text = "InputOutput";
            }
            case OUTPUT: {
                text = "Output";
            }
        }
        return text;
    }

    public boolean isBoardPin(PinSetting pin) {
        if (pin == null) {
            return false;
        }
        return pin.eContainer().eContainer() instanceof Board;
    }

    protected void createMenuItems(Menu menu, PinSetting ps, Pin pin) {
        ArrayList<MenuItem> configActions = new ArrayList<MenuItem>();
        if (this.isBoardPin(ps)) {
            this.buildAlreadyConfiguredMenu(menu, pin);
            Board board = (Board)ps.eContainer().eContainer();
            if (!board.eResource().getURI().isPlatform()) {
                this.buildShowInXtextEditorMenu(menu, BOARD_EDITOR_ID);
                this.buildRenamePinMenu(menu);
            }
        } else {
            for (PinConfig reference : pin.getPinConfigurations()) {
                MenuItem menuItem;
                String pad;
                if (reference instanceof SpecialPin) {
                    pad = pin.getName();
                    menuItem = new MenuItem(menu, 64);
                    menuItem.setText(pad);
                    menuItem.setEnabled(false);
                    new MenuItem(menu, 2);
                    this.buildNotConfigurabeMenu(menu);
                    continue;
                }
                if (reference instanceof SystemFunctionPin) {
                    pad = pin.getName();
                    menuItem = new MenuItem(menu, 64);
                    menuItem.setText("PAD: " + pad);
                    menuItem.setEnabled(false);
                    new MenuItem(menu, 2);
                    this.buildNotConfigurabeMenu(menu);
                    continue;
                }
                if (!(reference instanceof ConfigurablePin)) continue;
                ConfigurablePin config = (ConfigurablePin)reference;
                Configuration pad2 = config.getRef();
                HashMap<Integer, Menu> parentItems = new HashMap<Integer, Menu>();
                HashMap<Integer, String> labels = new HashMap<Integer, String>();
                MenuItem menuItem2 = new MenuItem(menu, 64);
                menuItem2.setText(pad2.getLabel() + " on " + pin.getName());
                menuItem2.setEnabled(false);
                new MenuItem(menu, 2);
                int nbNonIntrinsics = 0;
                EList refs = config.getRef().getFunctions();
                for (FunctionRef ref : refs) {
                    Object direction = ref.getDirection();
                    if (ref.getAlt() != null) {
                        if (ref.getAlt().equals("Direct_Analog")) {
                            if (direction == Direction.INPUT) {
                                labels.put(DIRECT_ANALOG_I, "Direct_Analog");
                                this.buildParentMenu(menu, parentItems, DIRECT_ANALOG_I, "Direct Analog");
                            } else if (direction == Direction.OUTPUT) {
                                labels.put(DIRECT_ANALOG_O, "Direct_Analog");
                                this.buildParentMenu(menu, parentItems, DIRECT_ANALOG_O, "Direct Analog");
                            }
                        }
                        ++nbNonIntrinsics;
                        this.addIfMissing(direction.getValue(), labels);
                        boolean gpio = GpioCfgHelper.instance.isGPIO(ref.getName());
                        if (gpio || direction != Direction.INPUT_OR_OUTPUT) continue;
                        this.addIfMissing(0, labels);
                        this.addIfMissing(1, labels);
                        continue;
                    }
                    if (direction == Direction.INPUT) continue;
                    this.addIfMissing(2, labels);
                }
                if (nbNonIntrinsics > 0) {
                    Set keys = labels.keySet();
                    for (Object direction : keys) {
                        String directionStr = (String)labels.get(direction);
                        this.buildParentMenu(menu, parentItems, (Integer)direction, directionStr);
                    }
                    LinkedHashMap<String, ArrayList<Function>> alternateFunctions = new LinkedHashMap<String, ArrayList<Function>>();
                    for (FunctionRef daf : config.getRef().getFunctions()) {
                        if (daf.getAlt() == null) continue;
                        ArrayList<Function> af = (ArrayList<Function>)alternateFunctions.get(daf.getAlt());
                        if (af == null) {
                            af = new ArrayList<Function>();
                            alternateFunctions.put(daf.getAlt(), af);
                        }
                        af.add(daf.getName());
                    }
                    for (FunctionRef ref : config.getRef().getFunctions()) {
                        Menu parent = null;
                        Direction direction = ref.getDirection();
                        if (ref.getAlt() != null) {
                            MenuItem item;
                            if (GpioCfgHelper.instance.isGPIO(ref.getName())) {
                                if (direction == Direction.INPUT) {
                                    parent = (Menu)parentItems.get(0);
                                    item = this.buildItem(configActions, ps, pin, ref, parent, Direction.INPUT);
                                    this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                                    continue;
                                }
                                if (direction != Direction.INPUT_OR_OUTPUT) continue;
                                parent = (Menu)parentItems.get(2);
                                item = this.buildItem(configActions, ps, pin, ref, parent, Direction.INPUT_OUTPUT);
                                this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                                continue;
                            }
                            if (ref.getAlt().equals("Direct_Analog")) {
                                if (direction == Direction.INPUT) {
                                    parent = (Menu)parentItems.get(DIRECT_ANALOG_I);
                                    if (parent == null) continue;
                                    item = this.buildItem(configActions, ps, pin, ref, parent, direction);
                                    this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                                    continue;
                                }
                                if (direction != Direction.OUTPUT || (parent = (Menu)parentItems.get(DIRECT_ANALOG_O)) == null) continue;
                                item = this.buildItem(configActions, ps, pin, ref, parent, direction);
                                this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                                continue;
                            }
                            parent = (Menu)parentItems.get(direction.getValue());
                            if (parent != null) {
                                item = this.buildItem(configActions, ps, pin, ref, parent, direction);
                                this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                            }
                            if (direction != Direction.INPUT_OR_OUTPUT) continue;
                            parent = (Menu)parentItems.get(0);
                            if (!this.isInputOnly(ref, (List<FunctionRef>)refs)) {
                                item = this.buildItem(configActions, ps, pin, ref, parent, Direction.INPUT);
                                this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                            }
                            parent = (Menu)parentItems.get(1);
                            item = this.buildItem(configActions, ps, pin, ref, parent, Direction.OUTPUT);
                            this.selectIfNeeded(ps, (List)alternateFunctions.get(ref.getAlt()), item);
                            continue;
                        }
                        parent = (Menu)parentItems.get(direction.getValue());
                        if (parent != null) {
                            this.buildItem(configActions, ps, pin, ref, parent, direction);
                            continue;
                        }
                        if (direction != Direction.INPUT_OR_OUTPUT || !GpioCfgHelper.instance.isGPIO(ref.getName())) continue;
                        parent = (Menu)parentItems.get(2);
                        this.buildItem(configActions, ps, pin, ref, parent, Direction.INPUT_OUTPUT);
                    }
                    this.buildNotUsedMenu(menu);
                    if (ps != null) {
                        this.buildShowInXtextEditorMenu(menu, CONFIG_EDITOR_ID);
                        this.buildRenamePinMenu(menu);
                    }
                } else {
                    this.buildNotConfigurabeMenu(menu);
                }
                this.menuItemNotUsed.setSelection(ps == null);
            }
        }
    }

    private void selectIfNeeded(PinSetting ps, List<Function> functions, MenuItem menuItem) {
        if (ps != null && ps.getConfig() != null && ps.getConfig().getAlt() != null) {
            menuItem.setSelection(functions.contains(ps.getConfig().getAlt()));
        }
    }

    private void buildAlreadyConfiguredMenu(Menu menu, Pin pin) {
        String pad = pin.getName();
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("PAD: " + pad);
        menuItem.setEnabled(false);
        new MenuItem(menu, 2);
        this.menuItemAlreadyConfigured = new MenuItem(menu, 32);
        this.menuItemAlreadyConfigured.setText("Already configured");
    }

    private void addIfMissing(int direction, Map<Integer, String> labels) {
        String directionStr = GpioCfgGLSPDiagramEditor.directionAsString(direction);
        if (!labels.containsKey(direction)) {
            labels.put(direction, directionStr);
        }
    }

    private void buildNotConfigurabeMenu(Menu menu) {
        this.menuItemNotConfigurable = new MenuItem(menu, 32);
        this.menuItemNotConfigurable.setText("Not configurable");
    }

    protected void buildNotUsedMenu(Menu menu) {
        this.menuItemNotUsed = new MenuItem(menu, 2);
        this.menuItemNotUsed = new MenuItem(menu, 32);
        this.menuItemNotUsed.setText("Not used");
        this.menuItemNotUsed.setImage(Activator.getDefault().getImage("image.notUsed"));
        this.menuItemNotUsed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pin pin;
                EMFModelState state = (EMFModelState)GpioCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                GpioCfgModelState gpiocfgState = (GpioCfgModelState)state;
                PinConfiguration pinConfiguration = gpiocfgState.getPinConfiguration();
                ISelection selection = GpioCfgGLSPDiagramEditor.this.getSelection();
                Optional<PinSetting> ps = GpioCfgGLSPDiagramEditor.this.getSelectedPinSetting(selection);
                if (!ps.isEmpty() && (pin = GpioCfgGLSPDiagramEditor.this.getSelectedPin(selection)) != null) {
                    GpioCfgGLSPDiagramEditor.this.dispatch((Action)new AssignPinFunctionOperation(pinConfiguration, pin, null, null, null)).thenRun(() -> GpioCfgGLSPDiagramEditor.this.setSelection((ISelection)StructuredSelection.EMPTY));
                }
            }
        });
    }

    protected void buildRenamePinMenu(final Menu menu) {
        this.menuRenamePin = new MenuItem(menu, 2);
        this.menuRenamePin = new MenuItem(menu, 8);
        this.menuRenamePin.setText("Rename pin");
        this.menuRenamePin.setImage(Activator.getDefault().getImage("image.renamePin"));
        this.menuRenamePin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                Pin pin;
                EMFModelState state = (EMFModelState)GpioCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                GpioCfgModelState pincfgState = (GpioCfgModelState)state;
                PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
                ISelection selection = GpioCfgGLSPDiagramEditor.this.getSelection();
                Optional<PinSetting> ps = GpioCfgGLSPDiagramEditor.this.getSelectedPinSetting(selection);
                if (!ps.isEmpty() && (pin = GpioCfgGLSPDiagramEditor.this.getSelectedPin(selection)) != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    Composite editorArea = (Composite)page.getWorkbenchWindow().getShell().getChildren()[0];
                    Point center = GpioCfgGLSPDiagramEditor.getCenterCoordinates(editorArea);
                    RenameDialog dialog = new RenameDialog(menu.getShell(), ps.get().getName());
                    dialog.create();
                    dialog.setTitle("Rename pin");
                    Rectangle bounds = dialog.getShell().getBounds();
                    dialog.getShell().setBounds(center.x, center.y, bounds.width, bounds.height);
                    if (dialog.open() == 0) {
                        GpioCfgGLSPDiagramEditor.this.dispatch((Action)new RenamePinOperation(pinConfiguration, ps.get(), dialog.getNewName()));
                    }
                }
            }
        });
        this.menuRenamePin.setSelection(false);
    }

    private static Point getCenterCoordinates(Composite composite) {
        Point size = composite.getSize();
        Point location = composite.toDisplay(0, 0);
        int centerX = location.x + size.x / 2;
        int centerY = location.y + size.y / 2;
        return new Point(centerX, centerY);
    }

    protected void buildShowInXtextEditorMenu(Menu menu, final String editorId) {
        this.menuItemShowInXtext = new MenuItem(menu, 2);
        this.menuItemShowInXtext = new MenuItem(menu, 32);
        this.menuItemShowInXtext.setText("Show in Xtext editor");
        this.menuItemShowInXtext.setImage(Activator.getDefault().getImage("image.locate"));
        this.menuItemShowInXtext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = GpioCfgGLSPDiagramEditor.this.getSelection();
                Optional<PinSetting> ps = GpioCfgGLSPDiagramEditor.this.getSelectedPinSetting(selection);
                if (!ps.isEmpty()) {
                    GpioCfgGLSPDiagramEditor.this.showInXtextEditor(ps.get(), editorId);
                }
            }
        });
    }

    private String fileName(URI uri) {
        int len = uri.segmentCount();
        if (len == 0) {
            return null;
        }
        String lastSegment = uri.segment(len - 1);
        return lastSegment;
    }

    private IProject getProject(EObject eObject) {
        URI uri;
        Resource resource = eObject.eResource();
        if (resource != null && (uri = resource.getURI()).isFile()) {
            File file = new File(uri.toFileString());
            IFile iResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
            if (iResource != null) {
                return iResource.getProject();
            }
            for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                if (!file.getAbsolutePath().startsWith(project.getLocation().toFile().getAbsolutePath())) continue;
                return project;
            }
        }
        return null;
    }

    public void showInXtextEditor(final PinSetting pinSetting, final String editorId) {
        boolean doit = true;
        boolean isDirty = this.isDirty();
        long delay = 1L;
        if (isDirty) {
            String title = "Need to save";
            String[] options = new String[]{"Yes", "No"};
            String message = "Before showing this pin inside the textual editor we need to save the latest modifications... Do you aggree?";
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, message, 3, options, 0);
            int result = dialog.open();
            if (result != 0) {
                doit = false;
            }
        }
        if (doit) {
            if (isDirty) {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                this.doSave((IProgressMonitor)progressMonitor);
                delay = 2000L;
            }
            UIJob showPinJob = new UIJob("Show selected pin"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    block11: {
                        try {
                            TextSelection textSel;
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IFile file = ((IFileEditorInput)GpioCfgGLSPDiagramEditor.this.getEditorInput()).getFile();
                            if (BOARD_EDITOR_ID.equals(editorId)) {
                                Board board = (Board)pinSetting.eContainer().eContainer();
                                if (board.eResource().getURI().isPlatform()) {
                                    LOGGER.error((Object)("Cannot show file: " + board.eResource().getURI().toString()));
                                } else {
                                    IProject project = GpioCfgGLSPDiagramEditor.this.getProject((EObject)pinSetting);
                                    IPath base = project.getLocation();
                                    String filePath = String.valueOf(base) + File.separator + GpioCfgGLSPDiagramEditor.this.fileName(board.eResource().getURI());
                                    File f = new File(filePath);
                                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                    file = root.getFileForLocation((IPath)new Path(f.getAbsolutePath()));
                                }
                            }
                            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3);
                            ISelectionService selectionService = (ISelectionService)editor.getSite().getService(ISelectionService.class);
                            GpioCfgEditor xtextEditor = (GpioCfgEditor)editor;
                            if (selectionService == null) break block11;
                            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)pinSetting);
                            if (node != null) {
                                int offset = node.getOffset();
                                textSel = new TextSelection((IDocument)xtextEditor.getDocument(), offset, 0);
                                LOGGER.info((Object)("ok: " + String.valueOf(textSel)));
                                editor.getSite().getSelectionProvider().setSelection((ISelection)textSel);
                                break block11;
                            }
                            LOGGER.error((Object)("Cannot find node for :" + pinSetting.getPin().getName()));
                            node = NodeModelUtils.findActualNodeFor((EObject)pinSetting.getPin());
                            if (node != null) {
                                IFile docFile;
                                int offset = node.getOffset();
                                textSel = new TextSelection((IDocument)xtextEditor.getDocument(), offset, 0);
                                if (textSel.getStartLine() >= 0 || (docFile = (IFile)xtextEditor.getDocument().getAdapter(IFile.class)) == null) break block11;
                                try {
                                    String line;
                                    InputStream inputStream = file.getContents();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                                    int lineNumber = 1;
                                    offset = 1;
                                    int charPosition = -1;
                                    while ((line = reader.readLine()) != null && (charPosition = line.indexOf("-> " + pinSetting.getPin().getName())) == -1) {
                                        offset += line.length() + 2;
                                        ++lineNumber;
                                    }
                                    reader.close();
                                    inputStream.close();
                                    if (charPosition != -1) {
                                        LOGGER.info((Object)(pinSetting.getPin().getName() + " found at line " + lineNumber + ", position " + charPosition));
                                        textSel = new TextSelection((IDocument)xtextEditor.getDocument(), offset += charPosition, 0);
                                        LOGGER.info((Object)textSel);
                                        editor.getSite().getSelectionProvider().setSelection((ISelection)textSel);
                                        break block11;
                                    }
                                    LOGGER.error((Object)"String not found");
                                }
                                catch (IOException | CoreException e) {
                                    e.printStackTrace();
                                }
                                break block11;
                            }
                            LOGGER.error((Object)("Cannot find node for :" + pinSetting.getPin().getName()));
                        }
                        catch (PartInitException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            showPinJob.schedule(delay);
        }
    }

    public XtextResource getXtextResourceFromEditor(GpioCfgEditor editor) {
        if (editor != null && editor.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editor.getEditorInput();
            IFile file = fileEditorInput.getFile();
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
            if (resource instanceof XtextResource) {
                return (XtextResource)resource;
            }
        }
        return null;
    }

    private boolean isInputOnly(FunctionRef ref, List<FunctionRef> refs) {
        for (FunctionRef function : refs) {
            if (function.getDirection() != Direction.INPUT || !function.getName().equals((Object)ref.getName())) continue;
            return true;
        }
        return false;
    }

    private MenuItem buildItem(ArrayList<MenuItem> items, PinSetting ps, final Pin pin, FunctionRef ref, Menu parent, final Direction direction) {
        PinProperties config;
        final FunctionRef function = ref;
        String name = function.getName().getName();
        String description = function.getName().getDesc().trim();
        MenuItem menuItem = new MenuItem(parent, 16);
        items.add(menuItem);
        final String pinName = "PIN_" + function.getName().getName();
        String text = "";
        if (description.isEmpty()) {
            text = NLS.bind((String)"{0}", (Object)name);
        } else {
            Object[] bindings = new String[]{name, description};
            text = NLS.bind((String)"{0} ({1})", (Object[])bindings);
        }
        menuItem.setText(text);
        menuItem.setEnabled(true);
        menuItem.setData(KEY_PIN_MENU_FUNCTION, (Object)ref);
        menuItem.setData(KEY_PIN_MENU_DIRECTION, (Object)direction);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Pin alreadyConfiguredPin;
                boolean selection = ((MenuItem)e.getSource()).getSelection();
                if (!selection) {
                    return;
                }
                EMFModelState state = (EMFModelState)GpioCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
                GpioCfgModelState gpiocfgState = (GpioCfgModelState)state;
                PinConfiguration pinConfiguration = gpiocfgState.getPinConfiguration();
                Optional<PinSetting> alreadyDefinedPinSetting = GpioCfgHelper.getAllPinSettings((PinConfiguration)pinConfiguration).stream().filter(it -> it.getConfig().getAlt().getName().equals(function.getName().getName())).findFirst();
                boolean doit = true;
                if (alreadyDefinedPinSetting.isPresent() && !pin.equals((Object)(alreadyConfiguredPin = alreadyDefinedPinSetting.get().getPin()))) {
                    String title = "Function is already defined";
                    String[] options = new String[]{"Confirm", "Cancel"};
                    String message = NLS.bind((String)"The function is already defined...\n\nIt will be removed from PAD ''{0}'' (pin ''{1}'')\n\nDo you confirm ?", (Object)GpioCfgHelper.instance.getPadName(alreadyDefinedPinSetting.get().getPin()), (Object)alreadyDefinedPinSetting.get().getPin().getName());
                    MessageDialog dialog = new MessageDialog(GpioCfgGLSPDiagramEditor.this.getSite().getShell(), title, null, message, 3, options, 0);
                    int result = dialog.open();
                    if (result != 0) {
                        doit = false;
                    }
                }
                if (doit) {
                    GpioCfgGLSPDiagramEditor.this.dispatch((Action)new AssignPinFunctionOperation(pinConfiguration, pin, function, direction, pinName)).thenRun(() -> GpioCfgGLSPDiagramEditor.this.setSelection((ISelection)StructuredSelection.EMPTY));
                }
            }
        });
        if (ps != null && ps.getConfig() != null && (config = ps.getConfig()).getAlt().equals((Object)function.getName()) && GpiocfgValidator.directionsAreCompatible((PinSetting)ps, (Direction)direction, (com.st.stellar.pinmap.gpioCfg.Direction)ps.getConfig().getDirection())) {
            menuItem.setSelection(true);
        }
        return menuItem;
    }

    private void buildParentMenu(Menu menu, Map<Integer, Menu> parentItems, int direction, String directionStr) {
        if (!parentItems.containsKey(direction) && direction != 3) {
            Menu cascadeMenu = new Menu(menu.getParent(), 4);
            MenuItem menuItem = new MenuItem(menu, 64);
            menuItem.setText(directionStr);
            menuItem.setImage(Activator.getDefault().getImage(this.IMAGES().get(direction)));
            menuItem.setMenu(cascadeMenu);
            parentItems.put(direction, cascadeMenu);
        }
    }

    private Pin getSelectedPin(ISelection sel) {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        StructuredSelection structuredSelection = (StructuredSelection)sel;
        Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
        List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        Optional<PinSetting> pinSetting = selectedPinConfigs.stream().filter(PinSetting.class::isInstance).map(PinSetting.class::cast).findFirst();
        if (pinSetting.isEmpty()) {
            Optional<Pin> pin = selectedPinConfigs.stream().filter(Pin.class::isInstance).map(Pin.class::cast).findFirst();
            if (pin.isEmpty()) {
                return null;
            }
            return pin.get();
        }
        return pinSetting.get().getPin();
    }

    private Optional<PinSetting> getSelectedPinSetting(ISelection sel) {
        Optional pin;
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        StructuredSelection structuredSelection = (StructuredSelection)sel;
        Stream<Object> selectedGModelElements = structuredSelection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
        List selectedPinConfigs = selectedGModelElements.map(arg_0 -> ((EMFModelIndex)state.getIndex()).getEObject(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        Stream<Pin> a = selectedPinConfigs.stream().filter(Pin.class::isInstance).map(Pin.class::cast);
        List selectedPins = a.collect(Collectors.toList());
        GpioCfgModelState modelState = (GpioCfgModelState)state;
        PinConfiguration pinConfiguration = modelState.getPinConfiguration();
        EList modules = GpioCfgHelper.getAllModules((PinSettings)pinConfiguration.getPinSetting());
        ArrayList configuredPins = new ArrayList();
        if (modules.size() > 0) {
            for (Module module : modules) {
                configuredPins.addAll(module.getPins());
            }
        }
        if ((pin = selectedPins.stream().findFirst()).isPresent()) {
            return configuredPins.stream().filter(it -> it.getPin().equals(pin.get())).findFirst();
        }
        return Optional.empty();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.outline;
        }
        if (key.equals(IGotoMarker.class)) {
            return key.cast((Object)this);
        }
        return super.getAdapter(key);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        GpioCfgGLSPDiagramEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "com.st.stellar.pinmap.glsp.editor", 0, NLS.bind((String)"Problems encountered in file \"{0}\"", (Object)resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "com.st.stellar.pinmap.glsp.editor", 0, NLS.bind((String)"Problems encountered in file \"{0}\"", (Object)resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "com.st.stellar.pinmap.glsp.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                try {
                    this.markerHelper.updateMarkers((Diagnostic)diagnostic);
                }
                catch (CoreException exception) {
                    LOGGER.error((Object)exception);
                }
            }
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)resourceSet.getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(resourceSet.getLoadOptions());
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Conflict", (String)"There are unsaved changes that conflict with changes made outside the editor.  Do you wish to discard this editor's changes?");
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void updateMicro(Object sel, boolean padSelection) {
        if (this.debouncingJob != null) {
            this.debouncingJob.cancel();
        }
        this.debouncingJob = new DebouncingJob(sel, padSelection);
        this.debouncingJob.schedule(100L);
    }

    public void updateMicro(Object sel, boolean padSelection, boolean resetHighlightStates, List<String> centerOn) {
        block26: {
            Set toDeselect;
            GpioCfgModelState gpiocfgState;
            block27: {
                EMFModelState state;
                block25: {
                    if (resetHighlightStates) {
                        this.resetHighlightedStates();
                    }
                    state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
                    gpiocfgState = (GpioCfgModelState)state;
                    if (!(sel instanceof StructuredSelection)) break block25;
                    StructuredSelection ss = (StructuredSelection)sel;
                    for (Object a : ss.toList()) {
                        this.updateMicro(a, padSelection, false, centerOn);
                    }
                    break block26;
                }
                if (sel instanceof ResetSelection) break block26;
                toDeselect = state.getIndex().allIds();
                if (!(sel instanceof OutlinePin)) break block27;
                OutlinePin outlinepin = (OutlinePin)sel;
                Pin pin = outlinepin.getPin();
                String id = gpiocfgState.getIndex().indexEObject((EObject)pin);
                String pinName = pin.getName();
                boolean found = false;
                List allPins = GpioCfgHelper.getAllPinSettings((PinConfiguration)this.getPinConfiguration());
                for (PinSetting ps : allPins) {
                    if (ps.getPin().getName() == null || !ps.getPin().getName().equals(pinName)) continue;
                    found = true;
                    pin = ps.getPin();
                    id = gpiocfgState.getIndex().indexEObject((EObject)pin);
                    Optional elt2 = gpiocfgState.getIndex().get(id);
                    if (elt2.isPresent()) {
                        centerOn.add(id);
                        if (padSelection) {
                            this.selectedPad((GModelElement)elt2.get());
                            continue;
                        }
                        this.highlightPad((GModelElement)elt2.get());
                        continue;
                    }
                    LOGGER.error((Object)("UpdateMicro: Element with ID " + id + " not found"));
                    Set allIds = state.getIndex().allIds();
                    Optional<GNode> elt = allIds.stream().map(it -> gpiocfgState.getIndex().get(it)).flatMap(Optional::stream).filter(GNode.class::isInstance).map(GNode.class::cast).filter(n -> {
                        if (n.getArgs() != null && n.getArgs().get((Object)"name") != null) {
                            return n.getArgs().get((Object)"name").equals(pinName);
                        }
                        return false;
                    }).findFirst();
                    if (elt.isPresent()) {
                        centerOn.add(id);
                        if (padSelection) {
                            this.selectedPad((GModelElement)elt.get());
                        } else {
                            this.highlightPad((GModelElement)elt.get());
                        }
                    } else {
                        LOGGER.error((Object)("UpdateMicro: Pin with name " + pin.getName() + " not found"));
                    }
                    return;
                }
                if (found) break block26;
                Set allIds = state.getIndex().allIds();
                Optional<GNode> elt = allIds.stream().map(it -> gpiocfgState.getIndex().get(it)).flatMap(Optional::stream).filter(GNode.class::isInstance).map(GNode.class::cast).filter(n -> {
                    if (n.getArgs() != null && n.getArgs().get((Object)"name") != null) {
                        return n.getArgs().get((Object)"name").equals(pinName);
                    }
                    return false;
                }).findFirst();
                if (elt.isPresent()) {
                    centerOn.add(id);
                    if (padSelection) {
                        this.selectedPad((GModelElement)elt.get());
                    } else {
                        this.highlightPad((GModelElement)elt.get());
                    }
                } else {
                    LOGGER.error((Object)("UpdateMicro: Pin with name " + pin.getName() + " not found"));
                }
                break block26;
            }
            if (sel instanceof OutlineFunction) {
                OutlineFunction of = (OutlineFunction)sel;
                Function function = of.getFunction();
                for (String id : toDeselect) {
                    Optional elt = gpiocfgState.getIndex().getEObject(id);
                    if (!elt.isPresent() || !Pin.class.isInstance(elt.get())) continue;
                    Pin pin = (Pin)elt.get();
                    List configurablePins = pin.getPinConfigurations().stream().filter(ConfigurablePin.class::isInstance).map(ConfigurablePin.class::cast).collect(Collectors.toList());
                    for (ConfigurablePin p : configurablePins) {
                        Optional node;
                        List functions = p.getRef().getFunctions().stream().map(it -> it.getName()).collect(Collectors.toList());
                        if (!functions.contains(function) || !(node = gpiocfgState.getIndex().get(id)).isPresent()) continue;
                        centerOn.add(id);
                        this.highlightPad((GModelElement)node.get());
                    }
                }
            } else if (sel instanceof OutlinePeripheral) {
                OutlinePeripheral op = (OutlinePeripheral)sel;
                Peripheral periph = op.getPeripheral();
                for (String id : toDeselect) {
                    Optional elt = gpiocfgState.getIndex().getEObject(id);
                    if (!elt.isPresent() || !Pin.class.isInstance(elt.get())) continue;
                    Pin pin = (Pin)elt.get();
                    List configurablePins = pin.getPinConfigurations().stream().filter(ConfigurablePin.class::isInstance).map(ConfigurablePin.class::cast).collect(Collectors.toList());
                    for (ConfigurablePin p : configurablePins) {
                        Optional node;
                        List pinPeriphs = p.getRef().getFunctions().stream().map(it -> it.getName().getPeripheralRef()).collect(Collectors.toList());
                        if (!pinPeriphs.contains(periph) || !(node = gpiocfgState.getIndex().get(id)).isPresent()) continue;
                        centerOn.add(id);
                        this.highlightPad((GModelElement)node.get());
                    }
                }
            } else if (sel instanceof OutlinePeripheralFamily) {
                OutlinePeripheralFamily fam = (OutlinePeripheralFamily)sel;
                List<OutlinePeripheral> peripherals = fam.getPeripheralList();
                for (OutlinePeripheral periph : peripherals) {
                    for (String id : toDeselect) {
                        Optional elt = gpiocfgState.getIndex().getEObject(id);
                        if (!elt.isPresent() || !Pin.class.isInstance(elt.get())) continue;
                        Pin pin = (Pin)elt.get();
                        List configurablePins = pin.getPinConfigurations().stream().filter(ConfigurablePin.class::isInstance).map(ConfigurablePin.class::cast).collect(Collectors.toList());
                        for (ConfigurablePin p : configurablePins) {
                            Optional node;
                            List pinPeriphs = p.getRef().getFunctions().stream().map(it -> it.getName().getPeripheralRef()).collect(Collectors.toList());
                            if (!pinPeriphs.contains(periph.getPeripheral()) || !(node = gpiocfgState.getIndex().get(id)).isPresent()) continue;
                            centerOn.add(id);
                            this.highlightPad((GModelElement)node.get());
                        }
                    }
                }
            }
        }
    }

    public ISelection getSelection() {
        return this.getDiagram().getSelection();
    }

    protected List<GModelElement> toGModelElementsLabel(List<String> ids, GModelState modelState) {
        List gElements = ids.stream().map(arg_0 -> ((GModelIndex)modelState.getIndex()).get(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        return gElements.stream().map(it -> (GModelElement)it.eContainer()).collect(Collectors.toList());
    }

    public Object getCurrentFamily() {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        GpioCfgModelState gpiocfgState = (GpioCfgModelState)state;
        PinConfiguration pinCfg = gpiocfgState.getPinConfiguration();
        pinCfg.getBoard();
        return null;
    }

    public PinConfiguration getPinConfiguration() {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        GpioCfgModelState gpiocfgState = (GpioCfgModelState)state;
        PinConfiguration pinConfiguration = gpiocfgState.getPinConfiguration();
        return pinConfiguration;
    }

    private void resetHighlightedStates() {
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        Set toDeselect = state.getIndex().allIds();
        toDeselect.stream().map(it -> state.getIndex().get(it)).flatMap(Optional::stream).filter(GNode.class::isInstance).map(GNode.class::cast).forEach(it -> {
            it.getCssClasses().remove((Object)"highlighted");
            it.getCssClasses().remove((Object)"selectedPAD");
        });
    }

    protected void highlightSelectedPin(PinSetting ps) {
        this.resetHighlightedStates();
        if (ps.getPin() == null) {
            return;
        }
        GpioCfgHelper helper = GpioCfgHelper.instance;
        EMFModelState state = (EMFModelState)this.getInjector().getInstance(EMFModelState.class);
        GpioCfgModelState gpiocfgState = (GpioCfgModelState)state;
        PinConfiguration config = gpiocfgState.getPinConfiguration();
        Pin pin = helper.findPin(config, ps.getPin().getName());
        if (pin == null) {
            return;
        }
        String id = state.getIndex().indexEObject((EObject)pin);
        Optional elt = state.getIndex().get(id);
        if (elt.isPresent()) {
            this.selectedPad((GModelElement)elt.get());
            ArrayList<String> centerOn = new ArrayList<String>();
            centerOn.add(state.getIndex().indexEObject((EObject)pin));
            this.getModelStateOnceInitialized().thenAccept(modelState -> this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot())).thenAccept(a -> this.dispatch((Action)new CenterAction(centerOn, true, true)).thenAccept(b -> this.dispatch((Action)new FitToScreenAction("fit", centerOn, 50.0, 1.0, true)))));
        } else {
            LOGGER.info((Object)("Cannot find graphical element for pin '" + ps.getPin().getName() + "'"));
            Stream<Pin> pins = GpioCfgHelper.getAllPinSettings((PinConfiguration)config).stream().map(it -> it.getPin()).filter(i -> i.getName().equals(pin.getName()));
            Optional<Pin> first = pins.findFirst();
            if (first.isPresent()) {
                Pin p = first.get();
                Optional pinElement = gpiocfgState.getModelElement((EObject)p);
                if (pinElement.isPresent()) {
                    LOGGER.info((Object)("found: " + String.valueOf(pinElement)));
                    this.selectedPad((GModelElement)pinElement.get());
                    ArrayList<String> centerOn = new ArrayList<String>();
                    centerOn.add(state.getIndex().indexEObject((EObject)pin));
                    this.getModelStateOnceInitialized().thenAccept(modelState -> this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot())).thenAccept(a -> this.dispatch((Action)new CenterAction(centerOn, true, true)).thenAccept(b -> this.dispatch((Action)new FitToScreenAction("fit", centerOn, 50.0, 1.0, true)))));
                } else {
                    LOGGER.error((Object)("Cannot find: " + p.getName()));
                }
            }
        }
    }

    private void selectedPad(GModelElement elt) {
        if (lastSelectedPad != null) {
            lastSelectedPad.getCssClasses().remove((Object)"selectedPAD");
        }
        elt.getCssClasses().add((Object)"selectedPAD");
        lastSelectedPad = elt;
    }

    private void highlightPad(GModelElement elt) {
        elt.getCssClasses().add((Object)"highlighted");
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (Object listener : this.getListeners()) {
            ISelectionChangedListener selectionChangedListeners = (ISelectionChangedListener)listener;
            UIUtil.asyncExec(() -> selectionChangedListeners.selectionChanged(event));
        }
    }

    public List<OutlinePeripheralFamily> getCategories(PinConfiguration cfg) {
        Set<OutlinePeripheralFamily> peripheralsList = OutlinePeripheralFamily.getPackagePeripheralFamilies(cfg);
        return Collections.unmodifiableList(peripheralsList.stream().toList());
    }

    public List<OutlinePin> getPins(Function function) {
        List<OutlinePeripheralFamily> categories = this.getCategories(this.getPinConfiguration());
        for (OutlinePeripheralFamily cat : categories) {
            List<OutlinePeripheral> peripherals = cat.getPeripheralList();
            for (OutlinePeripheral periph : peripherals) {
                List<OutlineFunction> functions = periph.getFunctionsList();
                for (OutlineFunction f : functions) {
                    if (!function.getName().equals(f.getName())) continue;
                    return f.getPinsList();
                }
            }
        }
        return new ArrayList<OutlinePin>();
    }

    protected GLSPDiagramComposite createGLSPDiagramComposite() {
        return new MyGLSPDiagramComposite(this.getEditorId(), this);
    }

    private CompletableFuture<GModelState> getModelStateOnceInitialized() {
        MyGLSPDiagramComposite diagram = (MyGLSPDiagramComposite)this.getDiagram();
        return diagram.getModelStateOnceInitialized();
    }

    public CompletableFuture<Void> dispatch(Action action) {
        MyGLSPDiagramComposite diagram = (MyGLSPDiagramComposite)this.getDiagram();
        return diagram.dispatch(action);
    }

    public Injector getInjector() {
        return this.getDiagram().getInjector();
    }

    Browser getBrowser() {
        return this.getDiagram().getBrowser();
    }

    class DebouncingJob
    extends UIJob {
        private Object sel;
        private boolean padSelection;

        DebouncingJob(Object sel, boolean padSelection) {
            super("debouncing");
            this.sel = sel;
            this.padSelection = padSelection;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList<String> centerOn = new ArrayList<String>();
            GpioCfgGLSPDiagramEditor.this.updateMicro(this.sel, this.padSelection, true, centerOn);
            EMFModelState state = (EMFModelState)GpioCfgGLSPDiagramEditor.this.getInjector().getInstance(EMFModelState.class);
            if (centerOn.isEmpty()) {
                GpioCfgGLSPDiagramEditor.this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot()));
            } else {
                GpioCfgGLSPDiagramEditor.this.dispatch((Action)new UpdateModelAction((GModelRoot)state.getRoot())).thenAccept(a -> GpioCfgGLSPDiagramEditor.this.dispatch((Action)new CenterAction(centerOn, true, true)).thenAccept(b -> GpioCfgGLSPDiagramEditor.this.dispatch((Action)new FitToScreenAction("fit", centerOn, 50.0, 1.0, true))));
            }
            return Status.OK_STATUS;
        }
    }
}

