/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor;

import com.st.stellar.pinmap.gpiocfg.glsp.editor.GpioCfgGLSPDiagramEditor;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.PreferenceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramComposite;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SelectAction;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class MyGLSPDiagramComposite
extends GLSPDiagramComposite {
    private StructuredSelection overridenCurrentSelection = StructuredSelection.EMPTY;
    private GpioCfgGLSPDiagramEditor editor;

    public MyGLSPDiagramComposite(String editorId, GpioCfgGLSPDiagramEditor editor) {
        super(editorId);
        this.editor = editor;
    }

    public CompletableFuture<GModelState> getModelStateOnceInitialized() {
        return this.onceModelInitialized().thenCompose(initialized -> this.getModelState());
    }

    protected CompletableFuture<Void> dispatch(Action action) {
        return super.dispatch(action);
    }

    public Stream<GModelElement> toGModelElementStream(StructuredSelection selection) {
        return selection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
    }

    public List<GModelElement> toGModelElements(Collection<String> ids, GModelState modelState) {
        return ids.stream().map(arg_0 -> ((GModelIndex)modelState.getIndex()).get(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public ISelection getSelection() {
        return this.overridenCurrentSelection;
    }

    public void updateSelection(SelectAction selectAction) {
        ((CompletableFuture)this.getModelStateOnceInitialized().thenAccept(modelState -> {
            Optional first;
            List selectedIds = selectAction.getSelectedElementsIDs();
            List deselectedIds = selectAction.getDeselectedElementsIDs();
            List<GModelElement> selectedGModelElements = this.toGModelElements(selectedIds, (GModelState)modelState);
            if (selectedGModelElements.size() == 0 && (first = selectedIds.stream().findFirst()).isPresent()) {
                Object id2 = (String)selectedIds.stream().findFirst().get();
                id2 = (String)id2 + "_pin_label";
                ArrayList<String> newIds = new ArrayList<String>();
                newIds.add((String)id2);
                selectedGModelElements = this.toGModelElementsLabel((List<String>)newIds, (GModelState)modelState);
            }
            first = selectedGModelElements.stream().findFirst();
            List<GModelElement> deselectedGModelElements = this.toGModelElements(deselectedIds, (GModelState)modelState);
            List selection = this.toGModelElementStream((StructuredSelection)this.getSelection()).collect(Collectors.toList());
            selection.removeAll(deselectedGModelElements);
            this.addUnique(selectedGModelElements, selection);
            if (first.isPresent()) {
                if (((GModelElement)first.get()).getType().equals("package")) {
                    this.overridenCurrentSelection = StructuredSelection.EMPTY;
                } else {
                    this.overridenCurrentSelection = new StructuredSelection(first.get());
                    this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.overridenCurrentSelection));
                }
            } else {
                this.overridenCurrentSelection = StructuredSelection.EMPTY;
                this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.overridenCurrentSelection));
            }
        })).thenRun(() -> new UIJob("setFocus"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                GpioCfgModelState gpiocfgState;
                Optional legendGmodel;
                IWorkbenchPage page = MyGLSPDiagramComposite.this.editor.getEditorSite().getPage();
                if (page != null) {
                    page.activate((IWorkbenchPart)MyGLSPDiagramComposite.this.editor);
                }
                if ((legendGmodel = (gpiocfgState = (GpioCfgModelState)MyGLSPDiagramComposite.this.getInjector().getInstance(EMFModelState.class)).getIndex().get("legend")).isPresent()) {
                    String legendState = MyGLSPDiagramComposite.this.getCurrentLegendState(gpiocfgState);
                    ((GModelElement)legendGmodel.get()).getArgs().put((Object)"state", (Object)legendState);
                }
                return Status.OK_STATUS;
            }
        }.schedule());
    }

    protected List<GModelElement> toGModelElementsLabel(List<String> ids, GModelState modelState) {
        List gElements = ids.stream().map(arg_0 -> ((GModelIndex)modelState.getIndex()).get(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
        return gElements.stream().map(it -> (GModelElement)it.eContainer()).collect(Collectors.toList());
    }

    private String getCurrentLegendState(GpioCfgModelState modelState) {
        String key = modelState.getPinConfiguration().eResource().getURI().path();
        return PreferenceManager.getPreference((String)key, (String)"false");
    }

    public GpioCfgGLSPDiagramEditor getEditor() {
        return this.editor;
    }
}

