/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class RenameDialog
extends SelectionStatusDialog {
    private ArrayList<String> oldNames;
    private String oldName;
    private String newName;
    private Text text;
    private IStatus status;
    private boolean isCaseSensitive;

    public RenameDialog(Shell shell, String oldName) {
        super(shell);
        this.isCaseSensitive = false;
        this.initialize();
        this.setOldName(oldName);
    }

    public RenameDialog(Shell shell, boolean isCaseSensitive, String[] names, String oldName) {
        super(shell);
        this.isCaseSensitive = isCaseSensitive;
        this.initialize();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                this.addOldName(names[i]);
            }
        }
        this.setOldName(oldName);
    }

    public void initialize() {
        this.oldNames = new ArrayList();
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
    }

    public void addOldName(String oldName) {
        if (!this.oldNames.contains(oldName)) {
            this.oldNames.add(oldName);
        }
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
        if (this.text != null) {
            this.text.setText(oldName);
        }
        this.newName = oldName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 9;
        layout.marginHeight = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Rename pin");
        this.text = new Text(container, 2052);
        this.text.addModifyListener(e -> this.textChanged(this.text.getText(), true));
        gd = new GridData(768);
        gd.widthHint = 200;
        this.text.setLayoutData((Object)gd);
        RenameDialog.applyDialogFont((Control)container);
        return container;
    }

    public int open() {
        this.text.setText(this.oldName);
        this.text.selectAll();
        this.setOkStatus();
        this.textChanged(this.oldName, false);
        return super.open();
    }

    private void textChanged(String text, boolean setStatus) {
        Button okButton = this.getButton(0);
        for (int i = 0; i < this.oldNames.size(); ++i) {
            if ((!this.isCaseSensitive || !text.equals(this.oldNames.get(i))) && (this.isCaseSensitive || !text.equalsIgnoreCase(this.oldNames.get(i).toString()))) continue;
            if (setStatus) {
                this.setErrorStatus("You must enter a different name");
            }
            okButton.setEnabled(false);
            return;
        }
        if (text.indexOf(32) != -1) {
            if (setStatus) {
                this.setErrorStatus("Name must not contain any spaces");
            }
            okButton.setEnabled(false);
            return;
        }
        if (text.length() == 0) {
            if (setStatus) {
                this.setErrorStatus("You must enter a different name");
            }
            okButton.setEnabled(false);
            return;
        }
        okButton.setEnabled(true);
        if (setStatus) {
            this.setOkStatus();
        }
    }

    private void setErrorStatus(String errorMessage) {
        this.status = new Status(4, "com.st.stellar.pinmap.pincfg.glsp.editor", 4, errorMessage, null);
        this.updateStatus(this.status);
    }

    private void setOkStatus() {
        this.status = new Status(0, "com.st.stellar.pinmap.pincfg.glsp.editor", 0, "", null);
        this.updateStatus(this.status);
    }

    public String getNewName() {
        return this.newName;
    }

    protected void okPressed() {
        this.newName = this.text.getText();
        super.okPressed();
    }

    protected void computeResult() {
    }

    public void setTitle(String title) {
        this.getShell().setText(title);
    }
}

