/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline;

import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.Activator;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.GpioCfgGLSPDiagramEditor;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.OutlinePADsFilter;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.OutlineStringFilter;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.StellarObjectCache;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.helpers.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class OutlineFunctionsDecorator
implements ILabelDecorator {
    private GpioCfgGLSPDiagramEditor editor;
    private OutlinePADsFilter padsFilter;
    private OutlineStringFilter stringFilter;
    final TreeViewer viewer;
    private static Map<String, Image> IMAGES = new StellarObjectCache<Image>(200);

    public OutlineFunctionsDecorator(TreeViewer viewer, GpioCfgGLSPDiagramEditor editor, OutlinePADsFilter padsFilter, OutlineStringFilter stringFilter) {
        this.viewer = viewer;
        this.editor = editor;
        this.padsFilter = padsFilter;
        this.stringFilter = stringFilter;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        Image img = null;
        if (image == null) {
            return null;
        }
        img = image;
        Pair<Boolean, PinSetting> pair = new Pair<Boolean, PinSetting>((Object)false, null);
        if (element instanceof Function) {
            pair = this.shouldDecorate((OutlineFunction)element);
        } else if (element instanceof Peripheral) {
            pair = this.shouldDecorate((OutlinePeripheral)element);
        } else if (element instanceof OutlinePeripheralFamily) {
            pair = this.shouldDecorate((OutlinePeripheralFamily)element);
        } else if (element instanceof OutlinePin) {
            pair = this.shouldDecorate((OutlinePin)element);
        }
        boolean decorate = (Boolean)pair.getKey();
        if (decorate) {
            if (this.pinHasError((PinSetting)pair.getValue())) {
                img = this.decorateError(img);
            }
            img = this.decorateConfigured(img);
        }
        return img;
    }

    public Pair<Boolean, PinSetting> shouldDecorate(Object element) {
        if (element instanceof OutlineFunction) {
            return this.shouldDecorate((OutlineFunction)element);
        }
        if (element instanceof OutlinePeripheral) {
            return this.shouldDecorate((OutlinePeripheral)element);
        }
        if (element instanceof OutlinePeripheralFamily) {
            return this.shouldDecorate((OutlinePeripheralFamily)element);
        }
        if (element instanceof OutlinePin) {
            return this.shouldDecorate((OutlinePin)element);
        }
        return new Pair((Object)false, null);
    }

    private Pair<Boolean, PinSetting> shouldDecorate(OutlineFunction element) {
        OutlineFunction function = element;
        boolean decorate = false;
        PinConfiguration pinConfiguration = this.editor.getPinConfiguration();
        List pinSettings = GpioCfgHelper.instance.getConfiguredPins(pinConfiguration.getPinSetting());
        PinSetting ps = null;
        List<OutlinePin> famPins = function.getPinsList();
        for (OutlinePin p : famPins) {
            PinSetting config;
            Optional<PinSetting> configuredPins;
            if (!this.padsFilter.select((Viewer)this.viewer, null, p.getPin()) || !this.padsFilter.validPin(p.getPin()) || !(configuredPins = pinSettings.stream().filter(it -> it.getPin().getName().equals(p.getName())).findFirst()).isPresent() || !(config = configuredPins.get()).getConfig().getAlt().getName().equals(function.getName())) continue;
            decorate = true;
            ps = config;
            break;
        }
        return new Pair((Object)decorate, ps);
    }

    private Pair<Boolean, PinSetting> shouldDecorate(OutlinePeripheral element) {
        OutlinePeripheral peripheral = element;
        boolean decorate = false;
        PinConfiguration pinConfiguration = this.editor.getPinConfiguration();
        Package pack = GpioCfgHelper.instance.getPack(pinConfiguration);
        PinSetting ps = null;
        List pinSettings = GpioCfgHelper.instance.getConfiguredPins(pinConfiguration.getPinSetting());
        List<OutlineFunction> functions = peripheral.getFunctionsList();
        block0: for (OutlineFunction fct : functions) {
            List<OutlinePin> pins = fct.getPinsList();
            for (OutlinePin p : pins) {
                Optional<PinSetting> configuredPins;
                if (!this.padsFilter.select((Viewer)this.viewer, null, p.getPin()) || !this.padsFilter.validPin(p.getPin()) || !(configuredPins = pinSettings.stream().filter(it -> it.getPin().getName().equals(p.getPin().getName())).findFirst()).isPresent()) continue;
                PinSetting config = configuredPins.get();
                Peripheral configuredPeripheral = config.getConfig().getAlt().getPeripheralRef();
                if (!peripheral.getName().equals(configuredPeripheral.getName())) continue;
                decorate = true;
                ps = config;
                continue block0;
            }
        }
        return new Pair((Object)decorate, ps);
    }

    private Pair<Boolean, PinSetting> shouldDecorate(OutlinePeripheralFamily element) {
        boolean decorate = false;
        OutlinePeripheralFamily fam = element;
        EMFModelState state = (EMFModelState)this.editor.getInjector().getInstance(EMFModelState.class);
        GpioCfgModelState pincfgState = (GpioCfgModelState)state;
        PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
        PinSetting ps = null;
        List pinSettings = GpioCfgHelper.instance.getConfiguredPins(pinConfiguration.getPinSetting());
        List<OutlinePeripheral> peripherals = fam.getPeripheralList();
        for (OutlinePeripheral periph : peripherals) {
            List<OutlineFunction> functions = periph.getFunctionsList();
            block1: for (OutlineFunction function : functions) {
                List<OutlinePin> pins = function.getPinsList();
                for (OutlinePin p : pins) {
                    Optional<PinSetting> configuredPins;
                    if (!this.padsFilter.select((Viewer)this.viewer, null, p.getPin()) || !(configuredPins = pinSettings.stream().filter(it -> it.getPin().getName().equals(p.getName())).findFirst()).isPresent()) continue;
                    PinSetting config = configuredPins.get();
                    Peripheral configuredPeripheral = config.getConfig().getAlt().getPeripheralRef();
                    if (!fam.getPeripheralList().stream().filter(it -> it.getName().equals(configuredPeripheral.getName())).findFirst().isPresent()) continue;
                    decorate = true;
                    ps = config;
                    continue block1;
                }
            }
        }
        Pair pair = new Pair((Object)decorate, ps);
        return pair;
    }

    private Pair<Boolean, PinSetting> shouldDecorate(OutlinePin element) {
        OutlinePin outlinePin = element;
        Pin pin = outlinePin.getPin();
        PinSetting ps = null;
        Function function = outlinePin.getParent().getFunction();
        boolean decorate = false;
        EMFModelState state = (EMFModelState)this.editor.getInjector().getInstance(EMFModelState.class);
        GpioCfgModelState pincfgState = (GpioCfgModelState)state;
        PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
        Package pack = GpioCfgHelper.instance.getPack(pinConfiguration);
        List pinSettings = GpioCfgHelper.instance.getConfiguredPins(pinConfiguration.getPinSetting());
        EList famPins = pack.getPins();
        for (Pin p : famPins) {
            PinSetting config;
            Optional<PinSetting> configuredPins;
            if (!this.padsFilter.select((Viewer)this.viewer, null, p) || !this.padsFilter.validPin(p) || !(configuredPins = pinSettings.stream().filter(it -> it.getPin().equals((Object)p)).findFirst()).isPresent() || !pin.equals((Object)(config = configuredPins.get()).getPin()) || !function.equals((Object)config.getConfig().getAlt())) continue;
            ps = config;
            decorate = true;
            break;
        }
        Pair pair = new Pair((Object)decorate, ps);
        return pair;
    }

    private Image decorateConfigured(Image image) {
        return image;
    }

    private Image decorateError(Image image) {
        String imageStr = image.toString() + "_error";
        Image img = IMAGES.get(imageStr);
        if (img == null) {
            img = new DecorationOverlayIcon(image, Activator.getDefault().getImageDescriptor("image.error"), 2).createImage();
            IMAGES.put(imageStr, img);
        }
        return img;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    private boolean pinHasError(PinSetting pin) {
        boolean status;
        Diagnostic error = Diagnostician.INSTANCE.validate((EObject)pin);
        boolean bl = status = error.getSeverity() != 0;
        if (!status) {
            EMFModelState state = (EMFModelState)this.editor.getInjector().getInstance(EMFModelState.class);
            GpioCfgModelState pincfgState = (GpioCfgModelState)state;
            PinConfiguration pinConfiguration = pincfgState.getPinConfiguration();
            error = Diagnostician.INSTANCE.validate((EObject)pinConfiguration);
            List<FeatureBasedDiagnostic> errors = error.getChildren().stream().filter(FeatureBasedDiagnostic.class::isInstance).map(FeatureBasedDiagnostic.class::cast).toList();
            for (FeatureBasedDiagnostic f : errors) {
                EObject o = f.getSourceEObject();
                if (!EcoreUtil.isAncestor((EObject)pin, (EObject)o)) continue;
                status = true;
                break;
            }
        }
        return status;
    }

    public GpioCfgGLSPDiagramEditor getEditor() {
        return this.editor;
    }
}

