/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline;

import com.google.inject.Inject;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpioCfg.Board;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSetting;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.Activator;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.OutlineFunctionsDecorator;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.gpiocfg.glsp.server.model.GpioCfgModelState;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import com.st.stellar.pinmap.helpers.Pair;
import java.util.List;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class OutlineFunctionsLabelProvider
extends CellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final OutlineFunctionsDecorator decorator;
    private PinConfiguration pinConfiguration = null;
    private static Font font = new Font((Device)Display.getCurrent(), new FontData("Arial", 10, 1));
    private static Font boardFont = new Font((Device)Display.getCurrent(), new FontData("Arial", 10, 0));
    private static Font boardBoldFont = new Font((Device)Display.getCurrent(), new FontData("Arial", 10, 1));
    private static Color boardColor = new Color(231, 1, 126, 1);
    private static Font configFont = new Font((Device)Display.getCurrent(), new FontData("Arial", 10, 0));
    private static Font configBoldFont = new Font((Device)Display.getCurrent(), new FontData("Arial", 10, 1));
    private static Color configColor = new Color(65, 161, 101, 1);
    private static StyledString.Styler boldStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = font;
        }
    };
    private static StyledString.Styler boardStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = boardFont;
            textStyle.foreground = boardColor;
        }
    };
    private static StyledString.Styler configStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = configFont;
            textStyle.foreground = configColor;
        }
    };
    private static StyledString.Styler boardBoldStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = boardBoldFont;
            textStyle.foreground = boardColor;
        }
    };
    private static StyledString.Styler configBoldStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = configBoldFont;
            textStyle.foreground = configColor;
        }
    };
    @Inject
    GpioCfgHelper helper;

    public OutlineFunctionsLabelProvider(OutlineFunctionsDecorator outlineDecorator) {
        this.decorator = outlineDecorator;
    }

    private PinConfiguration getPinConfiguration() {
        if (this.pinConfiguration == null) {
            try {
                EMFModelState state = (EMFModelState)this.decorator.getEditor().getInjector().getInstance(EMFModelState.class);
                GpioCfgModelState pincfgState = (GpioCfgModelState)state;
                this.pinConfiguration = pincfgState.getPinConfiguration();
                return this.pinConfiguration;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return this.pinConfiguration;
    }

    public String getText(Object element) {
        this.helper = GpioCfgHelper.instance;
        if (element instanceof OutlinePeripheralFamily) {
            OutlinePeripheralFamily fam = (OutlinePeripheralFamily)element;
            int size = fam.getPeripheralList().size();
            if (size > 1) {
                return fam.getName() + " (" + size + ")";
            }
            return fam.getName();
        }
        if (element instanceof OutlinePeripheral) {
            return ((OutlinePeripheral)element).getName();
        }
        if (element instanceof OutlineFunction) {
            OutlineFunction fct = (OutlineFunction)element;
            return fct.getName();
        }
        if (element instanceof OutlinePin) {
            Pair<Boolean, PinSetting> shouldDecorate = this.decorator.shouldDecorate(element);
            OutlinePin pin = (OutlinePin)element;
            String padName = this.helper.getPadName(pin.getPin());
            String fct = pin.getParent().getName();
            List pads = this.helper.getConfiguredPADs(this.getPinConfiguration());
            Object functionStr = "";
            for (Pair pair : pads) {
                Configuration pad = (Configuration)pair.getKey();
                String otherFct = ((Function)pair.getValue()).getName();
                if (!pad.getLabel().equals(this.helper.getPadName(pin.getPin())) || otherFct.equals(fct)) continue;
                functionStr = " assigned to " + otherFct;
            }
            if (((Boolean)shouldDecorate.getKey()).booleanValue()) {
                return "Assigned on " + pin.getName() + (String)functionStr;
            }
            return padName + " on " + pin.getName() + (String)functionStr;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof OutlinePeripheralFamily) {
            return Activator.getDefault().getImage("image.peripheral");
        }
        if (element instanceof OutlinePeripheral) {
            return Activator.getDefault().getImage("image.peripheral");
        }
        if (element instanceof OutlineFunction) {
            return Activator.getDefault().getImage("image.functions");
        }
        if (element instanceof OutlinePin) {
            return Activator.getDefault().getImage("image.pin");
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void update(ViewerCell cell) {
    }

    public String getToolTipText(Object element) {
        if (element instanceof OutlinePeripheralFamily) {
            return ((OutlinePeripheralFamily)element).getName();
        }
        if (element instanceof OutlinePeripheral) {
            return ((OutlinePeripheral)element).getPeripheral().getDesc();
        }
        if (element instanceof OutlineFunction) {
            return ((OutlineFunction)element).getFunction().getDesc();
        }
        if (element instanceof OutlinePin) {
            return ((OutlinePin)element).getName();
        }
        return super.getToolTipText(element);
    }

    private boolean isBoardPin(PinSetting pin) {
        if (pin == null) {
            return false;
        }
        return pin.eContainer().eContainer() instanceof Board;
    }

    public StyledString getStyledText(Object element) {
        String txt = this.getText(element);
        StyledString sstr = new StyledString(txt == null ? "" : txt);
        Pair<Boolean, PinSetting> pair = this.decorator.shouldDecorate(element);
        if (((Boolean)pair.getKey()).booleanValue()) {
            if (element instanceof OutlinePin) {
                OutlinePin pin = (OutlinePin)element;
                PinSetting ps = pin.getPinSetting();
                if (this.isBoardPin(ps)) {
                    sstr.setStyle(0, sstr.length(), boardBoldStyler);
                } else {
                    sstr.setStyle(0, sstr.length(), configBoldStyler);
                }
            } else {
                sstr.setStyle(0, sstr.length(), boldStyler);
            }
        } else if (txt.contains(" assigned to ") && element instanceof OutlinePin) {
            OutlinePin pin = (OutlinePin)element;
            PinSetting ps = pin.getPinSetting();
            if (this.isBoardPin(ps)) {
                sstr.setStyle(0, sstr.length(), boardStyler);
            } else {
                sstr.setStyle(0, sstr.length(), configStyler);
            }
        }
        return sstr;
    }
}

