/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline;

import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class OutlinePADsFilter
extends ViewerFilter {
    String filterString = "";
    int filteredItemsCount = 0;

    public void setFilterString(String filterString) {
        this.filterString = filterString;
        this.filteredItemsCount = 0;
    }

    public int getFilteredItemsCount() {
        return this.filteredItemsCount;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString.length() < 1) {
            return true;
        }
        if (element instanceof OutlineFunction) {
            OutlineFunction function = (OutlineFunction)element;
            List<OutlinePin> pins = function.getPinsList();
            boolean valid = false;
            for (int j = 0; j < pins.size() && !valid; ++j) {
                OutlinePin pin = pins.get(j);
                valid = this.validPin(pin.getPin());
            }
            if (valid) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        if (element instanceof OutlinePeripheral) {
            OutlinePeripheral peripheral = (OutlinePeripheral)element;
            List<OutlineFunction> functions = peripheral.getFunctionsList();
            boolean valid = false;
            for (int i = 0; i < functions.size() && !valid; ++i) {
                OutlineFunction function = functions.get(i);
                List<OutlinePin> pins = function.getPinsList();
                for (int j = 0; j < pins.size() && !valid; ++j) {
                    OutlinePin pin = pins.get(j);
                    if (!this.validPin(pin.getPin())) continue;
                    valid = true;
                }
            }
            if (valid) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        if (element instanceof OutlinePeripheralFamily) {
            OutlinePeripheralFamily fam = (OutlinePeripheralFamily)element;
            List<OutlinePeripheral> peripherals = fam.getPeripheralList();
            boolean valid = false;
            for (OutlinePeripheral peripheral : peripherals) {
                List<OutlineFunction> functions = peripheral.getFunctionsList();
                Iterator<OutlineFunction> iter = functions.iterator();
                while (iter.hasNext() && !valid) {
                    OutlineFunction function = iter.next();
                    List<OutlinePin> pins = function.getPinsList();
                    Iterator<OutlinePin> iterPin = pins.iterator();
                    while (iterPin.hasNext() && !valid) {
                        OutlinePin pin = iterPin.next();
                        if (!this.validPin(pin.getPin())) continue;
                        valid = true;
                    }
                }
                if (!valid) continue;
                ++this.filteredItemsCount;
            }
            return valid;
        }
        if (element instanceof OutlinePin) {
            OutlinePin op = (OutlinePin)element;
            Pin pin = op.getPin();
            boolean valid = this.validPin(pin);
            if (valid) {
                ++this.filteredItemsCount;
            }
            return valid;
        }
        return true;
    }

    public boolean validPin(Pin pin) {
        if (this.filterString.length() < 1) {
            return true;
        }
        String pad = this.filterString.toLowerCase(Locale.ENGLISH).replaceFirst("^p", "");
        pad = pad.replace("[", "");
        pad = pad.replace("]", "");
        pad = pad.replace(".*", "");
        pad = pad.replace("*", "");
        String patPad = "^" + pad + "$";
        Pattern pattern = Pattern.compile(patPad);
        String padLabel = GpioCfgHelper.instance.getPadName(pin).toLowerCase(Locale.ENGLISH).replaceFirst("^p", "");
        padLabel = padLabel.replace("[", "");
        padLabel = padLabel.replace("]", "");
        Matcher matcher = pattern.matcher(padLabel);
        return matcher.find();
    }
}

