/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data;

import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpioCfg.PinSettings;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePin;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OutlineFunction {
    private Function function;
    private OutlinePeripheral peripheral;
    private Set<OutlinePin> pins;

    public OutlineFunction(OutlinePeripheral periph, Function function) {
        this.function = function;
        this.peripheral = periph;
        this.pins = null;
    }

    public String getName() {
        return this.function.getName();
    }

    public OutlinePeripheral getParent() {
        return this.peripheral;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean addPin(OutlinePin pin) {
        return this.pins.add(pin);
    }

    public List<OutlinePin> getPinsList() {
        if (this.pins == null) {
            this.pins = new HashSet<OutlinePin>();
            PinConfiguration pinConfiguration = this.getParent().getParent().getPinConfiguration();
            GpioCfgHelper.getPinsForFunction((PinSettings)pinConfiguration.getPinSetting(), (Function)this.function).stream().map(it -> this.addPin(new OutlinePin(this, (Pin)it))).toList();
        }
        return Collections.unmodifiableList(this.pins.stream().toList());
    }

    public void dispose() {
        if (this.pins != null) {
            this.pins.clear();
            this.pins = null;
        }
    }
}

