/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data;

import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlineFunction;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheralFamily;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OutlinePeripheral {
    private Peripheral peripheral;
    private Set<OutlineFunction> functions;
    private OutlinePeripheralFamily fam;

    public OutlinePeripheral(OutlinePeripheralFamily fam, Peripheral periph) {
        this.peripheral = periph;
        this.fam = fam;
        this.functions = null;
    }

    public String getName() {
        return this.peripheral.getName();
    }

    public OutlinePeripheralFamily getParent() {
        return this.fam;
    }

    public Peripheral getPeripheral() {
        return this.peripheral;
    }

    public boolean addFunction(OutlineFunction fct) {
        return this.functions.add(fct);
    }

    public List<OutlineFunction> getFunctionsList() {
        if (this.functions == null) {
            this.functions = new HashSet<OutlineFunction>();
            PinConfiguration pinConfiguration = this.getParent().getPinConfiguration();
            List functionsList = GpioCfgHelper.instance.getFunctionForPeripheral(pinConfiguration, this.getPeripheral());
            functionsList.stream().forEach(it -> this.addFunction(new OutlineFunction(this, (Function)it)));
        }
        return Collections.unmodifiableList(this.functions.stream().toList());
    }

    public void dispose() {
        if (this.functions != null) {
            for (OutlineFunction f : this.functions) {
                f.dispose();
            }
            this.functions.clear();
            this.functions = null;
        }
    }
}

