/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data;

import com.google.common.collect.Iterables;
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin;
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration;
import com.st.stellar.pinmap.gpio.gpioDsl.Family;
import com.st.stellar.pinmap.gpio.gpioDsl.Function;
import com.st.stellar.pinmap.gpio.gpioDsl.FunctionRef;
import com.st.stellar.pinmap.gpio.gpioDsl.Package;
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral;
import com.st.stellar.pinmap.gpio.gpioDsl.Pin;
import com.st.stellar.pinmap.gpioCfg.PinConfiguration;
import com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data.OutlinePeripheral;
import com.st.stellar.pinmap.helpers.GpioCfgHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class OutlinePeripheralFamily {
    private String name;
    private Set<OutlinePeripheral> peripherals;
    private PinConfiguration pinConfiguration;

    public OutlinePeripheralFamily(PinConfiguration cfg, String name) {
        this.name = name;
        this.peripherals = null;
        this.pinConfiguration = cfg;
    }

    public List<Function> getFunctionForPeripheral(OutlinePeripheralFamily peripheralFam) {
        List functions;
        List _xblockexpression = null;
        Family family = GpioCfgHelper.instance.getFamily(this.pinConfiguration);
        Functions.Function1 _function = it -> it.getPeripheralRef() != null && it.getPeripheralRef().getLabel().equals(peripheralFam);
        _xblockexpression = functions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)family.getFunctions(), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static List<Peripheral> getPeripherals(OutlinePeripheralFamily peripheralFam) {
        List _xblockexpression = null;
        Package pckg = peripheralFam.getPackage();
        HashSet<Peripheral> peripherals = new HashSet<Peripheral>();
        EObject _eContainer = pckg.eContainer();
        Family family = (Family)_eContainer;
        EList configurations = family.getConfigurations();
        for (Configuration configuration : configurations) {
            EList _functions = configuration.getFunctions();
            for (FunctionRef fct : _functions) {
                boolean _equals = fct.getName().getPeripheralRef().getLabel().equals(peripheralFam.name);
                if (!_equals) continue;
                peripherals.add(fct.getName().getPeripheralRef());
            }
        }
        _xblockexpression = IterableExtensions.toList(peripherals);
        return _xblockexpression;
    }

    public String getName() {
        return this.name;
    }

    public Package getPackage() {
        return GpioCfgHelper.instance.getPack(this.pinConfiguration);
    }

    public PinConfiguration getPinConfiguration() {
        return this.pinConfiguration;
    }

    public boolean addPeripheral(OutlinePeripheral periph) {
        return this.peripherals.add(periph);
    }

    public List<OutlinePeripheral> getPeripheralList() {
        if (this.peripherals == null) {
            HashSet<OutlinePeripheral> _hashSet = new HashSet<OutlinePeripheral>();
            this.peripherals = _hashSet;
            List<Peripheral> peripheralList = this.getPackagePeripherals(this.getPackage(), this);
            Predicate<Peripheral> _function = it -> it.getLabel().equals(this.name);
            Consumer<Peripheral> _function_1 = it -> {
                OutlinePeripheral _outlinePeripheral = new OutlinePeripheral(this, (Peripheral)it);
                this.addPeripheral(_outlinePeripheral);
            };
            peripheralList.stream().filter(_function).forEach(_function_1);
        }
        return Collections.unmodifiableList(this.peripherals.stream().toList());
    }

    public static Set<OutlinePeripheralFamily> getPackagePeripheralFamilies(PinConfiguration cfg) {
        Set _xblockexpression = null;
        HashSet<String> peripheralSet = new HashSet<String>();
        Package pack = GpioCfgHelper.instance.getPack(cfg);
        if (pack != null) {
            EList _pins = pack.getPins();
            for (Pin packagePin : _pins) {
                Iterable configurablePins = Iterables.filter((Iterable)packagePin.getPinConfigurations(), ConfigurablePin.class);
                for (ConfigurablePin pinConfig : configurablePins) {
                    Configuration ref = pinConfig.getRef();
                    EList _functions = ref.getFunctions();
                    for (FunctionRef f : _functions) {
                        Peripheral _peripheralRef = f.getName().getPeripheralRef();
                        boolean _tripleNotEquals = _peripheralRef != null;
                        if (!_tripleNotEquals) continue;
                        peripheralSet.add(f.getName().getPeripheralRef().getLabel());
                    }
                }
            }
        }
        Functions.Function1 _function = it -> new OutlinePeripheralFamily(cfg, (String)it);
        _xblockexpression = IterableExtensions.toSet((Iterable)ListExtensions.map((List)IterableExtensions.sort(peripheralSet), (Functions.Function1)_function));
        return _xblockexpression;
    }

    public List<Function> getFunctions(Configuration config, Peripheral periph) {
        ArrayList _xblockexpression = null;
        ArrayList list = CollectionLiterals.newArrayList();
        EList functions = config.getFunctions();
        Functions.Function1 _function = it -> it.getName().getPeripheralRef() != null && it.getName().getPeripheralRef().getName().equals(periph.getName());
        Functions.Function1 _function_1 = it -> it.getName();
        Iterables.addAll((Collection)list, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)functions, (Functions.Function1)_function), (Functions.Function1)_function_1));
        _xblockexpression = list;
        return _xblockexpression;
    }

    public List<Peripheral> getPackagePeripherals(Package pack, OutlinePeripheralFamily displayName) {
        if (pack == null) {
            return CollectionLiterals.newArrayList();
        }
        HashMap functionsMap = new HashMap();
        HashSet<Peripheral> peripheralNameSet = new HashSet<Peripheral>();
        EList _pins = pack.getPins();
        for (Pin pin : _pins) {
            Iterable _filter = Iterables.filter((Iterable)pin.getPinConfigurations(), ConfigurablePin.class);
            for (ConfigurablePin cfg : _filter) {
                EList _functions = cfg.getRef().getFunctions();
                for (FunctionRef fctref : _functions) {
                    String periphName = fctref.getName().getPeripheralRef().getName();
                    String periphDisplayName = fctref.getName().getPeripheralRef().getLabel();
                    HashSet<String> funcList = (HashSet<String>)functionsMap.get(periphName);
                    if (funcList == null) {
                        HashSet<String> _hashSet;
                        funcList = _hashSet = new HashSet<String>();
                        functionsMap.put(periphName, funcList);
                    }
                    List<Function> validFunctions = this.getFunctions(cfg.getRef(), fctref.getName().getPeripheralRef());
                    for (Function f : validFunctions) {
                        boolean _equals = displayName.name.equals(periphDisplayName);
                        if (!_equals) continue;
                        funcList.add(f.getName());
                    }
                    int _size = validFunctions.size();
                    boolean _greaterThan = _size > 0;
                    if (!_greaterThan) continue;
                    peripheralNameSet.add(fctref.getName().getPeripheralRef());
                }
            }
        }
        return IterableExtensions.toList(peripheralNameSet);
    }

    public Set<OutlinePeripheral> dispose() {
        Object _xifexpression = null;
        if (this.peripherals != null) {
            Object _xblockexpression = null;
            for (OutlinePeripheral f : this.peripherals) {
                f.dispose();
            }
            this.peripherals.clear();
            this.peripherals = null;
            _xifexpression = _xblockexpression = null;
        }
        return _xifexpression;
    }
}

