package com.st.stellar.pinmap.gpiocfg.glsp.editor.outline.data


import java.util.Collections
import java.util.HashMap
import java.util.HashSet
import java.util.List
import java.util.Set
import com.st.stellar.pinmap.gpioCfg.PinConfiguration
import com.st.stellar.pinmap.gpio.gpioDsl.Function
import com.st.stellar.pinmap.gpio.gpioDsl.Package
import com.st.stellar.pinmap.helpers.GpioCfgHelper
import com.st.stellar.pinmap.gpio.gpioDsl.Peripheral
import com.st.stellar.pinmap.gpio.gpioDsl.Family
import com.st.stellar.pinmap.gpio.gpioDsl.Configuration
import com.st.stellar.pinmap.gpio.gpioDsl.ConfigurablePin

class OutlinePeripheralFamily {

	String name
	Set<OutlinePeripheral> peripherals
	PinConfiguration pinConfiguration

	new(PinConfiguration cfg, String name) {
		this.name = name;
		this.peripherals = null;
		this.pinConfiguration = cfg;
	}

	def List<Function> getFunctionForPeripheral(OutlinePeripheralFamily peripheralFam) {
		val family = GpioCfgHelper.instance.getFamily(pinConfiguration)
		val functions = family.functions.filter [ it |
			it.peripheralRef !== null && it.peripheralRef.label.equals(peripheralFam)
		].toList
		functions
	}

	static def List<Peripheral> getPeripherals(OutlinePeripheralFamily peripheralFam) {
		val pckg = peripheralFam.package
		// val configuredPins = settings.allModules.flatMap(m|m.pins)
		val peripherals = new HashSet<Peripheral>()
		val family = pckg.eContainer as Family
		val configurations = family.configurations
		for (configuration : configurations) {
			for (fct : configuration.functions) {
				if (fct.name.peripheralRef.label.equals(peripheralFam.name)) {
					peripherals.add(fct.name.peripheralRef);
				}
			}
		}
		peripherals.toList
	}

	def getName() {
		name
	}

	def getPackage() {
		GpioCfgHelper.instance.getPack(pinConfiguration)
	}
	
	def getPinConfiguration() {
		pinConfiguration
	}

	def boolean addPeripheral(OutlinePeripheral periph) {
		return peripherals.add(periph);
	}

	def getPeripheralList() {
		if (peripherals === null) {
			peripherals = new HashSet<OutlinePeripheral>()
			val peripheralList = getPackagePeripherals(getPackage(), this);
			peripheralList.stream.filter(it | it.getLabel().equals(name)).forEach(it | addPeripheral(new OutlinePeripheral(this, it)));
		}
		return Collections.unmodifiableList(peripherals.stream().toList());
	}

	static def getPackagePeripheralFamilies(PinConfiguration cfg) {
		val peripheralSet = new HashSet<String>
		
		val pack = GpioCfgHelper.instance.getPack(cfg)
		if (pack !== null) {
			for (packagePin : pack.pins) {
				val configurablePins = packagePin.pinConfigurations.filter(ConfigurablePin)
				for (pinConfig : configurablePins) {
					var ref = pinConfig.ref
					for (f : ref.functions) {
						if (f.name.peripheralRef !== null) {
							peripheralSet.add(f.name.peripheralRef.label)
						}
					}
				}
			}
		}
		// println("peripherals families: "+peripheralSet.join(","))
		peripheralSet.sort.map[it|new OutlinePeripheralFamily(cfg, it
		)].toSet
	}


	// LOW: (StellarERCR #1254100: SR6 functions proposed on C4 pinmap, but only present on C6
	def List<Function> getFunctions(Configuration config, Peripheral periph) {
		val list = newArrayList
		val functions = config.functions
		list.addAll(functions.filter [ it |
			it.name.peripheralRef !== null && it.name.peripheralRef.name.equals(periph.name)
		].map[it|it.name])
		list
	}
	// )

	def getPackagePeripherals(Package pack, OutlinePeripheralFamily displayName) {

		if (pack === null) {
			return newArrayList
		}
		// Map of functions : maps set of functions related to a peripheral
		var functionsMap = new HashMap<String, Set<String>>

		var Set<Peripheral> peripheralNameSet = new HashSet<Peripheral>
		for (pin : pack.pins) {
			for (cfg : pin.pinConfigurations.filter(ConfigurablePin)) {
				for (fctref : cfg.ref.functions) {
					val periphName = fctref.name.peripheralRef.name
					val periphDisplayName = fctref.name.peripheralRef.label
					var Set<String> funcList = functionsMap.get(periphName)
					if (funcList === null) {
						funcList = new HashSet<String>
						functionsMap.put(periphName, funcList)
					}
					val validFunctions = cfg.ref.getFunctions(fctref.name.peripheralRef)
					for (f : validFunctions) {
						if (displayName.name.equals(periphDisplayName)) {
							funcList.add(f.name)
						}
					}

					if (validFunctions.size > 0) {
						// Get the list of peripherals associated to the peripheral (create it if needed)
						peripheralNameSet.add(fctref.name.peripheralRef)
					// peripheralList.add(fctref.name.peripheralRef)
					}
				}
			}
		}
		return peripheralNameSet.toList
	}

	def dispose() {
		if (peripherals !== null) {
			for(OutlinePeripheral f : peripherals) {
				f.dispose();
			}
			peripherals.clear();
			peripherals = null;
		}
	}

}
