"use strict";
(self["webpackChunkgpiocfg_eclipse"] = self["webpackChunkgpiocfg_eclipse"] || []).push([["node_modules_vscode-ws-jsonrpc_lib_index_js"],{

/***/ "../node_modules/vscode-ws-jsonrpc/lib/connection.js":
/*!***********************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/connection.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "listen": () => (/* binding */ listen),
/* harmony export */   "toSocket": () => (/* binding */ toSocket)
/* harmony export */ });
/* harmony import */ var _socket_connection_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./socket/connection.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/connection.js");
/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./logger.js */ "../node_modules/vscode-ws-jsonrpc/lib/logger.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */


function listen(options) {
    const { webSocket, onConnection } = options;
    const logger = options.logger || new _logger_js__WEBPACK_IMPORTED_MODULE_1__.ConsoleLogger();
    webSocket.onopen = () => {
        const socket = toSocket(webSocket);
        const connection = (0,_socket_connection_js__WEBPACK_IMPORTED_MODULE_0__.createWebSocketConnection)(socket, logger);
        onConnection(connection);
    };
}
function toSocket(webSocket) {
    return {
        send: content => webSocket.send(content),
        onMessage: cb => {
            webSocket.onmessage = event => cb(event.data);
        },
        onError: cb => {
            webSocket.onerror = event => {
                if ('message' in event) {
                    cb(event.message);
                }
            };
        },
        onClose: cb => {
            webSocket.onclose = event => cb(event.code, event.reason);
        },
        dispose: () => webSocket.close()
    };
}


/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/disposable.js":
/*!***********************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/disposable.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Disposable": () => (/* reexport safe */ vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__.Disposable),
/* harmony export */   "DisposableCollection": () => (/* binding */ DisposableCollection)
/* harmony export */ });
/* harmony import */ var vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode-jsonrpc */ "../node_modules/vscode-jsonrpc/lib/browser/main.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */

class DisposableCollection {
    disposables = [];
    dispose() {
        while (this.disposables.length !== 0) {
            this.disposables.pop().dispose();
        }
    }
    push(disposable) {
        const disposables = this.disposables;
        disposables.push(disposable);
        return {
            dispose() {
                const index = disposables.indexOf(disposable);
                if (index !== -1) {
                    disposables.splice(index, 1);
                }
            }
        };
    }
}



/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/index.js":
/*!******************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AbstractMessageSignature": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.AbstractMessageSignature),
/* harmony export */   "ConsoleLogger": () => (/* reexport safe */ _logger_js__WEBPACK_IMPORTED_MODULE_4__.ConsoleLogger),
/* harmony export */   "Disposable": () => (/* reexport safe */ _disposable_js__WEBPACK_IMPORTED_MODULE_2__.Disposable),
/* harmony export */   "DisposableCollection": () => (/* reexport safe */ _disposable_js__WEBPACK_IMPORTED_MODULE_2__.DisposableCollection),
/* harmony export */   "ErrorCodes": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.ErrorCodes),
/* harmony export */   "Message": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.Message),
/* harmony export */   "NotificationType": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType),
/* harmony export */   "NotificationType0": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType0),
/* harmony export */   "NotificationType1": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType1),
/* harmony export */   "NotificationType2": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType2),
/* harmony export */   "NotificationType3": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType3),
/* harmony export */   "NotificationType4": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType4),
/* harmony export */   "NotificationType5": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType5),
/* harmony export */   "NotificationType6": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType6),
/* harmony export */   "NotificationType7": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType7),
/* harmony export */   "NotificationType8": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType8),
/* harmony export */   "NotificationType9": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.NotificationType9),
/* harmony export */   "ParameterStructures": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.ParameterStructures),
/* harmony export */   "RequestType": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType),
/* harmony export */   "RequestType0": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType0),
/* harmony export */   "RequestType1": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType1),
/* harmony export */   "RequestType2": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType2),
/* harmony export */   "RequestType3": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType3),
/* harmony export */   "RequestType4": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType4),
/* harmony export */   "RequestType5": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType5),
/* harmony export */   "RequestType6": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType6),
/* harmony export */   "RequestType7": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType7),
/* harmony export */   "RequestType8": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType8),
/* harmony export */   "RequestType9": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.RequestType9),
/* harmony export */   "ResponseError": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.ResponseError),
/* harmony export */   "WebSocketMessageReader": () => (/* reexport safe */ _socket_index_js__WEBPACK_IMPORTED_MODULE_3__.WebSocketMessageReader),
/* harmony export */   "WebSocketMessageWriter": () => (/* reexport safe */ _socket_index_js__WEBPACK_IMPORTED_MODULE_3__.WebSocketMessageWriter),
/* harmony export */   "__esModule": () => (/* reexport safe */ vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__.__esModule),
/* harmony export */   "createWebSocketConnection": () => (/* reexport safe */ _socket_index_js__WEBPACK_IMPORTED_MODULE_3__.createWebSocketConnection),
/* harmony export */   "listen": () => (/* reexport safe */ _connection_js__WEBPACK_IMPORTED_MODULE_5__.listen),
/* harmony export */   "toSocket": () => (/* reexport safe */ _connection_js__WEBPACK_IMPORTED_MODULE_5__.toSocket)
/* harmony export */ });
/* harmony import */ var vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode-jsonrpc */ "../node_modules/vscode-jsonrpc/lib/browser/main.js");
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(const __WEBPACK_IMPORT_KEY__ in vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__) if(__WEBPACK_IMPORT_KEY__ !== "default") __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = () => vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__[__WEBPACK_IMPORT_KEY__]
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);
/* harmony import */ var vscode_jsonrpc_lib_common_messages_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vscode-jsonrpc/lib/common/messages.js */ "../node_modules/vscode-jsonrpc/lib/common/messages.js");
/* harmony import */ var _disposable_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./disposable.js */ "../node_modules/vscode-ws-jsonrpc/lib/disposable.js");
/* harmony import */ var _socket_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./socket/index.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/index.js");
/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./logger.js */ "../node_modules/vscode-ws-jsonrpc/lib/logger.js");
/* harmony import */ var _connection_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./connection.js */ "../node_modules/vscode-ws-jsonrpc/lib/connection.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */








/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/logger.js":
/*!*******************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/logger.js ***!
  \*******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ConsoleLogger": () => (/* binding */ ConsoleLogger)
/* harmony export */ });
class ConsoleLogger {
    error(message) {
        console.error(message);
    }
    warn(message) {
        console.warn(message);
    }
    info(message) {
        console.info(message);
    }
    log(message) {
        console.log(message);
    }
    debug(message) {
        console.debug(message);
    }
}


/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/socket/connection.js":
/*!******************************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/socket/connection.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createWebSocketConnection": () => (/* binding */ createWebSocketConnection)
/* harmony export */ });
/* harmony import */ var vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode-jsonrpc */ "../node_modules/vscode-jsonrpc/lib/browser/main.js");
/* harmony import */ var _reader_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reader.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/reader.js");
/* harmony import */ var _writer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./writer.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/writer.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */



function createWebSocketConnection(socket, logger) {
    const messageReader = new _reader_js__WEBPACK_IMPORTED_MODULE_1__.WebSocketMessageReader(socket);
    const messageWriter = new _writer_js__WEBPACK_IMPORTED_MODULE_2__.WebSocketMessageWriter(socket);
    const connection = (0,vscode_jsonrpc__WEBPACK_IMPORTED_MODULE_0__.createMessageConnection)(messageReader, messageWriter, logger);
    connection.onClose(() => connection.dispose());
    return connection;
}


/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/socket/index.js":
/*!*************************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/socket/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WebSocketMessageReader": () => (/* reexport safe */ _reader_js__WEBPACK_IMPORTED_MODULE_1__.WebSocketMessageReader),
/* harmony export */   "WebSocketMessageWriter": () => (/* reexport safe */ _writer_js__WEBPACK_IMPORTED_MODULE_2__.WebSocketMessageWriter),
/* harmony export */   "createWebSocketConnection": () => (/* reexport safe */ _connection_js__WEBPACK_IMPORTED_MODULE_3__.createWebSocketConnection)
/* harmony export */ });
/* harmony import */ var _socket_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./socket.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/socket.js");
/* harmony import */ var _reader_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reader.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/reader.js");
/* harmony import */ var _writer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./writer.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/writer.js");
/* harmony import */ var _connection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./connection.js */ "../node_modules/vscode-ws-jsonrpc/lib/socket/connection.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */






/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/socket/reader.js":
/*!**************************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/socket/reader.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WebSocketMessageReader": () => (/* binding */ WebSocketMessageReader)
/* harmony export */ });
/* harmony import */ var vscode_jsonrpc_lib_common_messageReader_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode-jsonrpc/lib/common/messageReader.js */ "../node_modules/vscode-jsonrpc/lib/common/messageReader.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */

class WebSocketMessageReader extends vscode_jsonrpc_lib_common_messageReader_js__WEBPACK_IMPORTED_MODULE_0__.AbstractMessageReader {
    socket;
    state = 'initial';
    callback;
    events = [];
    constructor(socket) {
        super();
        this.socket = socket;
        this.socket.onMessage(message => this.readMessage(message));
        this.socket.onError(error => this.fireError(error));
        this.socket.onClose((code, reason) => {
            if (code !== 1000) {
                const error = {
                    name: '' + code,
                    message: `Error during socket reconnect: code = ${code}, reason = ${reason}`
                };
                this.fireError(error);
            }
            this.fireClose();
        });
    }
    listen(callback) {
        if (this.state === 'initial') {
            this.state = 'listening';
            this.callback = callback;
            while (this.events.length !== 0) {
                const event = this.events.pop();
                if (event.message) {
                    this.readMessage(event.message);
                }
                else if (event.error) {
                    this.fireError(event.error);
                }
                else {
                    this.fireClose();
                }
            }
        }
        return {
            dispose: () => {
                if (this.callback === callback) {
                    this.callback = undefined;
                }
            }
        };
    }
    readMessage(message) {
        if (this.state === 'initial') {
            this.events.splice(0, 0, { message });
        }
        else if (this.state === 'listening') {
            try {
                const data = JSON.parse(message);
                this.callback(data);
            }
            catch (err) {
                const error = {
                    name: '' + 400,
                    message: `Error during message parsing, reason = ${typeof err === 'object' ? err.message : 'unknown'}`
                };
                this.fireError(error);
            }
        }
    }
    fireError(error) {
        if (this.state === 'initial') {
            this.events.splice(0, 0, { error });
        }
        else if (this.state === 'listening') {
            super.fireError(error);
        }
    }
    fireClose() {
        if (this.state === 'initial') {
            this.events.splice(0, 0, {});
        }
        else if (this.state === 'listening') {
            super.fireClose();
        }
        this.state = 'closed';
    }
}


/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/socket/socket.js":
/*!**************************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/socket/socket.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */



/***/ }),

/***/ "../node_modules/vscode-ws-jsonrpc/lib/socket/writer.js":
/*!**************************************************************!*\
  !*** ../node_modules/vscode-ws-jsonrpc/lib/socket/writer.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WebSocketMessageWriter": () => (/* binding */ WebSocketMessageWriter)
/* harmony export */ });
/* harmony import */ var vscode_jsonrpc_lib_common_messageWriter_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vscode-jsonrpc/lib/common/messageWriter.js */ "../node_modules/vscode-jsonrpc/lib/common/messageWriter.js");
/* --------------------------------------------------------------------------------------------
 * Copyright (c) 2018-2022 TypeFox GmbH (http://www.typefox.io). All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */

class WebSocketMessageWriter extends vscode_jsonrpc_lib_common_messageWriter_js__WEBPACK_IMPORTED_MODULE_0__.AbstractMessageWriter {
    socket;
    errorCount = 0;
    constructor(socket) {
        super();
        this.socket = socket;
    }
    end() {
    }
    async write(msg) {
        try {
            const content = JSON.stringify(msg);
            this.socket.send(content);
        }
        catch (e) {
            this.errorCount++;
            this.fireError(e, msg, this.errorCount);
        }
    }
}


/***/ })

}]);
//# sourceMappingURL=node_modules_vscode-ws-jsonrpc_lib_index_js.bundle.js.map